/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j;

import java.math.BigInteger;
import org.sat4j.AbstractLauncher;
import org.sat4j.ExitCode;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.reader.OPBReader2005;
import org.sat4j.reader.ObjectiveFunction;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.TimeoutException;

public class LanceurPseudo2005
extends AbstractLauncher {
    private static final String CURRENT_OPTIMUM_VALUE_PREFIX = "o ";
    protected int[] bestSolution;
    protected ObjectiveFunction obfct;

    public static void main(String[] stringArray) {
        LanceurPseudo2005 lanceurPseudo2005 = new LanceurPseudo2005();
        lanceurPseudo2005.run(stringArray);
    }

    protected void displayResult(ISolver iSolver, long l, ExitCode exitCode) {
        if (iSolver != null) {
            iSolver.printStat(System.out, "c ");
            System.out.println("s " + (Object)((Object)exitCode));
            if (exitCode == ExitCode.SATISFIABLE || exitCode == ExitCode.OPTIMUM_FOUND) {
                System.out.println("v " + this.reader.decode(this.bestSolution));
                if (this.obfct != null) {
                    this.log("objective function=" + this.obfct.calculateDegree(this.bestSolution));
                }
            }
            this.log("Total CPU time (ms): " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
    }

    protected Reader createReader(ISolver iSolver) {
        return new OPBReader2005(iSolver);
    }

    protected void solve(IProblem iProblem) throws TimeoutException {
        boolean bl = false;
        this.obfct = ((OPBReader2005)this.reader).getObjectiveFunction();
        try {
            while (iProblem.isSatisfiable()) {
                if (!bl) {
                    this.exitcode = ExitCode.SATISFIABLE;
                    this.bestSolution = iProblem.model();
                    if (this.obfct == null) {
                        return;
                    }
                    bl = true;
                    this.log("SATISFIABLE");
                    this.log("OPTIMIZING...");
                } else {
                    this.bestSolution = iProblem.model();
                }
                this.log("Got one! Ellapsed CPU time (in seconds):" + (double)(System.currentTimeMillis() - this.begintime) / 1000.0);
                System.out.println(CURRENT_OPTIMUM_VALUE_PREFIX + this.obfct.calculateDegree(this.bestSolution));
                this.solver.addPseudoBoolean(this.obfct.getVars(), this.obfct.getCoeffs(), false, this.obfct.calculateDegree(this.bestSolution).subtract(BigInteger.ONE));
            }
            this.exitcode = bl ? ExitCode.OPTIMUM_FOUND : ExitCode.UNSATISFIABLE;
        }
        catch (ContradictionException contradictionException) {
            assert (bl);
            this.exitcode = ExitCode.OPTIMUM_FOUND;
        }
    }

    protected ISolver configureSolver(String[] stringArray) {
        ISolver iSolver = SolverFactory.newMiniOPBMin();
        iSolver.setTimeout(Integer.MAX_VALUE);
        System.out.println(iSolver.toString("c "));
        return iSolver;
    }

    protected void usage() {
        System.out.println("java -jar sat4jPseudo instancename.opb");
    }

    protected String getInstanceName(String[] stringArray) {
        assert (stringArray.length == 1);
        return stringArray[0];
    }
}

