/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.apps.sudoku;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.sat4j.apps.sudoku.GUIInput;
import org.sat4j.apps.sudoku.OneCell;
import org.sat4j.apps.sudoku.SDSize;

class CellGrid
extends JPanel {
    OneCell[][] cells;
    SDSize sdSize;
    GUIInput guiInput;

    CellGrid(SDSize sDSize, GUIInput gUIInput) {
        this.sdSize = sDSize;
        this.guiInput = gUIInput;
        this.setLayout(new BoxLayout(this, 1));
        this.setMaximumSize(new Dimension(1000, 1000));
        Box box = Box.createVerticalBox();
        this.cells = new OneCell[sDSize.getLargeSide()][sDSize.getLargeSide()];
        for (int i = 0; i < sDSize.getLargeSide(); ++i) {
            if (i > 0 && i % sDSize.getSmallSide() == 0) {
                box.add(Box.createRigidArea(new Dimension(22 * sDSize.getLargeSide(), 3)));
            }
            Box box2 = Box.createHorizontalBox();
            for (int j = 0; j < sDSize.getLargeSide(); ++j) {
                if (j > 0 && j % sDSize.getSmallSide() == 0) {
                    box2.add(Box.createRigidArea(new Dimension(3, 22)));
                }
                this.cells[i][j] = new OneCell(sDSize.getLargeSide(), gUIInput, this.cellColors(i, j));
                box2.add(this.cells[i][j]);
            }
            box.add(box2);
        }
        this.add(Box.createVerticalGlue());
        box.setMaximumSize(new Dimension(22 * sDSize.getLargeSide(), 22 * sDSize.getLargeSide()));
        this.add(box);
        this.add(Box.createVerticalGlue());
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(0), "SuDoku Puzzle"));
    }

    Color[] cellColors(int n, int n2) {
        int n3;
        int n4 = n / this.sdSize.getSmallSide();
        return n4 % 2 == (n3 = n2 / this.sdSize.getSmallSide()) % 2 ? this.guiInput.getBlueColors() : this.guiInput.getWhiteColors();
    }

    public int getIntValue(int n, int n2) {
        return this.cells[n - 1][n2 - 1].getIntValue();
    }

    public int getStatus(int n, int n2) {
        return this.cells[n - 1][n2 - 1].getStatus();
    }

    public void setIntValue(int n, int n2, int n3) {
        if (1 <= n && n <= this.sdSize.getLargeSide() && 1 <= n2 && n2 <= this.sdSize.getLargeSide()) {
            this.cells[n - 1][n2 - 1].setIntValue(n3);
        }
    }

    public void solverSetIntValue(int n, int n2, int n3) {
        if (1 <= n && n <= this.sdSize.getLargeSide() && 1 <= n2 && n2 <= this.sdSize.getLargeSide()) {
            this.cells[n - 1][n2 - 1].solverSetIntValue(n3);
        }
    }

    public void clear() {
        for (int i = 0; i < this.sdSize.getLargeSide(); ++i) {
            for (int j = 0; j < this.sdSize.getLargeSide(); ++j) {
                this.cells[i][j].clear();
            }
        }
    }

    public void refreshCells() {
        for (int i = 0; i < this.sdSize.getLargeSide(); ++i) {
            for (int j = 0; j < this.sdSize.getLargeSide(); ++j) {
                this.cells[i][j].refresh();
            }
        }
    }

    public void clearComputers() {
        for (int i = 0; i < this.sdSize.getLargeSide(); ++i) {
            for (int j = 0; j < this.sdSize.getLargeSide(); ++j) {
                this.cells[i][j].clearComputers();
            }
        }
    }

    public void protect() {
        for (int i = 0; i < this.sdSize.getLargeSide(); ++i) {
            for (int j = 0; j < this.sdSize.getLargeSide(); ++j) {
                this.cells[i][j].protectIfNotClear();
            }
        }
    }

    public void clearProtection() {
        for (int i = 0; i < this.sdSize.getLargeSide(); ++i) {
            for (int j = 0; j < this.sdSize.getLargeSide(); ++j) {
                this.cells[i][j].clearProtection();
            }
        }
    }

    public void clearAll() {
        for (int i = 0; i < this.sdSize.getLargeSide(); ++i) {
            for (int j = 0; j < this.sdSize.getLargeSide(); ++j) {
                this.cells[i][j].clearProtection();
                this.cells[i][j].clear();
            }
        }
    }

    public void unHighlightAll() {
        for (int i = 0; i < this.sdSize.getLargeSide(); ++i) {
            for (int j = 0; j < this.sdSize.getLargeSide(); ++j) {
                this.cells[i][j].unHighlight();
            }
        }
    }

    public void highlight(int n, int n2) {
        this.cells[n - 1][n2 - 1].highlight();
    }
}

