/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.apps.sudoku;

import java.util.Random;
import java.util.Vector;
import org.sat4j.apps.sudoku.Coordinate;
import org.sat4j.apps.sudoku.RandomPermutation;

public class CoordinateSet {
    Vector coordinates = new Vector();
    Random random = new Random();
    int rows;
    int columns;

    CoordinateSet(int n, int n2) {
        this.rows = n;
        this.columns = n2;
        for (int i = 1; i <= n; ++i) {
            for (int j = 1; j <= n2; ++j) {
                this.coordinates.add(new Coordinate(i, j));
            }
        }
    }

    public Coordinate[] getGroup() {
        Coordinate coordinate = null;
        if (this.rows % 2 == 1) {
            coordinate = new Coordinate((this.rows + 1) / 2, (this.columns + 1) / 2);
            this.remove(coordinate);
        }
        Coordinate[] coordinateArray = new Coordinate[4];
        coordinateArray[0] = this.getCoordinate();
        if (coordinateArray[0].getRow() * 2 == this.rows + 1) {
            coordinateArray[1] = new Coordinate(coordinateArray[0].getRow(), this.columns + 1 - coordinateArray[0].getColumn());
            coordinateArray[2] = new Coordinate(coordinateArray[0].getColumn(), coordinateArray[0].getRow());
            coordinateArray[3] = new Coordinate(this.columns + 1 - coordinateArray[0].getColumn(), coordinateArray[0].getRow());
        } else if (coordinateArray[0].getColumn() * 2 == this.columns + 1) {
            coordinateArray[1] = new Coordinate(coordinateArray[0].getColumn(), coordinateArray[0].getRow());
            coordinateArray[2] = new Coordinate(this.rows + 1 - coordinateArray[0].getRow(), coordinateArray[0].getColumn());
            coordinateArray[3] = new Coordinate(coordinateArray[0].getColumn(), this.rows + 1 - coordinateArray[0].getRow());
        } else {
            coordinateArray[1] = new Coordinate(coordinateArray[0].getRow(), this.columns + 1 - coordinateArray[0].getColumn());
            coordinateArray[2] = new Coordinate(this.rows + 1 - coordinateArray[0].getRow(), coordinateArray[0].getColumn());
            coordinateArray[3] = new Coordinate(this.rows + 1 - coordinateArray[0].getRow(), this.columns + 1 - coordinateArray[0].getColumn());
        }
        for (int i = 1; i <= 3; ++i) {
            this.remove(coordinateArray[i]);
        }
        if (this.rows % 2 == 1) {
            this.coordinates.add(coordinate);
        }
        return coordinateArray;
    }

    void remove(Coordinate coordinate) {
        int n = coordinate.getRow();
        int n2 = coordinate.getColumn();
        boolean bl = false;
        for (int i = 0; !bl && i < this.coordinates.size(); ++i) {
            Coordinate coordinate2 = (Coordinate)this.coordinates.elementAt(i);
            if (coordinate2.getRow() != n || coordinate2.getColumn() != n2) continue;
            this.coordinates.remove(i);
            bl = true;
        }
    }

    public Coordinate[] getRandomArray() {
        Coordinate[] coordinateArray = new Coordinate[this.coordinates.size()];
        int n = 0;
        while (this.coordinates.size() > 0) {
            if (this.coordinates.size() >= 400) {
                Coordinate[] coordinateArray2 = this.getGroup();
                for (int i = 0; i < coordinateArray2.length; ++i) {
                    coordinateArray[n++] = coordinateArray2[i];
                }
                continue;
            }
            coordinateArray[n++] = this.getCoordinate();
        }
        return coordinateArray;
    }

    public Coordinate[] getSpreadArray() {
        RandomPermutation randomPermutation = new RandomPermutation(this.rows);
        RandomPermutation randomPermutation2 = new RandomPermutation(this.columns);
        Coordinate[] coordinateArray = new Coordinate[this.rows];
        for (int i = 1; i <= this.rows; ++i) {
            coordinateArray[i - 1] = new Coordinate(randomPermutation.permute(i), randomPermutation2.permute(i));
        }
        return coordinateArray;
    }

    public Coordinate getCoordinate() {
        int n = this.random.nextInt(this.coordinates.size());
        Coordinate coordinate = (Coordinate)this.coordinates.elementAt(n);
        this.coordinates.remove(n);
        return coordinate;
    }
}

