/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.apps.sudoku;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.sat4j.apps.sudoku.CellGrid;
import org.sat4j.apps.sudoku.MainProgramWindow;
import org.sat4j.apps.sudoku.OneCell;
import org.sat4j.apps.sudoku.SDSize;
import org.sat4j.apps.sudoku.SuDoku;

class GUIInput
extends JTabbedPane {
    Color[] blueColors;
    Color[] whiteColors;
    static Color userColor = Color.WHITE;
    static Color solverColor = new Color(255, 230, 230);
    static Color highlightColor = Color.RED;
    SDSize sdSize;
    boolean protectionSet = false;
    CellGrid cellGrid;
    JButton check;
    JButton solve;
    JButton exit;
    JButton clear;
    JButton clearComputers;
    JButton protect;
    JButton clearAll;
    JButton twoSize;
    JButton threeSize;
    JButton fourSize;
    JButton fiveSize;
    JButton sixSize;
    JButton protectedColor;
    JButton saveCNF;
    JButton readModel;
    JButton create;
    OneCell fillCount;
    JSpinner.DefaultEditor fillCountEditor;
    JCheckBox onlyCreateUnique;
    JTextField result;
    JTextArea cnfFile;
    JTextArea cnfModel;
    JScrollPane cnfScroll;
    JScrollPane modelScroll;
    JButton fullCNF;
    JButton simplerCNF;
    JButton showModel;
    JButton interpretModel;
    Box gridTab;
    Box gridAndControls;
    MainProgramWindow mainProgramWindow;
    SuDoku sudoku;

    GUIInput(MainProgramWindow mainProgramWindow, SDSize sDSize, SuDoku suDoku, int n) {
        this.mainProgramWindow = mainProgramWindow;
        this.sdSize = sDSize;
        this.sudoku = suDoku;
        this.blueColors = new Color[OneCell.getNumberOfColours()];
        this.blueColors[0] = new Color(0, 0, 0);
        this.blueColors[5] = new Color(230, 230, 255);
        this.blueColors[1] = new Color(255, 0, 0);
        this.blueColors[2] = new Color(100, 100, 255);
        this.blueColors[4] = new Color(51, 51, 255);
        this.whiteColors = new Color[OneCell.getNumberOfColours()];
        this.whiteColors[0] = new Color(0, 0, 0);
        this.whiteColors[1] = new Color(255, 0, 0);
        this.whiteColors[5] = new Color(255, 255, 255);
        this.whiteColors[2] = new Color(100, 100, 255);
        this.whiteColors[4] = new Color(51, 51, 255);
        this.cellGrid = new CellGrid(sDSize, this);
        this.gridTab = Box.createVerticalBox();
        this.gridTab.add(Box.createRigidArea(new Dimension(700, 1)));
        this.gridAndControls = Box.createHorizontalBox();
        this.gridTab.add(this.gridAndControls);
        this.add((Component)this.gridTab, "Puzzle");
        this.gridAndControls.add(this.cellGrid);
        Box box = Box.createVerticalBox();
        Box box2 = Box.createHorizontalBox();
        this.create = new JButton("Create");
        this.create.addActionListener(new CreateActionListener());
        box2.add(this.create);
        this.fillCount = new OneCell(sDSize.getLargeSide() * sDSize.getLargeSide(), this, this.whiteColors);
        this.fillCount.setIntValue(sDSize.getLargeSide());
        this.fillCount.setColumns(3);
        this.fillCount.setMaximumSize(new Dimension(50, 25));
        box2.add(Box.createHorizontalStrut(10));
        box2.add(new JLabel("Filled cells:"));
        box2.add(this.fillCount);
        this.onlyCreateUnique = new JCheckBox("Unique");
        this.onlyCreateUnique.addActionListener(new OnlyCreateUniqueActionListener());
        box2.add(this.onlyCreateUnique);
        box2.add(Box.createHorizontalStrut(20));
        box.add(box2);
        Box box3 = Box.createHorizontalBox();
        this.protect = new JButton("Protect cells");
        this.protect.addActionListener(new ProtectActionListener());
        box3.add(this.protect);
        box.add(box3);
        box.add(Box.createRigidArea(new Dimension(300, 1)));
        Box box4 = Box.createHorizontalBox();
        this.check = new JButton("Check");
        this.check.addActionListener(new CheckActionListener());
        box4.add(this.check);
        this.solve = new JButton("Solve");
        this.solve.addActionListener(new SolveActionListener());
        box4.add(this.solve);
        box.add(box4);
        Box box5 = Box.createHorizontalBox();
        this.clearComputers = new JButton("Clear solver's");
        this.clearComputers.addActionListener(new ClearComputersActionListener());
        box5.add(this.clearComputers);
        this.clear = new JButton("Clear mine too");
        this.clear.addActionListener(new ClearActionListener());
        box5.add(this.clear);
        box.add(box5);
        Box box6 = Box.createHorizontalBox();
        this.twoSize = new JButton("4 x 4");
        this.twoSize.addActionListener(new GridSizeListener(2));
        box6.add(this.twoSize);
        this.threeSize = new JButton("9 x 9");
        this.threeSize.addActionListener(new GridSizeListener(3));
        box6.add(this.threeSize);
        this.fourSize = new JButton("16 x 16");
        this.fourSize.addActionListener(new GridSizeListener(4));
        box6.add(this.fourSize);
        box.add(box6);
        if (n >= 25) {
            Box box7 = Box.createHorizontalBox();
            this.fiveSize = new JButton("25 x 25");
            this.fiveSize.addActionListener(new GridSizeListener(5));
            box7.add(this.fiveSize);
            if (n >= 36) {
                this.sixSize = new JButton("36 x 36");
                this.sixSize.addActionListener(new GridSizeListener(6));
                box7.add(this.sixSize);
            }
            box.add(box7);
        }
        Box box8 = Box.createHorizontalBox();
        box8.add(new JLabel("Set colours"));
        box8.add(new ColorButton(4, "Protected"));
        box8.add(new ColorButton(1, "Solver's"));
        box8.add(new ColorButton(0, "Mine"));
        box.add(Box.createVerticalGlue());
        box.add(box8);
        box.add(Box.createVerticalGlue());
        this.result = new JTextField(20);
        this.result.setMaximumSize(new Dimension(368, 25));
        box.add(this.result);
        box.add(Box.createVerticalGlue());
        this.gridAndControls.add(box);
        Box box9 = Box.createHorizontalBox();
        Box box10 = Box.createVerticalBox();
        box10.add(new JLabel("cnf problem"));
        this.cnfFile = new JTextArea(20, 20);
        this.cnfFile.setEditable(false);
        this.cnfScroll = new JScrollPane(this.cnfFile);
        box10.add(this.cnfScroll);
        box9.add(box10);
        Box box11 = Box.createVerticalBox();
        box11.add(new JLabel("solution"));
        this.cnfModel = new JTextArea(10, 10);
        this.modelScroll = new JScrollPane(this.cnfModel);
        box11.add(this.modelScroll);
        box9.add(Box.createHorizontalStrut(4));
        box9.add(box11);
        Box box12 = Box.createVerticalBox();
        Box box13 = Box.createHorizontalBox();
        this.fullCNF = new JButton("Full cnf");
        this.fullCNF.addActionListener(new FullCNFActionListener());
        box13.add(this.fullCNF);
        this.simplerCNF = new JButton("Simpler cnf");
        this.simplerCNF.addActionListener(new SimplerCNFActionListener());
        box13.add(this.simplerCNF);
        box12.add(box13);
        Box box14 = Box.createHorizontalBox();
        this.showModel = new JButton("Show Model");
        this.showModel.addActionListener(new ShowModelActionListener());
        this.showModel.setEnabled(true);
        box14.add(this.showModel);
        this.interpretModel = new JButton("Interpret Model");
        this.interpretModel.addActionListener(new InterpretModelActionListener());
        box14.add(this.interpretModel);
        box12.add(box14);
        if (mainProgramWindow.fileAccess()) {
            Box box15 = Box.createHorizontalBox();
            this.saveCNF = new JButton("Save cnf to file");
            this.saveCNF.addActionListener(new SaveCNFActionListener());
            box15.add(this.saveCNF);
            this.readModel = new JButton("Read model from file");
            this.readModel.addActionListener(new ReadModelActionListener());
            box15.add(this.readModel);
            box12.add(box15);
        }
        box9.add(Box.createRigidArea(new Dimension(4, 400)));
        box9.add(box12);
        this.add((Component)box9, "CNF");
        this.setVisible(true);
    }

    public void puzzleChanged() {
        this.cnfModel.setText("");
        this.cnfFile.setText("");
        this.showModel.setEnabled(false);
    }

    public void setResult(String string) {
        this.result.setText(string);
    }

    public void setCNFFile(String string) {
        this.cnfFile.setText(string);
    }

    public String getCNFFile() {
        return this.cnfFile.getText();
    }

    public void setCNFModel(String string) {
        this.cnfModel.setText(string);
    }

    public String getCNFModel() {
        return this.cnfModel.getText();
    }

    public void clearCNF() {
        this.setCNFFile("");
        this.setCNFModel("");
    }

    public CellGrid getCellGrid() {
        return this.cellGrid;
    }

    public void setColor(int n, Color color) {
        this.blueColors[n] = color;
        this.whiteColors[n] = color;
        this.cellGrid.refreshCells();
    }

    public void setSize(int n, int n2) {
        this.mainProgramWindow.setMainWindowSize(n, n2);
        super.setSize(n, n2);
    }

    public void setFillCount(int n) {
        this.fillCount.clearProtection();
        this.fillCount.setText("" + n);
        this.fillCount.protect();
    }

    public Color[] getBlueColors() {
        return this.blueColors;
    }

    public Color[] getWhiteColors() {
        return this.whiteColors;
    }

    long memoryNeeded() {
        long l = 0L;
        switch (this.sdSize.getLargeSide()) {
            case 4: {
                l = 20000000L;
                break;
            }
            case 9: {
                l = 50000000L;
                break;
            }
            case 16: {
                l = 50000000L;
                break;
            }
            case 25: {
                l = 50000000L;
            }
        }
        return l;
    }

    boolean enoughMemory() {
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.maxMemory();
        boolean bl = l > this.memoryNeeded();
        return bl;
    }

    void solve(boolean bl) {
        this.setResult("");
        if (this.enoughMemory()) {
            try {
                this.sudoku.graphicalSolve(this.cellGrid, bl);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            this.notEnoughMemory();
        }
    }

    void notEnoughMemory() {
        this.setResult("For this grid, java memory of " + this.memoryNeeded() + " needed");
    }

    void setProtection(boolean bl) {
        if (bl) {
            this.cellGrid.protect();
            this.protect.setText("Unprotect");
            this.protectionSet = true;
        } else {
            this.cellGrid.clearProtection();
            this.protect.setText("Protect cells");
            this.protectionSet = false;
        }
    }

    class ReadModelActionListener
    implements ActionListener {
        ReadModelActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUIInput.this.setCNFModel(GUIInput.this.mainProgramWindow.readFile());
        }
    }

    class SaveCNFActionListener
    implements ActionListener {
        SaveCNFActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUIInput.this.mainProgramWindow.writeFile(GUIInput.this.getCNFFile());
        }
    }

    class ExitActionListener
    implements ActionListener {
        ExitActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUIInput.this.setResult("");
            System.exit(1);
        }
    }

    class ClearAllActionListener
    implements ActionListener {
        ClearAllActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUIInput.this.setResult("");
            GUIInput.this.clearCNF();
            GUIInput.this.cellGrid.clearAll();
        }
    }

    class ProtectActionListener
    implements ActionListener {
        ProtectActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUIInput.this.setResult("");
            GUIInput.this.setProtection(!GUIInput.this.protectionSet);
        }
    }

    class ClearComputersActionListener
    implements ActionListener {
        ClearComputersActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUIInput.this.setResult("");
            GUIInput.this.cellGrid.clearComputers();
        }
    }

    class ClearActionListener
    implements ActionListener {
        ClearActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUIInput.this.setResult("");
            GUIInput.this.clearCNF();
            GUIInput.this.cellGrid.clear();
        }
    }

    class GridSizeListener
    implements ActionListener {
        int side;

        GridSizeListener(int n) {
            this.side = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUIInput.this.setResult("");
            GUIInput.this.sdSize.setSide(this.side);
            CellGrid cellGrid = new CellGrid(GUIInput.this.sdSize, GUIInput.this);
            GUIInput.this.fillCount.clearProtection();
            GUIInput.this.fillCount.setMax(GUIInput.this.sdSize.getLargeSide() * GUIInput.this.sdSize.getLargeSide());
            GUIInput.this.fillCount.setIntValue(GUIInput.this.sdSize.getLargeSide());
            GUIInput.this.gridAndControls.remove(GUIInput.this.cellGrid);
            GUIInput.this.cellGrid = cellGrid;
            GUIInput.this.gridAndControls.add((Component)GUIInput.this.cellGrid, 0);
            GUIInput.this.onlyCreateUnique.setSelected(false);
            if (this.side > 4) {
                if (!GUIInput.this.sudoku.getCreateUniqueAllowed()) {
                    GUIInput.this.onlyCreateUnique.setEnabled(false);
                }
                GUIInput.this.mainProgramWindow.maximize();
            } else {
                GUIInput.this.onlyCreateUnique.setEnabled(true);
            }
            GUIInput.this.setProtection(false);
            GUIInput.this.gridTab.validate();
            GUIInput.this.gridTab.repaint();
        }
    }

    class ColorActionListener
    implements ActionListener {
        int id;
        String title;
        ColorButton owner;

        public ColorActionListener(ColorButton colorButton, int n, String string) {
            this.id = n;
            this.title = string;
            this.owner = colorButton;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Color color = JColorChooser.showDialog(GUIInput.this, this.title, GUIInput.this.whiteColors[this.id]);
            if (color != null) {
                GUIInput.this.setColor(this.id, color);
                GUIInput.this.fillCount.refresh();
                this.owner.setForeground(color);
            }
        }
    }

    class ColorButton
    extends JButton {
        ColorButton(int n, String string) {
            super(string);
            this.setBackground(Color.WHITE);
            this.setForeground(GUIInput.this.whiteColors[n]);
            this.addActionListener(new ColorActionListener(this, n, "Set " + string + " colour"));
        }
    }

    class OnlyCreateUniqueActionListener
    implements ActionListener {
        OnlyCreateUniqueActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (GUIInput.this.onlyCreateUnique.isSelected()) {
                GUIInput.this.fillCount.protect();
            } else {
                GUIInput.this.fillCount.clearProtection();
            }
        }
    }

    class InterpretModelActionListener
    implements ActionListener {
        InterpretModelActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUIInput.this.setResult("");
            GUIInput.this.cellGrid.clearComputers();
            GUIInput.this.sudoku.interpretModel(GUIInput.this.cellGrid);
        }
    }

    class ShowModelActionListener
    implements ActionListener {
        ShowModelActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUIInput.this.setResult("");
            GUIInput.this.setCNFModel("");
            GUIInput.this.solve(true);
        }
    }

    class FullCNFActionListener
    implements ActionListener {
        FullCNFActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUIInput.this.setResult("");
            GUIInput.this.sudoku.fullCNF(GUIInput.this.cellGrid);
        }
    }

    class SimplerCNFActionListener
    implements ActionListener {
        SimplerCNFActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUIInput.this.setResult("");
            GUIInput.this.sudoku.simplerCNF(GUIInput.this.cellGrid);
        }
    }

    class SolveActionListener
    implements ActionListener {
        SolveActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUIInput.this.solve(false);
        }
    }

    class CreateActionListener
    implements ActionListener {
        CreateActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUIInput.this.setResult("");
            GUIInput.this.clearCNF();
            if (GUIInput.this.enoughMemory()) {
                GUIInput.this.sudoku.createPuzzle(GUIInput.this.fillCount.getIntValue(), GUIInput.this.cellGrid, GUIInput.this.onlyCreateUnique.isSelected());
            } else {
                GUIInput.this.notEnoughMemory();
            }
        }
    }

    class CheckActionListener
    implements ActionListener {
        CheckActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUIInput.this.setResult("");
            GUIInput.this.sudoku.checkSolution(GUIInput.this.cellGrid);
        }
    }
}

