/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.apps.sudoku;

import java.util.Vector;

public class LineScanner {
    Vector markers;
    String text;
    String line;
    int thisLineStart;
    int thisLineEnd;
    int nextLineStart;

    LineScanner(String string) {
        this.text = string;
        this.thisLineStart = 0;
        this.markers = new Vector();
        this.markers.add("\n");
        this.markers.add("\r");
        this.markers.add("\r\n");
        this.readNextLine();
    }

    private void readNextLine() {
        if (this.thisLineStart >= this.text.length()) {
            this.line = null;
        } else {
            this.nextLineStart = this.thisLineEnd = this.text.length();
            for (int i = 0; i < this.markers.size(); ++i) {
                String string = (String)this.markers.elementAt(i);
                int n = this.text.indexOf(string, this.thisLineStart);
                if (n == -1 || n >= this.thisLineEnd && (n != this.thisLineEnd || n + string.length() <= this.nextLineStart)) continue;
                this.thisLineEnd = n;
                this.nextLineStart = this.thisLineEnd + string.length();
            }
            this.line = this.text.substring(this.thisLineStart, this.thisLineEnd);
            this.thisLineStart = this.nextLineStart;
        }
    }

    public boolean hasNext() {
        return this.line != null;
    }

    public String next() {
        String string = this.line;
        this.readNextLine();
        return string;
    }

    public void close() {
    }
}

