/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.apps.sudoku;

import java.awt.Color;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.sat4j.apps.sudoku.GUIInput;

public class OneCell
extends JTextField {
    int max;
    boolean protcted;
    GUIInput guiInput;
    int status;
    Color[] colors;
    static Color[] nullColors = new Color[]{Color.BLACK, Color.WHITE, Color.RED, Color.WHITE, Color.RED, Color.WHITE};
    public static final int USER_COLOR_ID = 0;
    public static final int SOLVER_COLOR_ID = 1;
    public static final int HIGHLIGHT_COLOR_ID = 2;
    public static final int DISABLED_COLOR_ID = 3;
    public static final int PROTECTED_COLOR_ID = 4;
    public static final int BACKGROUND_COLOR_ID = 5;
    public static final int UNUSED_COLOR_ID = 6;

    public OneCell(GUIInput gUIInput, Color[] colorArray) {
        super(1);
        this.guiInput = gUIInput;
        this.status = 1;
        this.colors = colorArray;
        this.setFont(this.getFont().deriveFont(1));
        this.setHorizontalAlignment(0);
        this.unHighlight();
    }

    public OneCell() {
        this(null, nullColors);
    }

    public void protect() {
        this.protcted = true;
        this.setStatus(0);
    }

    public void protectIfNotClear() {
        if (this.getText().length() > 0) {
            this.protect();
        }
    }

    public boolean getProtected() {
        return this.protcted;
    }

    public void clearProtection() {
        this.protcted = false;
        this.setEditable(true);
        this.setStatus(1);
    }

    public OneCell(int n, GUIInput gUIInput, Color[] colorArray) {
        this(gUIInput, colorArray);
        this.max = n;
        this.protcted = false;
    }

    public OneCell(int n) {
        this(n, null, nullColors);
    }

    public void setMax(int n) {
        this.max = n;
    }

    public String getaText() {
        return this.getText();
    }

    public int getIntValue() {
        int n = 0;
        if (this.getText().length() != 0) {
            try {
                n = Integer.parseInt(this.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    public void setIntValue(int n) {
        if (!this.protcted) {
            this.setText("" + n);
        }
    }

    public void solverSetIntValue(int n) {
        if (!this.protcted && this.getText().equals("")) {
            this.setText("" + n);
            this.setStatus(2);
        }
    }

    public void clear() {
        this.unHighlight();
        if (!this.protcted) {
            this.setText("");
            this.setStatus(1);
        }
    }

    public void clearComputers() {
        this.unHighlight();
        if (!this.protcted && this.status == 2) {
            this.setText("");
            this.setStatus(1);
        }
    }

    public void highlight() {
        this.setBackground(this.colors[2]);
    }

    public void unHighlight() {
        this.setStatus(this.status);
    }

    public void refresh() {
        this.setStatus(this.status);
    }

    public void setStatus(int n) {
        this.status = n;
        switch (n) {
            case 0: {
                this.setBackground(this.colors[5]);
                this.setForeground(this.colors[4]);
                break;
            }
            case 1: {
                this.setForeground(this.colors[0]);
                this.setBackground(this.colors[5]);
                break;
            }
            case 2: {
                this.setForeground(this.colors[1]);
                this.setBackground(this.colors[5]);
            }
        }
    }

    public int getStatus() {
        return this.status;
    }

    public static int getNumberOfColours() {
        return 6;
    }

    protected Document createDefaultModel() {
        return new BoundedIntegerDocument();
    }

    public class BoundedIntegerDocument
    extends PlainDocument {
        BoundedIntegerDocument() {
        }

        public void remove(int n, int n2) throws BadLocationException {
            if (OneCell.this.status != 0) {
                super.remove(n, n2);
            }
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null || OneCell.this.status == 0) {
                return;
            }
            OneCell.this.unHighlight();
            if (n == 0 && string.length() == 0) {
                OneCell.this.setStatus(1);
                super.insertString(n, string, attributeSet);
                return;
            }
            boolean bl = false;
            try {
                int n2 = Integer.parseInt(OneCell.this.getaText() + string);
                boolean bl2 = bl = n2 >= 1 && n2 <= OneCell.this.max;
                if (bl) {
                    OneCell.this.setStatus(1);
                    super.insertString(n, string, attributeSet);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

