/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.apps.sudoku;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import javax.jnlp.FileContents;
import javax.jnlp.FileOpenService;
import javax.jnlp.FileSaveService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.sat4j.apps.sudoku.MainProgramWindow;
import org.sat4j.apps.sudoku.SuDoku;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.minisat.core.Solver;
import org.sat4j.reader.DimacsReader;

public class SDWebStart
extends JFrame
implements MainProgramWindow {
    FileSaveService fss;
    FileOpenService fos;
    SuDoku suDoku;
    static String[] extensions = new String[]{".cnf"};

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            new SDWebStart(16);
        } else {
            try {
                new SDWebStart(Integer.parseInt(stringArray[0]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setMainWindowSize(int n, int n2) {
    }

    public void maximize() {
        this.setExtendedState(6);
        this.validate();
        this.repaint();
    }

    public boolean fileAccess() {
        try {
            this.fos = (FileOpenService)ServiceManager.lookup((String)"javax.jnlp.FileOpenService");
            this.fss = (FileSaveService)ServiceManager.lookup((String)"javax.jnlp.FileSaveService");
        }
        catch (UnavailableServiceException unavailableServiceException) {
            this.fss = null;
            this.fos = null;
        }
        return this.fos != null && this.fss != null;
    }

    public String readFile() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            FileContents fileContents = this.fos.openFileDialog(null, null);
            InputStream inputStream = fileContents.getInputStream();
            int n = inputStream.read();
            while (n >= 0) {
                stringBuffer.append((char)n);
                n = inputStream.read();
            }
        }
        catch (Exception exception) {
            stringBuffer = new StringBuffer("File not read");
        }
        return stringBuffer.toString();
    }

    public void writeFile(String string) {
        try {
            StringInputStream stringInputStream = new StringInputStream(string);
            FileContents fileContents = this.fss.saveFileDialog(null, extensions, (InputStream)stringInputStream, "newFileName.cnf");
        }
        catch (IOException iOException) {
            this.suDoku.getGui().setResult("File not written");
        }
    }

    SDWebStart(int n) {
        this.suDoku = new SuDoku(this, n, false);
        this.getContentPane().add(new JScrollPane(this.suDoku.getGui()));
        this.setDefaultCloseOperation(2);
        this.setSize(800, 540);
        this.setVisible(true);
    }

    static void solve(String string) throws Exception {
        Solver solver = (Solver)SolverFactory.newMiniLearning();
        DimacsReader dimacsReader = new DimacsReader(solver);
        dimacsReader.parseInstance(string);
        if (solver.isSatisfiable()) {
            System.out.println("yes");
        } else {
            System.out.println("no");
        }
        System.out.println("starts = " + solver.getStats().starts + "\n");
        System.out.println("conflicts = " + solver.getStats().conflicts + "\n");
    }

    public class StringInputStream
    extends InputStream {
        StringReader sr;

        StringInputStream(String string) {
            this.sr = new StringReader(string);
        }

        public int read() throws IOException {
            return this.sr.read();
        }
    }
}

