/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.apps.sudoku;

import java.util.Collections;
import java.util.Comparator;
import java.util.Random;
import java.util.Vector;
import org.sat4j.apps.sudoku.Coordinate;

public class SortedCoordinateSet {
    Vector coordinates = new Vector();
    Random random = new Random();
    int rows;
    int columns;
    int smallSide;
    int[][] score;
    int[][] values;

    SortedCoordinateSet(int n, int n2, int n3, int[][] nArray) {
        this.rows = n;
        this.columns = n2;
        this.smallSide = n3;
        this.score = new int[n + 1][n2 + 1];
        for (int i = 1; i <= n; ++i) {
            for (int j = 1; j <= n2; ++j) {
                this.coordinates.add(new Coordinate(i, j));
                this.score[n][n2] = 0;
            }
        }
        this.values = nArray;
        Collections.sort(this.coordinates, new CompareCoords());
    }

    public void note(Coordinate coordinate) {
        int n;
        int n2;
        int n3 = 1;
        while (n3 <= this.columns) {
            int[] nArray = this.score[coordinate.getRow()];
            int n4 = n3++;
            nArray[n4] = nArray[n4] + 1;
        }
        for (n3 = 1; n3 <= this.columns; ++n3) {
            int[] nArray = this.score[n3];
            int n5 = coordinate.getColumn();
            nArray[n5] = nArray[n5] + 1;
        }
        n3 = (coordinate.getRow() - 1) / this.smallSide + 1;
        n3 = (n3 - 1) * this.smallSide + 1;
        int n6 = (coordinate.getColumn() - 1) / this.smallSide + 1;
        n6 = (n6 - 1) * this.smallSide + 1;
        for (n2 = n3; n2 < n3 + this.smallSide; ++n2) {
            n = n6;
            while (n < n6 + this.smallSide) {
                int[] nArray = this.score[n2];
                int n7 = n++;
                nArray[n7] = nArray[n7] + 1;
            }
        }
        n2 = this.values[coordinate.getRow()][coordinate.getColumn()];
        for (n = 1; n <= this.rows; ++n) {
            for (int i = 1; i <= this.columns; ++i) {
                if (this.values[n][i] != n2) continue;
                int[] nArray = this.score[n];
                int n8 = i;
                nArray[n8] = nArray[n8] + 1;
            }
        }
        Collections.sort(this.coordinates, new CompareCoords());
    }

    public Coordinate[] getAll() {
        Coordinate[] coordinateArray = new Coordinate[this.rows * this.columns];
        for (int i = 0; i < this.rows * this.columns; ++i) {
            coordinateArray[i] = (Coordinate)this.coordinates.elementAt(i);
        }
        return coordinateArray;
    }

    class CompareCoords
    implements Comparator {
        CompareCoords() {
        }

        public int compare(Object object, Object object2) {
            Coordinate coordinate = (Coordinate)object;
            Coordinate coordinate2 = (Coordinate)object2;
            if (SortedCoordinateSet.this.score[coordinate.getRow()][coordinate.getColumn()] < SortedCoordinateSet.this.score[coordinate2.getRow()][coordinate2.getColumn()]) {
                return -1;
            }
            if (SortedCoordinateSet.this.score[coordinate.getRow()][coordinate.getColumn()] == SortedCoordinateSet.this.score[coordinate2.getRow()][coordinate2.getColumn()]) {
                return 0;
            }
            return 1;
        }
    }
}

