/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.apps.sudoku;

import org.sat4j.apps.sudoku.CellGrid;
import org.sat4j.apps.sudoku.Coordinate;
import org.sat4j.apps.sudoku.CoordinateSet;
import org.sat4j.apps.sudoku.GUIInput;
import org.sat4j.apps.sudoku.LineScanner;
import org.sat4j.apps.sudoku.MainProgramWindow;
import org.sat4j.apps.sudoku.RandomPermutation;
import org.sat4j.apps.sudoku.SDSize;
import org.sat4j.apps.sudoku.SortedCoordinateSet;
import org.sat4j.apps.sudoku.WordScanner;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;

public class SuDoku {
    SDSize sdSize;
    int clauses;
    GUIInput gui;
    boolean fullCNF;
    boolean createUniqueAllowed;
    MainProgramWindow mainProgramWindow;
    VecInt vi = new VecInt();
    ISolver solver;
    boolean passesCheck;

    int variable(int n, int n2, int n3) {
        return n * this.sdSize.getBase() * this.sdSize.getBase() + n2 * this.sdSize.getBase() + n3;
    }

    void addOneSquareSolver(int n, int n2, ClauseHandler clauseHandler) {
        int n3;
        if (this.fullCNF) {
            this.vi.clear();
            for (n3 = 1; n3 <= this.sdSize.getLargeSide(); ++n3) {
                this.vi.push(this.variable(n, n2, n3));
            }
            clauseHandler.addClause(this.vi);
        }
        for (n3 = 1; n3 <= this.sdSize.getLargeSide() - 1; ++n3) {
            for (int i = n3 + 1; i <= this.sdSize.getLargeSide(); ++i) {
                this.vi.clear();
                this.vi.push(-this.variable(n, n2, n3));
                this.vi.push(-this.variable(n, n2, i));
                clauseHandler.addClause(this.vi);
            }
        }
    }

    int numOfVariables() {
        int n = this.sdSize.getBase() + 1;
        switch (this.sdSize.getLargeSide()) {
            case 4: {
                return 444;
            }
            case 9: {
                return 999;
            }
        }
        return n * n * n;
    }

    void readPuzzleSolver(CellGrid cellGrid, ClauseHandler clauseHandler) {
        for (int i = 1; i <= this.sdSize.getLargeSide(); ++i) {
            for (int j = 1; j <= this.sdSize.getLargeSide(); ++j) {
                int n;
                if (cellGrid.getStatus(i, j) == 2 || (n = cellGrid.getIntValue(i, j)) <= 0) continue;
                this.setSquareSolver(i, j, n, clauseHandler);
            }
        }
    }

    void addOneSquaresSolver(ClauseHandler clauseHandler) {
        for (int i = 1; i <= this.sdSize.getLargeSide(); ++i) {
            for (int j = 1; j <= this.sdSize.getLargeSide(); ++j) {
                this.addOneSquareSolver(i, j, clauseHandler);
            }
        }
    }

    int blockVariable(int n, int n2, int n3, int n4, int n5) {
        return this.variable((n - 1) * this.sdSize.getSmallSide() + n3, (n2 - 1) * this.sdSize.getSmallSide() + n4, n5);
    }

    void addOneBlockSolver(int n, int n2, ClauseHandler clauseHandler) {
        for (int i = 1; i <= this.sdSize.getLargeSide(); ++i) {
            int n3;
            int n4;
            this.vi.clear();
            for (n4 = 1; n4 <= this.sdSize.getSmallSide(); ++n4) {
                for (n3 = 1; n3 <= this.sdSize.getSmallSide(); ++n3) {
                    this.vi.push(this.blockVariable(n, n2, n4, n3, i));
                }
            }
            clauseHandler.addClause(this.vi);
            if (!this.fullCNF) continue;
            for (n4 = 1; n4 <= this.sdSize.getLargeSide() - 1; ++n4) {
                for (n3 = n4 + 1; n3 <= this.sdSize.getLargeSide(); ++n3) {
                    int n5 = (n4 - 1) / this.sdSize.getSmallSide() + 1;
                    int n6 = (n4 - 1) % this.sdSize.getSmallSide() + 1;
                    int n7 = (n3 - 1) / this.sdSize.getSmallSide() + 1;
                    int n8 = (n3 - 1) % this.sdSize.getSmallSide() + 1;
                    this.vi.clear();
                    this.vi.push(-this.blockVariable(n, n2, n5, n6, i));
                    this.vi.push(-this.blockVariable(n, n2, n7, n8, i));
                    clauseHandler.addClause(this.vi);
                }
            }
        }
    }

    void addOneRowSolver(int n, ClauseHandler clauseHandler) {
        for (int i = 1; i <= this.sdSize.getLargeSide(); ++i) {
            int n2;
            this.vi.clear();
            for (n2 = 1; n2 <= this.sdSize.getLargeSide(); ++n2) {
                this.vi.push(this.variable(n, n2, i));
            }
            clauseHandler.addClause(this.vi);
            if (!this.fullCNF) continue;
            for (n2 = 1; n2 <= this.sdSize.getLargeSide() - 1; ++n2) {
                for (int j = n2 + 1; j <= this.sdSize.getLargeSide(); ++j) {
                    this.vi.clear();
                    this.vi.push(-this.variable(n, n2, i));
                    this.vi.push(-this.variable(n, j, i));
                    clauseHandler.addClause(this.vi);
                }
            }
        }
    }

    void addOneRowsSolver(ClauseHandler clauseHandler) {
        for (int i = 1; i <= this.sdSize.getLargeSide(); ++i) {
            this.addOneRowSolver(i, clauseHandler);
        }
    }

    void addOneColumnSolver(int n, ClauseHandler clauseHandler) {
        for (int i = 1; i <= this.sdSize.getLargeSide(); ++i) {
            int n2;
            this.vi.clear();
            for (n2 = 1; n2 <= this.sdSize.getLargeSide(); ++n2) {
                this.vi.push(this.variable(n2, n, i));
            }
            clauseHandler.addClause(this.vi);
            if (!this.fullCNF) continue;
            for (n2 = 1; n2 <= this.sdSize.getLargeSide() - 1; ++n2) {
                for (int j = n2 + 1; j <= this.sdSize.getLargeSide(); ++j) {
                    this.vi.clear();
                    this.vi.push(-this.variable(n2, n, i));
                    this.vi.push(-this.variable(j, n, i));
                    clauseHandler.addClause(this.vi);
                }
            }
        }
    }

    void addOneColumnsSolver(ClauseHandler clauseHandler) {
        for (int i = 1; i <= this.sdSize.getLargeSide(); ++i) {
            this.addOneColumnSolver(i, clauseHandler);
        }
    }

    void addOneBlocksSolver(ClauseHandler clauseHandler) {
        for (int i = 1; i <= this.sdSize.getSmallSide(); ++i) {
            for (int j = 1; j <= this.sdSize.getSmallSide(); ++j) {
                this.addOneBlockSolver(i, j, clauseHandler);
            }
        }
    }

    void setSquareSolver(int n, int n2, int n3, ClauseHandler clauseHandler) {
        this.vi.clear();
        this.vi.push(this.variable(n, n2, n3));
        clauseHandler.addClause(this.vi);
    }

    public SuDoku(MainProgramWindow mainProgramWindow, int n, boolean bl) {
        this.createUniqueAllowed = bl;
        this.sdSize = new SDSize();
        this.gui = new GUIInput(mainProgramWindow, this.sdSize, this, n);
        new SolverFactory();
        this.solver = SolverFactory.newMiniLearning(20);
    }

    public GUIInput getGui() {
        return this.gui;
    }

    public boolean getCreateUniqueAllowed() {
        return this.createUniqueAllowed;
    }

    void checkSquares(CellGrid cellGrid) {
        for (int i = 1; i <= this.sdSize.getLargeSide() && this.passesCheck; ++i) {
            for (int j = 1; j <= this.sdSize.getLargeSide() && this.passesCheck; ++j) {
                int n = cellGrid.getIntValue(i, j);
                if (n >= 1 && n <= this.sdSize.getLargeSide()) continue;
                this.passesCheck = false;
                cellGrid.highlight(i, j);
                this.gui.setResult("Invalid cell");
            }
        }
    }

    void checkBlock(CellGrid cellGrid, int n, int n2) {
        block0: for (int i = 1; i <= this.sdSize.getLargeSide() - 1 && this.passesCheck; ++i) {
            for (int j = i + 1; j <= this.sdSize.getLargeSide() && this.passesCheck; ++j) {
                int n3 = (i - 1) / this.sdSize.getSmallSide() + 1;
                int n4 = (i - 1) % this.sdSize.getSmallSide() + 1;
                int n5 = (j - 1) / this.sdSize.getSmallSide() + 1;
                int n6 = (j - 1) % this.sdSize.getSmallSide() + 1;
                int n7 = n * this.sdSize.getSmallSide() + n3;
                int n8 = n2 * this.sdSize.getSmallSide() + n4;
                int n9 = n * this.sdSize.getSmallSide() + n5;
                int n10 = n2 * this.sdSize.getSmallSide() + n6;
                if (cellGrid.getIntValue(n7, n8) != cellGrid.getIntValue(n9, n10)) continue;
                cellGrid.highlight(n7, n8);
                cellGrid.highlight(n9, n10);
                this.passesCheck = false;
                this.gui.setResult("Two equal values in block");
                continue block0;
            }
        }
    }

    void checkBlocks(CellGrid cellGrid) {
        for (int i = 0; i < this.sdSize.getSmallSide() && this.passesCheck; ++i) {
            for (int j = 0; j < this.sdSize.getSmallSide() && this.passesCheck; ++j) {
                this.checkBlock(cellGrid, i, j);
            }
        }
    }

    void checkRow(CellGrid cellGrid, int n) {
        block0: for (int i = 1; i < this.sdSize.getLargeSide() && this.passesCheck; ++i) {
            for (int j = i + 1; j <= this.sdSize.getLargeSide() && this.passesCheck; ++j) {
                if (cellGrid.getIntValue(n, i) != cellGrid.getIntValue(n, j)) continue;
                cellGrid.highlight(n, i);
                cellGrid.highlight(n, j);
                this.passesCheck = false;
                this.gui.setResult("Two equal values in row");
                continue block0;
            }
        }
    }

    void checkRows(CellGrid cellGrid) {
        for (int i = 1; i <= this.sdSize.getLargeSide() && this.passesCheck; ++i) {
            this.checkRow(cellGrid, i);
        }
    }

    void checkColumn(CellGrid cellGrid, int n) {
        block0: for (int i = 1; i < this.sdSize.getLargeSide() && this.passesCheck; ++i) {
            for (int j = i + 1; j <= this.sdSize.getLargeSide() && this.passesCheck; ++j) {
                if (cellGrid.getIntValue(i, n) != cellGrid.getIntValue(j, n)) continue;
                cellGrid.highlight(i, n);
                cellGrid.highlight(j, n);
                this.passesCheck = false;
                this.gui.setResult("Two equal values in column");
                continue block0;
            }
        }
    }

    void checkColumns(CellGrid cellGrid) {
        for (int i = 1; i <= this.sdSize.getLargeSide() && this.passesCheck; ++i) {
            this.checkColumn(cellGrid, i);
        }
    }

    public void checkSolution(CellGrid cellGrid) {
        this.passesCheck = true;
        cellGrid.unHighlightAll();
        this.checkSquares(cellGrid);
        if (this.passesCheck) {
            this.checkBlocks(cellGrid);
        }
        if (this.passesCheck) {
            this.checkRows(cellGrid);
        }
        if (this.passesCheck) {
            this.checkColumns(cellGrid);
        }
        if (this.passesCheck) {
            this.gui.setResult("Correct");
        }
    }

    public void graphicalSolve(CellGrid cellGrid, boolean bl) throws Exception {
        System.gc();
        this.fullCNF = true;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer("s SATISFIABLE\n");
        this.clauses = 0;
        new SolverFactory();
        this.solver = SolverFactory.newMiniLearning();
        Sat4jClauseHandler sat4jClauseHandler = new Sat4jClauseHandler(this.numOfVariables(), this.solver);
        this.addOneSquaresSolver(sat4jClauseHandler);
        this.addOneBlocksSolver(sat4jClauseHandler);
        this.addOneRowsSolver(sat4jClauseHandler);
        this.addOneColumnsSolver(sat4jClauseHandler);
        this.readPuzzleSolver(cellGrid, sat4jClauseHandler);
        sat4jClauseHandler.finish();
        this.gui.setResult("");
        try {
            if (this.solver.isSatisfiable()) {
                int[] nArray = this.solver.model();
                for (int i = 0; i < nArray.length; ++i) {
                    if (bl) {
                        stringBuffer2.append("v " + nArray[i] + "\n");
                    }
                    if (nArray[i] <= 0 || nArray[i] % this.sdSize.getBase() == 0) continue;
                    this.gui.getCellGrid().solverSetIntValue(nArray[i] / this.sdSize.getBase2(), nArray[i] % this.sdSize.getBase2() / this.sdSize.getBase(), nArray[i] % this.sdSize.getBase());
                }
                if (bl) {
                    stringBuffer2.append("v 0\n");
                    this.gui.setCNFModel(stringBuffer2.toString());
                }
            } else {
                this.gui.setResult("Cannot be solved");
                if (bl) {
                    this.gui.setCNFModel("s UNSATISFIABLE");
                }
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.gc();
            this.gui.setResult("Increased Java Heap size required");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void simplerCNF(CellGrid cellGrid) {
        System.gc();
        this.fullCNF = false;
        StringClauseHandler stringClauseHandler = new StringClauseHandler(this.numOfVariables());
        this.addOneSquaresSolver(stringClauseHandler);
        this.addOneBlocksSolver(stringClauseHandler);
        this.addOneRowsSolver(stringClauseHandler);
        this.addOneColumnsSolver(stringClauseHandler);
        this.readPuzzleSolver(cellGrid, stringClauseHandler);
        stringClauseHandler.finish();
        this.gui.setCNFFile(stringClauseHandler.toString());
        this.gui.setResult("cnf available for solving");
    }

    public void fullCNF(CellGrid cellGrid) {
        System.gc();
        this.fullCNF = true;
        StringClauseHandler stringClauseHandler = new StringClauseHandler(this.numOfVariables());
        this.addOneSquaresSolver(stringClauseHandler);
        this.addOneBlocksSolver(stringClauseHandler);
        this.addOneRowsSolver(stringClauseHandler);
        this.addOneColumnsSolver(stringClauseHandler);
        this.readPuzzleSolver(cellGrid, stringClauseHandler);
        stringClauseHandler.finish();
        this.gui.setCNFFile(stringClauseHandler.toString());
        this.gui.setResult("cnf available for solving");
    }

    public void parseLine(String string, CellGrid cellGrid) {
        if (string.length() > 0 && string.charAt(0) == 'v') {
            WordScanner wordScanner = new WordScanner(string);
            wordScanner.next();
            while (wordScanner.hasNext()) {
                String string2 = wordScanner.next();
                try {
                    int n = Integer.parseInt(string2);
                    if (n <= 0 || n % this.sdSize.getBase() <= 0) continue;
                    cellGrid.solverSetIntValue(n / this.sdSize.getBase2(), n % this.sdSize.getBase2() / this.sdSize.getBase(), n % this.sdSize.getBase());
                }
                catch (Exception exception) {}
            }
            wordScanner.close();
        }
    }

    public void interpretModel(CellGrid cellGrid) {
        LineScanner lineScanner = new LineScanner(this.gui.getCNFModel());
        while (lineScanner.hasNext()) {
            this.parseLine(lineScanner.next(), cellGrid);
        }
        lineScanner.close();
    }

    public void createPuzzle(int n, CellGrid cellGrid, boolean bl) {
        int n2;
        Object object;
        Object object2;
        System.gc();
        int[][] nArray = new int[this.sdSize.getLargeSide() + 1][this.sdSize.getLargeSide() + 1];
        int[][] nArray2 = new int[this.sdSize.getLargeSide() + 1][this.sdSize.getLargeSide() + 1];
        cellGrid.clearAll();
        boolean bl2 = false;
        this.fullCNF = true;
        while (!bl2) {
            new SolverFactory();
            ISolver iSolver = SolverFactory.newMiniLearning();
            object2 = new Sat4jClauseHandler(this.numOfVariables(), iSolver);
            this.addOneSquaresSolver((ClauseHandler)object2);
            this.addOneBlocksSolver((ClauseHandler)object2);
            this.addOneRowsSolver((ClauseHandler)object2);
            this.addOneColumnsSolver((ClauseHandler)object2);
            object = new CoordinateSet(this.sdSize.getLargeSide(), this.sdSize.getLargeSide());
            for (int i = 1; i <= this.sdSize.getLargeSide(); ++i) {
                Coordinate coordinate = ((CoordinateSet)object).getCoordinate();
                this.vi.clear();
                this.vi.push(this.variable(coordinate.getRow(), coordinate.getColumn(), i));
                ((Sat4jClauseHandler)object2).addClause(this.vi);
            }
            ((Sat4jClauseHandler)object2).finish();
            try {
                if (!iSolver.isSatisfiable()) continue;
                bl2 = true;
                int[] nArray3 = iSolver.model();
                for (int i = 0; i < nArray3.length; ++i) {
                    if (nArray3[i] <= 0 || nArray3[i] % this.sdSize.getBase() == 0) continue;
                    nArray[nArray3[i] / this.sdSize.getBase2()][nArray3[i] % this.sdSize.getBase2() / this.sdSize.getBase()] = nArray3[i] % this.sdSize.getBase();
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.gui.setResult("Increased Java Heap size required");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        object2 = new CoordinateSet(this.sdSize.getLargeSide(), this.sdSize.getLargeSide());
        object = new RandomPermutation(this.sdSize.getLargeSide());
        for (n2 = 1; n2 <= this.sdSize.getLargeSide(); ++n2) {
            for (int i = 1; i <= this.sdSize.getLargeSide(); ++i) {
                nArray[n2][i] = ((RandomPermutation)object).permute(nArray[n2][i]);
            }
        }
        n2 = n;
        if (bl) {
            n2 = 0;
            try {
                int n3;
                new SolverFactory();
                ISolver iSolver = SolverFactory.newMiniLearning();
                Sat4jClauseHandler sat4jClauseHandler = new Sat4jClauseHandler(this.numOfVariables(), iSolver);
                this.addOneSquaresSolver(sat4jClauseHandler);
                this.addOneBlocksSolver(sat4jClauseHandler);
                this.addOneRowsSolver(sat4jClauseHandler);
                this.addOneColumnsSolver(sat4jClauseHandler);
                this.vi.clear();
                for (n3 = 1; n3 <= this.sdSize.getLargeSide(); ++n3) {
                    for (int i = 1; i <= this.sdSize.getLargeSide(); ++i) {
                        this.vi.push(-this.variable(n3, i, nArray[n3][i]));
                    }
                }
                sat4jClauseHandler.addClause(this.vi);
                n3 = 0;
                SortedCoordinateSet sortedCoordinateSet = new SortedCoordinateSet(this.sdSize.getLargeSide(), this.sdSize.getLargeSide(), this.sdSize.getSmallSide(), nArray);
                int n4 = 0;
                while (n3 == 0) {
                    if (iSolver.isSatisfiable()) {
                        int n5;
                        int[] nArray4 = iSolver.model();
                        for (n5 = 0; n5 < nArray4.length; ++n5) {
                            int n6;
                            if (nArray4[n5] <= 0) continue;
                            int n7 = nArray4[n5] / this.sdSize.getBase2();
                            int n8 = nArray4[n5] % this.sdSize.getBase2() / this.sdSize.getBase();
                            nArray2[n7][n8] = n6 = nArray4[n5] % this.sdSize.getBase();
                        }
                        n5 = 0;
                        RandomPermutation randomPermutation = new RandomPermutation(this.sdSize.getLargeSide());
                        RandomPermutation randomPermutation2 = new RandomPermutation(this.sdSize.getLargeSide());
                        Coordinate[] coordinateArray = sortedCoordinateSet.getAll();
                        int n9 = 0;
                        while (n5 == 0) {
                            int n10;
                            Coordinate coordinate = coordinateArray[n9];
                            int n11 = coordinate.getRow();
                            if (nArray[n11][n10 = coordinate.getColumn()] != nArray2[n11][n10]) {
                                sortedCoordinateSet.note(coordinate);
                                cellGrid.setIntValue(n11, n10, nArray[n11][n10]);
                                ++n2;
                                n5 = 1;
                                ++n4;
                                this.vi.clear();
                                this.vi.push(this.variable(n11, n10, nArray[n11][n10]));
                                try {
                                    sat4jClauseHandler.addClauseUnTrapped(this.vi);
                                }
                                catch (ContradictionException contradictionException) {
                                    n3 = 1;
                                }
                            }
                            ++n9;
                        }
                        continue;
                    }
                    n3 = 1;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            Object object3;
            int n12;
            for (n12 = 0; n12 < n2 / 4; ++n12) {
                object3 = ((CoordinateSet)object2).getGroup();
                for (int i = 0; i < 4; ++i) {
                    cellGrid.setIntValue(object3[i].getRow(), ((Coordinate)object3[i]).getColumn(), nArray[((Coordinate)object3[i]).getRow()][((Coordinate)object3[i]).getColumn()]);
                }
            }
            for (n12 = 0; n12 < n2 % 4; ++n12) {
                object3 = ((CoordinateSet)object2).getCoordinate();
                cellGrid.setIntValue(((Coordinate)object3).getRow(), ((Coordinate)object3).getColumn(), nArray[((Coordinate)object3).getRow()][((Coordinate)object3).getColumn()]);
            }
        }
        this.gui.setFillCount(n2);
        this.gui.setProtection(true);
    }

    class StringClauseHandler
    implements ClauseHandler {
        StringBuffer buffer = new StringBuffer();
        String string;
        int clauses;
        int variables;

        StringClauseHandler(int n) {
            this.variables = n;
            this.clauses = 0;
        }

        public void addClause(VecInt vecInt) {
            for (int i = 0; i < vecInt.size(); ++i) {
                this.buffer.append(vecInt.get(i) + " ");
            }
            this.buffer.append("0\n");
            ++this.clauses;
        }

        public void finish() {
            this.string = "p cnf " + this.variables + " " + this.clauses + "\n" + this.buffer.toString();
        }

        public String toString() {
            return this.string;
        }
    }

    class Sat4jClauseHandler
    implements ClauseHandler {
        ISolver solver;

        Sat4jClauseHandler(int n, ISolver iSolver) {
            this.solver = iSolver;
            iSolver.newVar(n);
        }

        public void addClause(VecInt vecInt) {
            try {
                this.solver.addClause(vecInt);
            }
            catch (ContradictionException contradictionException) {
                // empty catch block
            }
        }

        public void addClauseUnTrapped(VecInt vecInt) throws ContradictionException {
            this.solver.addClause(vecInt);
        }

        public void finish() {
        }
    }

    static interface ClauseHandler {
        public void addClause(VecInt var1);

        public void finish();
    }
}

