/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat;

import org.sat4j.core.ASolverFactory;
import org.sat4j.minisat.constraints.CardinalityDataStructure;
import org.sat4j.minisat.constraints.ClausalDataStructureCB;
import org.sat4j.minisat.constraints.ClausalDataStructureCBWL;
import org.sat4j.minisat.constraints.MixedDataStructureDaniel;
import org.sat4j.minisat.constraints.MixedDataStructureWithBinary;
import org.sat4j.minisat.constraints.MixedDataStructureWithBinaryAndTernary;
import org.sat4j.minisat.constraints.PBMaxDataStructure;
import org.sat4j.minisat.constraints.PBMinDataStructure;
import org.sat4j.minisat.constraints.pb.PBSolver;
import org.sat4j.minisat.core.DataStructureFactory;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.SearchParams;
import org.sat4j.minisat.core.Solver;
import org.sat4j.minisat.learning.ActiveLearning;
import org.sat4j.minisat.learning.FixedLengthLearning;
import org.sat4j.minisat.learning.LimitedLearning;
import org.sat4j.minisat.learning.MiniSATLearning;
import org.sat4j.minisat.learning.NoLearningButHeuristics;
import org.sat4j.minisat.orders.JWOrder;
import org.sat4j.minisat.orders.MyOrder;
import org.sat4j.minisat.orders.PureOrder;
import org.sat4j.minisat.orders.VarOrder;
import org.sat4j.minisat.orders.VarOrderHeap;
import org.sat4j.minisat.uip.DecisionUIP;
import org.sat4j.minisat.uip.FirstUIP;
import org.sat4j.specs.ISolver;

public class SolverFactory
extends ASolverFactory {
    public static ISolver newMiniLearning() {
        return SolverFactory.newMiniLearning(10);
    }

    public static ISolver newMiniLearningHeap() {
        return SolverFactory.newMiniLearningHeap(new MixedDataStructureDaniel());
    }

    public static ISolver newMiniLearningHeapEZSimp() {
        LimitedLearning limitedLearning = new LimitedLearning(10);
        Solver solver = new Solver(new FirstUIP(), limitedLearning, new MixedDataStructureDaniel(), new VarOrderHeap());
        limitedLearning.setSolver(solver);
        solver.setSimplifier(solver.SIMPLE_SIMPLIFICATION);
        return solver;
    }

    public static ISolver newMiniLearning(int n) {
        return SolverFactory.newMiniLearning((DataStructureFactory)new MixedDataStructureDaniel(), n);
    }

    public static ISolver newMiniLearning(DataStructureFactory dataStructureFactory) {
        return SolverFactory.newMiniLearning(dataStructureFactory, 10);
    }

    public static ISolver newMiniLearningHeap(DataStructureFactory dataStructureFactory) {
        return SolverFactory.newMiniLearning(dataStructureFactory, new VarOrderHeap());
    }

    public static ISolver newMiniLearning2() {
        return SolverFactory.newMiniLearning(new MixedDataStructureWithBinary());
    }

    public static ISolver newMiniLearning2Heap() {
        return SolverFactory.newMiniLearningHeap(new MixedDataStructureWithBinary());
    }

    public static ISolver newMiniLearning23() {
        return SolverFactory.newMiniLearning(new MixedDataStructureWithBinaryAndTernary());
    }

    public static ISolver newMiniLearningCB() {
        return SolverFactory.newMiniLearning(new ClausalDataStructureCB());
    }

    public static ISolver newMiniLearningCBWL() {
        return SolverFactory.newMiniLearning(new ClausalDataStructureCBWL());
    }

    public static ISolver newMiniLearning2NewOrder() {
        return SolverFactory.newMiniLearning((DataStructureFactory)new MixedDataStructureWithBinary(), new MyOrder());
    }

    public static ISolver newMiniLearningPure() {
        return SolverFactory.newMiniLearning((DataStructureFactory)new MixedDataStructureDaniel(), new PureOrder());
    }

    public static ISolver newMiniLearningCBWLPure() {
        return SolverFactory.newMiniLearning((DataStructureFactory)new ClausalDataStructureCBWL(), new PureOrder());
    }

    public static ISolver newMiniLearning(DataStructureFactory dataStructureFactory, int n) {
        LimitedLearning limitedLearning = new LimitedLearning(n);
        Solver solver = new Solver(new FirstUIP(), limitedLearning, dataStructureFactory, new VarOrder());
        limitedLearning.setSolver(solver);
        return solver;
    }

    public static ISolver newMiniLearning(DataStructureFactory dataStructureFactory, IOrder iOrder) {
        LimitedLearning limitedLearning = new LimitedLearning(10);
        Solver solver = new Solver(new FirstUIP(), limitedLearning, dataStructureFactory, iOrder);
        limitedLearning.setSolver(solver);
        return solver;
    }

    public static ISolver newMiniLearningEZSimp() {
        return SolverFactory.newMiniLearningEZSimp(new MixedDataStructureDaniel());
    }

    public static ISolver newMiniLearningEZSimp(DataStructureFactory dataStructureFactory) {
        LimitedLearning limitedLearning = new LimitedLearning(10);
        Solver solver = new Solver(new FirstUIP(), limitedLearning, dataStructureFactory, new VarOrder());
        limitedLearning.setSolver(solver);
        solver.setSimplifier(solver.SIMPLE_SIMPLIFICATION);
        return solver;
    }

    public static ISolver newMiniLearningNoRestarts() {
        LimitedLearning limitedLearning = new LimitedLearning(10);
        Solver solver = new Solver(new FirstUIP(), limitedLearning, new MixedDataStructureDaniel(), new SearchParams(Integer.MAX_VALUE), new VarOrder());
        limitedLearning.setSolver(solver);
        return solver;
    }

    public static ISolver newActiveLearning() {
        ActiveLearning activeLearning = new ActiveLearning();
        Solver solver = new Solver(new FirstUIP(), activeLearning, new MixedDataStructureDaniel(), new VarOrder());
        activeLearning.setOrder(solver.getOrder());
        activeLearning.setSolver(solver);
        return solver;
    }

    public static ISolver newMiniSAT() {
        return SolverFactory.newMiniSAT(new MixedDataStructureDaniel());
    }

    public static ISolver newMiniSATNoRestarts() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        Solver solver = new Solver(new FirstUIP(), miniSATLearning, new MixedDataStructureDaniel(), new SearchParams(Integer.MAX_VALUE), new VarOrder());
        miniSATLearning.setDataStructureFactory(solver.getDSFactory());
        miniSATLearning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newMiniSAT2() {
        return SolverFactory.newMiniSAT(new MixedDataStructureWithBinary());
    }

    public static ISolver newMiniSAT23() {
        return SolverFactory.newMiniSAT(new MixedDataStructureWithBinaryAndTernary());
    }

    public static ISolver newMiniSAT(DataStructureFactory dataStructureFactory) {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        Solver solver = new Solver(new FirstUIP(), miniSATLearning, dataStructureFactory, new VarOrder());
        miniSATLearning.setDataStructureFactory(solver.getDSFactory());
        miniSATLearning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newMiniSATHeap() {
        return SolverFactory.newMiniSATHeap(new MixedDataStructureDaniel());
    }

    public static ISolver newMiniSAT2Heap() {
        return SolverFactory.newMiniSATHeap(new MixedDataStructureWithBinary());
    }

    public static ISolver newMiniSAT23Heap() {
        return SolverFactory.newMiniSATHeap(new MixedDataStructureWithBinaryAndTernary());
    }

    public static ISolver newMiniSATHeap(DataStructureFactory dataStructureFactory) {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        Solver solver = new Solver(new FirstUIP(), miniSATLearning, dataStructureFactory, new VarOrderHeap());
        miniSATLearning.setDataStructureFactory(solver.getDSFactory());
        miniSATLearning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newMiniCard() {
        return SolverFactory.newMiniSAT(new CardinalityDataStructure());
    }

    public static ISolver newMinimalOPBMax() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        Solver solver = new Solver(new FirstUIP(), miniSATLearning, new PBMaxDataStructure(), new VarOrderHeap());
        miniSATLearning.setDataStructureFactory(solver.getDSFactory());
        miniSATLearning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newMiniOPBMax() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        PBSolver pBSolver = new PBSolver(new FirstUIP(), miniSATLearning, new PBMaxDataStructure(), new VarOrderHeap());
        miniSATLearning.setDataStructureFactory(pBSolver.getDSFactory());
        miniSATLearning.setVarActivityListener(pBSolver);
        return pBSolver;
    }

    public static ISolver newMinimalOPBMin() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        Solver solver = new Solver(new FirstUIP(), miniSATLearning, new PBMinDataStructure(), new VarOrderHeap());
        miniSATLearning.setDataStructureFactory(solver.getDSFactory());
        miniSATLearning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newMiniOPBMin() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        PBSolver pBSolver = new PBSolver(new FirstUIP(), miniSATLearning, new PBMinDataStructure(), new VarOrderHeap());
        miniSATLearning.setDataStructureFactory(pBSolver.getDSFactory());
        miniSATLearning.setVarActivityListener(pBSolver);
        return pBSolver;
    }

    public static ISolver newRelsat() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        Solver solver = new Solver(new DecisionUIP(), miniSATLearning, new MixedDataStructureDaniel(), new VarOrderHeap());
        miniSATLearning.setDataStructureFactory(solver.getDSFactory());
        miniSATLearning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newBackjumping() {
        NoLearningButHeuristics noLearningButHeuristics = new NoLearningButHeuristics();
        Solver solver = new Solver(new FirstUIP(), noLearningButHeuristics, new MixedDataStructureDaniel(), new VarOrderHeap());
        noLearningButHeuristics.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newMini3SAT() {
        FixedLengthLearning fixedLengthLearning = new FixedLengthLearning(3);
        Solver solver = new Solver(new FirstUIP(), fixedLengthLearning, new MixedDataStructureWithBinaryAndTernary(), new SearchParams(Integer.MAX_VALUE), new VarOrderHeap());
        fixedLengthLearning.setSolver(solver);
        solver.setOrder(new JWOrder());
        return solver;
    }

    public static ISolver newMini3SATb() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        Solver solver = new Solver(new FirstUIP(), miniSATLearning, new MixedDataStructureWithBinaryAndTernary(), new SearchParams(Integer.MAX_VALUE), new VarOrderHeap());
        miniSATLearning.setDataStructureFactory(solver.getDSFactory());
        miniSATLearning.setVarActivityListener(solver);
        solver.setOrder(new JWOrder());
        return solver;
    }

    public ISolver defaultSolver() {
        return SolverFactory.newMiniSAT2Heap();
    }

    public ISolver lightSolver() {
        return SolverFactory.newMini3SAT();
    }
}

