/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints;

import java.math.BigInteger;
import org.sat4j.minisat.constraints.AbstractDataStructureFactory;
import org.sat4j.minisat.constraints.card.AtLeast;
import org.sat4j.minisat.core.Constr;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCardinalityDataStructure
extends AbstractDataStructureFactory {
    @Override
    public Constr createPseudoBooleanConstraint(IVecInt iVecInt, IVec<BigInteger> iVec, boolean bl, BigInteger bigInteger) throws ContradictionException {
        BigInteger bigInteger2 = this.reduceToCard(iVec, iVecInt);
        bigInteger = bigInteger.add(bigInteger2);
        assert (this.allAtOne(iVec));
        if (bl) {
            return AtLeast.atLeastNew(this.solver, this.getVocabulary(), iVecInt, bigInteger.intValue());
        }
        for (int i = 0; i < iVecInt.size(); ++i) {
            iVecInt.set(i, iVecInt.get(i) ^ 1);
        }
        return AtLeast.atLeastNew(this.solver, this.getVocabulary(), iVecInt, iVec.size() - bigInteger.intValue());
    }

    private boolean allAtOne(IVec<BigInteger> iVec) {
        for (int i = 0; i < iVec.size(); ++i) {
            if (iVec.get(i).equals(BigInteger.ONE)) continue;
            return false;
        }
        return true;
    }

    private BigInteger reduceToCard(IVec<BigInteger> iVec, IVecInt iVecInt) {
        int n = 0;
        for (int i = 0; i < iVec.size(); ++i) {
            assert (iVec.get(i).abs().equals(BigInteger.ONE));
            if (iVec.get(i).signum() >= 0) continue;
            assert (iVec.get(i).equals(BigInteger.ONE.negate()));
            ++n;
            iVecInt.set(i, iVecInt.get(i) ^ 1);
            iVec.set(i, BigInteger.ONE);
        }
        return BigInteger.valueOf(n);
    }
}

