/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints;

import org.sat4j.minisat.constraints.MixedDataStructureDaniel;
import org.sat4j.minisat.constraints.cnf.Lits23;
import org.sat4j.minisat.constraints.cnf.WLClause;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.ILits23;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVecInt;

public class MixedDataStructureWithBinaryAndTernary
extends MixedDataStructureDaniel {
    private static final long serialVersionUID = 1L;
    private final ILits23 mlits = new Lits23();

    public MixedDataStructureWithBinaryAndTernary() {
        this.lits = this.mlits;
    }

    public ILits getVocabulary() {
        return this.lits;
    }

    public Constr createClause(IVecInt iVecInt) throws ContradictionException {
        IVecInt iVecInt2 = WLClause.sanityCheck(iVecInt, this.lits, this.solver);
        if (iVecInt2 == null) {
            return null;
        }
        if (iVecInt2.size() == 2) {
            this.mlits.binaryClauses(iVecInt2.get(0), iVecInt2.get(1));
            return null;
        }
        if (iVecInt2.size() == 3) {
            this.mlits.ternaryClauses(iVecInt2.get(0), iVecInt2.get(1), iVecInt2.get(2));
            return null;
        }
        return WLClause.brandNewClause(this.solver, this.lits, iVecInt2);
    }

    public void learnConstraint(Constr constr) {
        if (constr.size() == 2) {
            this.mlits.binaryClauses(constr.get(0), constr.get(1));
        } else if (constr.size() == 3) {
            this.mlits.ternaryClauses(constr.get(0), constr.get(1), constr.get(2));
        } else {
            super.learnConstraint(constr);
        }
    }
}

