/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.card;

import java.io.Serializable;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.Undoable;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVecInt;

public class MinWatchCard
implements Constr,
Undoable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final boolean ATLEAST = true;
    private int degree;
    private int[] lits;
    private boolean moreThan;
    private int watchCumul;
    private final ILits voc;

    private MinWatchCard(ILits iLits, IVecInt iVecInt, boolean bl, int n) {
        int n2;
        this.voc = iLits;
        this.degree = n;
        this.moreThan = bl;
        int[] nArray = new int[iLits.nVars() * 2 + 2];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = 0;
        }
        for (n2 = 0; n2 < iVecInt.size(); ++n2) {
            if (nArray[iVecInt.get(n2) ^ 1] == 0) {
                int n3 = iVecInt.get(n2);
                nArray[n3] = nArray[n3] + 1;
                continue;
            }
            int n4 = iVecInt.get(n2) ^ 1;
            nArray[n4] = nArray[n4] - 1;
        }
        n2 = 0;
        while (n2 < iVecInt.size()) {
            if (nArray[iVecInt.get(n2)] > 0) {
                int n5 = iVecInt.get(n2);
                nArray[n5] = nArray[n5] - 1;
                ++n2;
                continue;
            }
            if ((iVecInt.get(n2) & 1) != 0) {
                --this.degree;
            }
            iVecInt.set(n2, iVecInt.last());
            iVecInt.pop();
        }
        this.lits = new int[iVecInt.size()];
        iVecInt.moveTo(this.lits);
        this.normalize();
    }

    public void calcReason(int n, IVecInt iVecInt) {
        for (int i = 0; i < this.lits.length; ++i) {
            if (!this.voc.isFalsified(this.lits[i])) continue;
            iVecInt.push(this.lits[i] ^ 1);
        }
    }

    public double getActivity() {
        return 0.0;
    }

    public void incActivity(double d) {
    }

    public boolean learnt() {
        return false;
    }

    private static int linearisation(ILits iLits, IVecInt iVecInt) {
        int n = 0;
        int n2 = 0;
        while (n2 < iVecInt.size()) {
            if (iLits.isUnassigned(iVecInt.get(n2))) {
                ++n2;
                continue;
            }
            if (iLits.isSatisfied(iVecInt.get(n2))) {
                --n;
            }
            iVecInt.set(n2, iVecInt.last());
            iVecInt.pop();
        }
        return n;
    }

    public boolean locked() {
        return true;
    }

    public static MinWatchCard minWatchCardNew(UnitPropagationListener unitPropagationListener, ILits iLits, IVecInt iVecInt, boolean bl, int n) throws ContradictionException {
        int n2;
        n += MinWatchCard.linearisation(iLits, iVecInt);
        if (iVecInt.size() == 0) {
            throw new ContradictionException();
        }
        if (iVecInt.size() == n) {
            for (int i = 0; i < iVecInt.size(); ++i) {
                if (unitPropagationListener.enqueue(iVecInt.get(i))) continue;
                throw new ContradictionException();
            }
            return null;
        }
        MinWatchCard minWatchCard = new MinWatchCard(iLits, iVecInt, bl, n);
        minWatchCard.normalize();
        if (n <= 0) {
            return null;
        }
        int n3 = minWatchCard.lits.length;
        for (n2 = 0; n2 <= minWatchCard.degree && n2 < n3; ++n2) {
            while (iLits.isFalsified(minWatchCard.lits[n2]) && --n3 <= n2) {
                int n4 = minWatchCard.lits[n2];
                minWatchCard.lits[n2] = minWatchCard.lits[n3];
                minWatchCard.lits[n3] = n4;
            }
            if (iLits.isFalsified(minWatchCard.lits[n2])) continue;
            ++minWatchCard.watchCumul;
            iLits.watch(minWatchCard.lits[n2] ^ 1, minWatchCard);
        }
        if (minWatchCard.watchCumul <= minWatchCard.degree) {
            if (minWatchCard.watchCumul == minWatchCard.degree) {
                for (n2 = 0; n2 < minWatchCard.lits.length; ++n2) {
                    if (unitPropagationListener.enqueue(minWatchCard.lits[n2])) continue;
                    throw new ContradictionException();
                }
                return null;
            }
            throw new ContradictionException();
        }
        return minWatchCard;
    }

    public void normalize() {
        if (!this.moreThan) {
            this.degree = 0 - this.degree;
            for (int i = 0; i < this.lits.length; ++i) {
                this.lits[i] = this.lits[i] ^ 1;
                ++this.degree;
            }
            this.moreThan = true;
        }
    }

    public boolean propagate(UnitPropagationListener unitPropagationListener, int n) {
        int n2;
        if (this.watchCumul == this.degree) {
            this.voc.watch(n, this);
            return false;
        }
        int n3 = -1;
        while ((this.lits[++n3] ^ 1) != n) {
        }
        for (n2 = this.degree + 1; n2 < this.lits.length && this.voc.isFalsified(this.lits[n2]); ++n2) {
        }
        if (n2 == this.lits.length) {
            this.voc.watch(n, this);
            --this.watchCumul;
            assert (this.watchCumul == this.degree);
            this.voc.undos(n).push(this);
            for (int i = 0; i <= this.degree; ++i) {
                if (n == (this.lits[i] ^ 1) || unitPropagationListener.enqueue(this.lits[i], this)) continue;
                return false;
            }
            return true;
        }
        int n4 = this.lits[n2];
        this.lits[n2] = this.lits[n3];
        this.lits[n3] = n4;
        this.voc.watch(n4 ^ 1, this);
        return true;
    }

    public void remove() {
        for (int i = 0; i <= this.degree; ++i) {
            this.voc.watches(this.lits[i] ^ 1).remove(this);
        }
    }

    public void rescaleBy(double d) {
    }

    public boolean simplify() {
        int n = 0;
        for (int i = 0; i < this.lits.length; ++i) {
            if (!this.voc.isSatisfied(this.lits[i]) || ++n != this.degree) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.lits.length > 0) {
            if (this.voc.isUnassigned(this.lits[0])) {
                stringBuffer.append(this.lits[0]);
                stringBuffer.append(" ");
            }
            for (int i = 1; i < this.lits.length; ++i) {
                if (!this.voc.isUnassigned(this.lits[i])) continue;
                stringBuffer.append(" + ");
                stringBuffer.append(this.lits[i]);
                stringBuffer.append(" ");
            }
            stringBuffer.append(">= ");
            stringBuffer.append(this.degree);
        }
        return stringBuffer.toString();
    }

    public void undo(int n) {
        ++this.watchCumul;
    }

    public void setLearnt() {
        throw new UnsupportedOperationException();
    }

    public void register() {
        throw new UnsupportedOperationException();
    }

    public int size() {
        return this.lits.length;
    }

    public int get(int n) {
        return this.lits[n];
    }

    public void assertConstraint(UnitPropagationListener unitPropagationListener) {
        throw new UnsupportedOperationException();
    }
}

