/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.cnf;

import java.io.Serializable;
import org.sat4j.core.Vec;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.Lbool;
import org.sat4j.minisat.core.Propagatable;
import org.sat4j.minisat.core.Undoable;
import org.sat4j.specs.IVec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lits
implements Serializable,
ILits {
    private static final long serialVersionUID = 1L;
    private boolean[] pool = new boolean[0];
    private int realnVars = 0;
    protected IVec<Propagatable>[] watches = new IVec[0];
    private int[] level = new int[0];
    public Lbool[] truthValue = new Lbool[1];
    private Constr[] reason = new Constr[0];
    private IVec<Undoable>[] undos = new IVec[0];

    @Override
    public void init(int n) {
        assert (n >= 0);
        int n2 = n + 1;
        boolean[] blArray = new boolean[n2];
        System.arraycopy(this.pool, 0, blArray, 0, this.pool.length);
        this.pool = blArray;
        this.level = new int[n2];
        int[] nArray = new int[n2];
        System.arraycopy(this.level, 0, nArray, 0, this.level.length);
        this.level = nArray;
        IVec[] iVecArray = new IVec[2 * n2];
        System.arraycopy(this.watches, 0, iVecArray, 0, this.watches.length);
        this.watches = iVecArray;
        Lbool[] lboolArray = new Lbool[n2];
        System.arraycopy(this.truthValue, 0, lboolArray, 0, this.truthValue.length);
        this.truthValue = lboolArray;
        IVec[] iVecArray2 = new IVec[n2];
        System.arraycopy(this.undos, 0, iVecArray2, 0, this.undos.length);
        this.undos = iVecArray2;
        Constr[] constrArray = new Constr[n2];
        System.arraycopy(this.reason, 0, constrArray, 0, this.reason.length);
        this.reason = constrArray;
    }

    @Override
    public int getFromPool(int n) {
        int n2;
        int n3 = Math.abs(n);
        assert (n3 < this.pool.length);
        int n4 = n2 = n < 0 ? n3 << 1 ^ 1 : n3 << 1;
        assert (n2 > 1);
        if (!this.pool[n3]) {
            ++this.realnVars;
            this.pool[n3] = true;
            this.watches[n3 << 1] = new Vec<Propagatable>();
            this.watches[n3 << 1 | 1] = new Vec<Propagatable>();
            this.truthValue[n3] = Lbool.UNDEFINED;
            this.undos[n3] = new Vec<Undoable>();
            this.level[n3] = -1;
        }
        return n2;
    }

    @Override
    public boolean belongsToPool(int n) {
        assert (n > 0);
        return this.pool[n];
    }

    @Override
    public void resetPool() {
        for (int i = 0; i < this.pool.length; ++i) {
            if (!this.pool[i]) continue;
            this.reset(i);
        }
    }

    @Override
    public void ensurePool(int n) {
        this.init(n);
    }

    @Override
    public void unassign(int n) {
        assert (this.truthValue[n >> 1] != Lbool.UNDEFINED);
        this.truthValue[n >> 1] = Lbool.UNDEFINED;
    }

    @Override
    public void satisfies(int n) {
        assert (this.truthValue[n >> 1] == Lbool.UNDEFINED);
        this.truthValue[n >> 1] = Lits.satisfyingValue(n);
    }

    private static final Lbool satisfyingValue(int n) {
        return (n & 1) == 0 ? Lbool.TRUE : Lbool.FALSE;
    }

    @Override
    public boolean isSatisfied(int n) {
        return this.truthValue[n >> 1] == Lits.satisfyingValue(n);
    }

    @Override
    public boolean isFalsified(int n) {
        return this.truthValue[n >> 1] == ((n & 1) == 0 ? Lbool.FALSE : Lbool.TRUE);
    }

    @Override
    public boolean isUnassigned(int n) {
        return this.truthValue[n >> 1] == Lbool.UNDEFINED;
    }

    @Override
    public String valueToString(int n) {
        if (this.isUnassigned(n)) {
            return "?";
        }
        if (this.isSatisfied(n)) {
            return "T";
        }
        assert (this.isFalsified(n));
        return "F";
    }

    @Override
    public int nVars() {
        return this.truthValue.length - 1;
    }

    @Override
    public int not(int n) {
        return n ^ 1;
    }

    public static String toString(int n) {
        return ((n & 1) == 0 ? "" : "-") + (n >> 1);
    }

    @Override
    public void reset(int n) {
        this.watches[n].clear();
        this.watches[n ^ 1].clear();
        this.level[n >> 1] = -1;
        this.truthValue[n >> 1] = Lbool.UNDEFINED;
        this.reason[n >> 1] = null;
        this.undos[n >> 1].clear();
    }

    @Override
    public int getLevel(int n) {
        return this.level[n >> 1];
    }

    @Override
    public void setLevel(int n, int n2) {
        this.level[n >> 1] = n2;
    }

    @Override
    public Constr getReason(int n) {
        return this.reason[n >> 1];
    }

    @Override
    public void setReason(int n, Constr constr) {
        this.reason[n >> 1] = constr;
    }

    @Override
    public IVec<Undoable> undos(int n) {
        return this.undos[n >> 1];
    }

    @Override
    public void watch(int n, Propagatable propagatable) {
        this.watches[n].push(propagatable);
    }

    @Override
    public IVec<Propagatable> watches(int n) {
        return this.watches[n];
    }

    @Override
    public boolean isImplied(int n) {
        int n2 = n >> 1;
        assert (this.reason[n2] == null || this.truthValue[n2] != Lbool.UNDEFINED);
        return this.reason[n2] != null || this.level[n2] == 0;
    }

    @Override
    public int realnVars() {
        return this.realnVars;
    }
}

