/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.pb;

import java.math.BigInteger;
import java.util.Map;
import org.sat4j.minisat.constraints.pb.MapPb;
import org.sat4j.minisat.constraints.pb.WatchPb;
import org.sat4j.minisat.core.ILits;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Conflict
extends MapPb {
    private ILits voc;
    private BigInteger coefMult = BigInteger.ZERO;
    private BigInteger coefMultCons = BigInteger.ZERO;

    Conflict(Map<Integer, BigInteger> map, BigInteger bigInteger, ILits iLits) {
        super(map, bigInteger);
        this.voc = iLits;
    }

    BigInteger resolve(WatchPb watchPb, int n) {
        int n2;
        assert (n > 1);
        if (!this.coefs.containsKey(n ^ 1)) {
            return this.degree;
        }
        assert (this.slackConflict().signum() <= 0);
        assert (this.degree.signum() >= 0);
        BigInteger[] bigIntegerArray = watchPb.getCoefs();
        BigInteger bigInteger = watchPb.getDegree();
        int[] nArray = watchPb.getLits();
        for (n2 = 0; n2 < bigIntegerArray.length; ++n2) {
            assert (bigIntegerArray[n2].signum() > 0);
        }
        n2 = -1;
        while (nArray[++n2] != n) {
        }
        assert (nArray[n2] == n);
        assert (bigIntegerArray[n2] != BigInteger.ZERO);
        bigInteger = this.reduceUntilConflict(n, n2, nArray, bigIntegerArray, bigInteger, watchPb);
        bigInteger = bigInteger.multiply(this.coefMultCons);
        this.degree = this.degree.multiply(this.coefMult);
        if (this.coefMult.compareTo(BigInteger.ONE) > 0) {
            for (Integer n3 : this.coefs.keySet()) {
                this.coefs.put(n3, ((BigInteger)this.coefs.get(n3)).multiply(this.coefMult));
            }
        }
        this.degree = this.addCoeffNewConstraint(nArray, bigIntegerArray, bigInteger, this.coefMultCons);
        assert (!this.coefs.containsKey(n));
        assert (!this.coefs.containsKey(n ^ 1));
        assert (this.degree.signum() > 0);
        this.degree = this.saturation();
        assert (this.slackConflict().signum() <= 0);
        return this.degree;
    }

    private BigInteger reduceUntilConflict(int n, int n2, int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger, WatchPb watchPb) {
        BigInteger bigInteger2 = BigInteger.ONE.negate();
        BigInteger bigInteger3 = BigInteger.ZERO;
        BigInteger bigInteger4 = BigInteger.ZERO;
        int n3 = -1;
        do {
            ++n3;
            if (bigInteger2.signum() >= 0) {
                assert (bigInteger3.signum() > 0);
                BigInteger bigInteger5 = this.reduceInConstraint(bigIntegerArray, nArray, n2, bigInteger);
                assert (bigInteger5.compareTo(bigInteger) < 0 && bigInteger5.compareTo(BigInteger.ONE) >= 0);
                bigInteger = bigInteger5;
            }
            assert (((BigInteger)this.coefs.get(n ^ 1)).signum() > 0);
            assert (bigIntegerArray[n2].signum() > 0);
            BigInteger bigInteger6 = Conflict.ppcm(bigIntegerArray[n2], (BigInteger)this.coefs.get(n ^ 1));
            assert (bigInteger6.signum() > 0);
            this.coefMult = bigInteger6.divide((BigInteger)this.coefs.get(n ^ 1));
            this.coefMultCons = bigInteger6.divide(bigIntegerArray[n2]);
            assert (this.coefMultCons.signum() > 0);
            assert (this.coefMult.signum() > 0);
            assert (this.coefMult.multiply((BigInteger)this.coefs.get(n ^ 1)).equals(this.coefMultCons.multiply(bigIntegerArray[n2])));
            bigInteger3 = watchPb.slackConstraint(bigIntegerArray, bigInteger).multiply(this.coefMultCons);
            bigInteger4 = this.slackConflict().multiply(this.coefMult);
            assert (bigInteger4.signum() <= 0);
        } while ((bigInteger2 = bigInteger3.add(bigInteger4)).signum() >= 0);
        assert (this.coefMult.multiply((BigInteger)this.coefs.get(n ^ 1)).equals(this.coefMultCons.multiply(bigIntegerArray[n2])));
        return bigInteger;
    }

    BigInteger slackConflict() {
        BigInteger bigInteger = BigInteger.ZERO;
        for (Integer n : this.coefs.keySet()) {
            if (((BigInteger)this.coefs.get(n)).signum() == 0 || this.voc.isFalsified(n)) continue;
            bigInteger = bigInteger.add((BigInteger)this.coefs.get(n));
        }
        return bigInteger.subtract(this.degree);
    }

    BigInteger getDegree() {
        return this.degree;
    }

    boolean isAssertive(int n) {
        BigInteger bigInteger = BigInteger.ZERO;
        for (Integer n2 : this.coefs.keySet()) {
            if (((BigInteger)this.coefs.get(n2)).signum() <= 0 || this.voc.isFalsified(n2) && this.voc.getLevel(n2) < n) continue;
            bigInteger = bigInteger.add((BigInteger)this.coefs.get(n2));
        }
        if ((bigInteger = bigInteger.subtract(this.degree)).signum() < 0) {
            return false;
        }
        for (Integer n2 : this.coefs.keySet()) {
            if (((BigInteger)this.coefs.get(n2)).signum() <= 0 || !this.voc.isUnassigned(n2) && this.voc.getLevel(n2) < n || bigInteger.subtract((BigInteger)this.coefs.get(n2)).signum() >= 0) continue;
            return true;
        }
        return false;
    }

    protected static BigInteger ppcm(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.divide(bigInteger.gcd(bigInteger2)).multiply(bigInteger2);
    }

    public BigInteger reduceInConstraint(BigInteger[] bigIntegerArray, int[] nArray, int n, BigInteger bigInteger) {
        int n2;
        int n3;
        assert (bigInteger.compareTo(BigInteger.ONE) > 0);
        int n4 = -1;
        for (n3 = 0; n3 < nArray.length && n4 == -1; ++n3) {
            if (bigIntegerArray[n3].signum() == 0 || !this.voc.isUnassigned(nArray[n3])) continue;
            assert (bigIntegerArray[n3].compareTo(bigInteger) < 0);
            n4 = n3;
        }
        if (n4 == -1) {
            for (n3 = 0; n3 < nArray.length && n4 == -1; ++n3) {
                if (bigIntegerArray[n3].signum() == 0 || !this.voc.isSatisfied(nArray[n3]) || n3 == n) continue;
                n4 = n3;
            }
        }
        assert (n4 != -1);
        assert (n4 != n);
        BigInteger bigInteger2 = bigInteger.subtract(bigIntegerArray[n4]);
        bigIntegerArray[n4] = BigInteger.ZERO;
        assert (bigInteger2.signum() > 0);
        BigInteger bigInteger3 = bigInteger2;
        for (n2 = 0; n2 < bigIntegerArray.length; ++n2) {
            if (bigIntegerArray[n2].signum() > 0) {
                bigInteger3 = bigInteger3.min(bigIntegerArray[n2]);
            }
            bigIntegerArray[n2] = bigInteger2.min(bigIntegerArray[n2]);
        }
        if (bigInteger3.equals(bigInteger2) && !bigInteger2.equals(BigInteger.ONE)) {
            bigInteger2 = BigInteger.ONE;
            for (n2 = 0; n2 < bigIntegerArray.length; ++n2) {
                if (bigIntegerArray[n2].signum() <= 0) continue;
                bigIntegerArray[n2] = bigInteger2;
            }
        }
        assert (bigIntegerArray[n].signum() > 0);
        assert (bigInteger.compareTo(bigInteger2) > 0);
        return bigInteger2;
    }
}

