/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.pb;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MapPb {
    protected Map<Integer, BigInteger> coefs;
    protected BigInteger degree;

    MapPb(Map<Integer, BigInteger> map, BigInteger bigInteger) {
        this.coefs = map;
        this.degree = bigInteger;
    }

    MapPb() {
        this(new HashMap<Integer, BigInteger>(), BigInteger.ZERO);
    }

    BigInteger saturation() {
        assert (this.degree.signum() > 0);
        BigInteger bigInteger = this.degree;
        for (Map.Entry<Integer, BigInteger> object : this.coefs.entrySet()) {
            assert (object.getValue().signum() > 0);
            object.setValue(this.degree.min(object.getValue()));
            assert (object.getValue().signum() > 0);
            bigInteger = bigInteger.min(object.getValue());
        }
        if (bigInteger.equals(this.degree) && bigInteger.compareTo(BigInteger.ONE) > 0) {
            this.degree = BigInteger.ONE;
            for (Integer n : this.coefs.keySet()) {
                this.coefs.put(n, BigInteger.ONE);
            }
        }
        return this.degree;
    }

    BigInteger addCoeffNewConstraint(int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger) {
        return this.addCoeffNewConstraint(nArray, bigIntegerArray, bigInteger, BigInteger.ONE);
    }

    BigInteger addCoeffNewConstraint(int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger, BigInteger bigInteger2) {
        this.degree = this.degree.add(bigInteger);
        assert (this.degree.signum() > 0);
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            BigInteger bigInteger3 = bigIntegerArray[i].multiply(bigInteger2);
            assert (bigInteger3.signum() >= 0);
            if (bigInteger3.signum() > 0) {
                if (!this.coefs.containsKey(n ^ 1)) {
                    assert (!this.coefs.containsKey(n) || this.coefs.get(n).signum() > 0);
                    this.coefs.put(n, (this.coefs.containsKey(n) ? this.coefs.get(n) : BigInteger.ZERO).add(bigInteger3));
                    assert (this.coefs.get(n).signum() > 0);
                } else {
                    assert (!this.coefs.containsKey(n));
                    if (this.coefs.get(n ^ 1).compareTo(bigInteger3) < 0) {
                        this.coefs.put(n, bigInteger3.subtract(this.coefs.get(n ^ 1)));
                        assert (this.coefs.get(n).signum() > 0);
                        this.degree = this.degree.subtract(this.coefs.get(n ^ 1));
                        this.coefs.remove(n ^ 1);
                    } else if (this.coefs.get(n ^ 1).equals(bigInteger3)) {
                        this.degree = this.degree.subtract(bigInteger3);
                        this.coefs.remove(n ^ 1);
                    } else {
                        this.coefs.put(n ^ 1, this.coefs.get(n ^ 1).subtract(bigInteger3));
                        assert (this.coefs.get(n ^ 1).signum() > 0);
                        this.degree = this.degree.subtract(bigInteger3);
                    }
                }
            }
            assert (!this.coefs.containsKey(n ^ 1) || !this.coefs.containsKey(n));
        }
        return this.degree;
    }

    void buildConstraintFromConflict(IVecInt iVecInt, IVec<BigInteger> iVec) {
        iVecInt.clear();
        iVec.clear();
        for (Map.Entry<Integer, BigInteger> entry : this.coefs.entrySet()) {
            iVecInt.push(entry.getKey());
            assert (entry.getValue().signum() > 0);
            iVec.push(entry.getValue());
        }
    }

    void buildConstraintFromMapPb(int[] nArray, BigInteger[] bigIntegerArray) {
        assert (nArray.length == bigIntegerArray.length);
        assert (nArray.length == this.coefs.keySet().size());
        int n = 0;
        for (Map.Entry<Integer, BigInteger> entry : this.coefs.entrySet()) {
            nArray[n] = entry.getKey();
            assert (entry.getValue().signum() > 0);
            bigIntegerArray[n] = entry.getValue();
            ++n;
        }
    }

    int size() {
        return this.coefs.keySet().size();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<Integer, BigInteger> entry : this.coefs.entrySet()) {
            stringBuilder.append(entry.getValue());
            stringBuilder.append(".");
            int n = entry.getKey();
            stringBuilder.append(Lits.toString(n));
            stringBuilder.append(" ");
        }
        return stringBuilder.toString() + " >= " + this.degree;
    }
}

