/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.pb;

import java.io.Serializable;
import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.constraints.pb.WatchPb;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinWatchPb
extends WatchPb
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean[] watched;
    private int[] watching;
    private int watchingCount = 0;

    private MinWatchPb(ILits iLits, IVecInt iVecInt, IVec<BigInteger> iVec, boolean bl, BigInteger bigInteger) {
        super(iVecInt, iVec, bl, bigInteger);
        this.voc = iLits;
        this.watching = new int[this.coefs.length];
        this.watched = new boolean[this.coefs.length];
        this.activity = 0.0;
        this.watchCumul = BigInteger.ZERO;
        this.locked = false;
        this.undos = new VecInt();
        this.watchingCount = 0;
    }

    @Override
    protected void computeWatches() throws ContradictionException {
        int n;
        assert (this.watchCumul.signum() == 0);
        assert (this.watchingCount == 0);
        for (n = 0; n < this.lits.length && this.watchCumul.subtract(this.coefs[0]).compareTo(this.degree) < 0; ++n) {
            if (this.voc.isFalsified(this.lits[n])) continue;
            this.voc.watch(this.lits[n] ^ 1, this);
            this.watching[this.watchingCount++] = n;
            this.watched[n] = true;
            this.watchCumul = this.watchCumul.add(this.coefs[n]);
        }
        if (this.learnt) {
            n = 1;
            while (this.watchCumul.subtract(this.coefs[0]).compareTo(this.degree) < 0 && n > 0) {
                n = 0;
                int n2 = -1;
                int n3 = -1;
                for (int i = 0; i < this.lits.length; ++i) {
                    if (!this.voc.isFalsified(this.lits[i]) || this.watched[i]) continue;
                    ++n;
                    int n4 = this.voc.getLevel(this.lits[i]);
                    if (n4 <= n2) continue;
                    n3 = i;
                    n2 = n4;
                }
                if (n <= 0) continue;
                assert (n3 >= 0);
                this.voc.watch(this.lits[n3] ^ 1, this);
                this.watching[this.watchingCount++] = n3;
                this.watched[n3] = true;
                this.watchCumul = this.watchCumul.add(this.coefs[n3]);
                assert (--n >= 0);
            }
            assert (this.lits.length == 1 || this.watchingCount > 1);
        }
        if (this.watchCumul.compareTo(this.degree) < 0) {
            throw new ContradictionException("non satisfiable constraint");
        }
        assert (this.nbOfWatched() == this.watchingCount);
    }

    @Override
    protected void computePropagation(UnitPropagationListener unitPropagationListener) throws ContradictionException {
        for (int i = 0; i < this.lits.length && this.watchCumul.subtract(this.coefs[this.watching[i]]).compareTo(this.degree) < 0; ++i) {
            if (!this.voc.isUnassigned(this.lits[i]) || unitPropagationListener.enqueue(this.lits[i], this)) continue;
            throw new ContradictionException("non satisfiable constraint");
        }
    }

    public static MinWatchPb minWatchPbNew(UnitPropagationListener unitPropagationListener, ILits iLits, IVecInt iVecInt, IVecInt iVecInt2, boolean bl, int n) throws ContradictionException {
        return MinWatchPb.minWatchPbNew(unitPropagationListener, iLits, iVecInt, MinWatchPb.toVecBigInt(iVecInt2), bl, MinWatchPb.toBigInt(n));
    }

    public static MinWatchPb minWatchPbNew(UnitPropagationListener unitPropagationListener, ILits iLits, IVecInt iVecInt, IVec<BigInteger> iVec, boolean bl, BigInteger bigInteger) throws ContradictionException {
        VecInt vecInt = new VecInt(iVecInt.size());
        Vec<BigInteger> vec = new Vec<BigInteger>(iVec.size());
        iVecInt.copyTo(vecInt);
        iVec.copyTo(vec);
        MinWatchPb.niceParameter(vecInt, vec);
        MinWatchPb minWatchPb = new MinWatchPb(iLits, vecInt, vec, bl, bigInteger);
        if (minWatchPb.degree.signum() <= 0) {
            return null;
        }
        minWatchPb.computeWatches();
        minWatchPb.computePropagation(unitPropagationListener);
        return minWatchPb;
    }

    protected int nbOfWatched() {
        int n = 0;
        for (int i = 0; i < this.watched.length; ++i) {
            for (int j = 0; j < this.watchingCount; ++j) {
                if (this.watching[j] == i) assert (this.watched[i]);
            }
            n += this.watched[i] ? 1 : 0;
        }
        return n;
    }

    @Override
    public boolean propagate(UnitPropagationListener unitPropagationListener, int n) {
        int n2;
        int n3;
        assert (this.nbOfWatched() == this.watchingCount);
        assert (this.watchingCount > 1);
        for (n3 = 0; n3 < this.watchingCount && (this.lits[this.watching[n3]] ^ 1) != n; ++n3) {
        }
        int n4 = this.watching[n3];
        assert (n == (this.lits[n4] ^ 1));
        assert (this.watched[n4]);
        BigInteger bigInteger = BigInteger.ZERO;
        for (n2 = 0; n2 < this.watchingCount; ++n2) {
            if (this.coefs[this.watching[n2]].compareTo(bigInteger) <= 0 || this.watching[n2] == n4) continue;
            bigInteger = this.coefs[this.watching[n2]];
        }
        assert (this.learnt || bigInteger.signum() != 0);
        if (this.watchingCount >= this.size()) {
            n2 = this.lits.length;
        } else {
            for (n2 = 0; n2 < this.lits.length && this.watchCumul.subtract(this.coefs[n4]).subtract(bigInteger).compareTo(this.degree) < 0; ++n2) {
                if (this.voc.isFalsified(this.lits[n2]) || this.watched[n2]) continue;
                this.watchCumul = this.watchCumul.add(this.coefs[n2]);
                this.watched[n2] = true;
                assert (this.watchingCount < this.size());
                this.watching[this.watchingCount++] = n2;
                this.voc.watch(this.lits[n2] ^ 1, this);
                if (this.coefs[n2].compareTo(bigInteger) <= 0) continue;
                bigInteger = this.coefs[n2];
            }
        }
        assert (this.nbOfWatched() == this.watchingCount);
        if (this.watchCumul.subtract(this.coefs[n4]).compareTo(this.degree) < 0) {
            this.voc.watch(n, this);
            assert (this.watched[n4]);
            assert (!this.isSatisfiable());
            return false;
        }
        if (n2 >= this.lits.length) {
            assert (this.watchingCount != 0);
            for (int i = 0; i < this.watchingCount; ++i) {
                if (this.watchCumul.subtract(this.coefs[n4]).subtract(this.coefs[this.watching[i]]).compareTo(this.degree) >= 0 || i == n3 || this.voc.isSatisfied(this.lits[this.watching[i]]) || unitPropagationListener.enqueue(this.lits[this.watching[i]], this)) continue;
                this.voc.watch(n, this);
                assert (!this.isSatisfiable());
                return false;
            }
            this.voc.undos(n).push(this);
        }
        this.watched[n4] = false;
        this.watchCumul = this.watchCumul.subtract(this.coefs[n4]);
        this.watching[n3] = this.watching[--this.watchingCount];
        assert (this.watchingCount != 0);
        assert (this.nbOfWatched() == this.watchingCount);
        return true;
    }

    @Override
    public void remove() {
        for (int i = 0; i < this.watchingCount; ++i) {
            this.voc.watches(this.lits[this.watching[i]] ^ 1).remove(this);
            this.watched[this.watching[i]] = false;
        }
        this.watchingCount = 0;
        assert (this.nbOfWatched() == this.watchingCount);
    }

    @Override
    public void undo(int n) {
        this.voc.watch(n, this);
        int n2 = 0;
        while ((this.lits[n2] ^ 1) != n) {
            ++n2;
        }
        assert (n2 < this.lits.length);
        this.watchCumul = this.watchCumul.add(this.coefs[n2]);
        assert (this.watchingCount == this.nbOfWatched());
        this.watched[n2] = true;
        this.watching[this.watchingCount++] = n2;
        assert (this.watchingCount == this.nbOfWatched());
    }

    public static WatchPb watchPbNew(ILits iLits, IVecInt iVecInt, IVecInt iVecInt2, boolean bl, int n) {
        return new MinWatchPb(iLits, iVecInt, MinWatchPb.toVecBigInt(iVecInt2), bl, MinWatchPb.toBigInt(n));
    }

    public static WatchPb watchPbNew(ILits iLits, IVecInt iVecInt, IVec<BigInteger> iVec, boolean bl, BigInteger bigInteger) {
        return new MinWatchPb(iLits, iVecInt, iVec, bl, bigInteger);
    }
}

