/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.pb;

import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.constraints.pb.Conflict;
import org.sat4j.minisat.constraints.pb.WatchPb;
import org.sat4j.minisat.core.AssertingClauseGenerator;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.DataStructureFactory;
import org.sat4j.minisat.core.Handle;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.LearningStrategy;
import org.sat4j.minisat.core.SearchParams;
import org.sat4j.minisat.core.Solver;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PBSolver
extends Solver {
    private static final long serialVersionUID = 1L;

    public PBSolver(AssertingClauseGenerator assertingClauseGenerator, LearningStrategy learningStrategy, DataStructureFactory dataStructureFactory, IOrder iOrder) {
        super(assertingClauseGenerator, learningStrategy, dataStructureFactory, new SearchParams(10000.0, 100), iOrder);
    }

    @Override
    public int analyze(Constr constr, Handle<Constr> handle) {
        Object object;
        Conflict conflict = ((WatchPb)constr).createConflict();
        BigInteger bigInteger = conflict.getDegree();
        int n = this.trail.last();
        int n2 = this.voc.getLevel(n);
        assert (conflict.slackConflict().signum() < 0);
        while (!conflict.isAssertive(n2)) {
            object = (WatchPb)this.voc.getReason(n);
            if (object != null) {
                bigInteger = conflict.resolve((WatchPb)object, n);
                assert (conflict.slackConflict().signum() <= 0);
            }
            if (this.trail.size() == 1) break;
            this.undoOne();
            if (this.decisionLevel() <= 0) break;
            n = this.trail.last();
            if (this.voc.getLevel(n) != n2) {
                this.trailLim.pop();
            }
            n2 = this.voc.getLevel(n);
            assert (n2 == this.decisionLevel());
            assert (n > 1);
        }
        assert (n2 == this.decisionLevel());
        if (this.decisionLevel() == 0) {
            handle.obj = null;
            return -1;
        }
        this.undoOne();
        object = new VecInt();
        Vec<BigInteger> vec = new Vec<BigInteger>();
        conflict.buildConstraintFromConflict((IVecInt)object, vec);
        assert (object.size() == vec.size());
        if (object.size() == 0) {
            handle.obj = null;
            return -1;
        }
        WatchPb watchPb = (WatchPb)this.dsfactory.createUnregisteredPseudoBooleanConstraint((IVecInt)object, vec, bigInteger);
        handle.obj = watchPb;
        assert (conflict.isAssertive(n2));
        int n3 = watchPb.getBacktrackLevel(n2);
        return n3;
    }
}

