/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.pb;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Random;
import org.sat4j.core.Vec;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.constraints.pb.Conflict;
import org.sat4j.minisat.constraints.pb.MapPb;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.Undoable;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WatchPb
implements Constr,
Undoable {
    public static final boolean ATMOST = false;
    public static final boolean ATLEAST = true;
    private static final Random rand = new Random(91648253L);
    protected double activity;
    protected BigInteger[] coefs;
    protected BigInteger degree;
    protected int[] lits;
    protected boolean learnt = false;
    protected boolean locked;
    protected BigInteger watchCumul = BigInteger.ZERO;
    protected IVecInt undos;
    protected int backtrackLiteral;
    protected ILits voc;

    WatchPb() {
    }

    WatchPb(IVecInt iVecInt, IVec<BigInteger> iVec, boolean bl, BigInteger bigInteger) {
        int n;
        assert (iVecInt.size() > 0);
        assert (iVecInt.size() == iVec.size());
        MapPb mapPb = new MapPb();
        this.lits = new int[iVecInt.size()];
        iVecInt.copyTo(this.lits);
        BigInteger[] bigIntegerArray = new BigInteger[iVec.size()];
        iVec.copyTo(bigIntegerArray);
        BigInteger bigInteger2 = bigInteger;
        if (!bl) {
            for (n = 0; n < this.lits.length; ++n) {
                bigIntegerArray[n] = bigIntegerArray[n].negate();
            }
            bigInteger2 = bigInteger2.negate();
            bl = true;
        }
        assert (bl);
        for (n = 0; n < bigIntegerArray.length; ++n) {
            if (bigIntegerArray[n].signum() >= 0) continue;
            this.lits[n] = this.lits[n] ^ 1;
            bigIntegerArray[n] = bigIntegerArray[n].negate();
            bigInteger2 = bigInteger2.add(bigIntegerArray[n]);
        }
        if (bigInteger2.signum() > 0) {
            bigInteger2 = mapPb.addCoeffNewConstraint(this.lits, bigIntegerArray, bigInteger2);
        }
        if (bigInteger2.signum() > 0) {
            bigInteger2 = mapPb.saturation();
        }
        n = mapPb.size();
        this.lits = new int[n];
        this.coefs = new BigInteger[n];
        mapPb.buildConstraintFromMapPb(this.lits, this.coefs);
        this.degree = bigInteger2;
        this.sort();
    }

    public boolean isAssertive(int n) {
        int n2;
        BigInteger bigInteger = BigInteger.ZERO;
        for (n2 = 0; n2 < this.lits.length; ++n2) {
            if (this.coefs[n2].signum() <= 0 || this.voc.isFalsified(this.lits[n2]) && this.voc.getLevel(this.lits[n2]) < n) continue;
            bigInteger = bigInteger.add(this.coefs[n2]);
        }
        if ((bigInteger = bigInteger.subtract(this.degree)).signum() < 0) {
            return false;
        }
        for (n2 = 0; n2 < this.lits.length; ++n2) {
            if (this.coefs[n2].signum() <= 0 || !this.voc.isUnassigned(this.lits[n2]) && this.voc.getLevel(this.lits[n2]) < n || bigInteger.subtract(this.coefs[n2]).signum() >= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void calcReason(int n, IVecInt iVecInt) {
        for (int n2 : this.lits) {
            if (!this.voc.isFalsified(n2)) continue;
            iVecInt.push(n2 ^ 1);
        }
    }

    protected abstract void computeWatches() throws ContradictionException;

    protected abstract void computePropagation(UnitPropagationListener var1) throws ContradictionException;

    @Override
    public int get(int n) {
        return this.lits[n];
    }

    public BigInteger getCoef(int n) {
        return this.coefs[n];
    }

    @Override
    public double getActivity() {
        return this.activity;
    }

    protected static void niceParameter(IVecInt iVecInt, IVec<BigInteger> iVec) throws ContradictionException {
        if (iVecInt.size() == 0) {
            throw new ContradictionException("Creating Empty clause ?");
        }
        if (iVecInt.size() != iVec.size()) {
            throw new IllegalArgumentException("Contradiction dans la taille des tableaux ps=" + iVecInt.size() + " coefs=" + iVec.size() + ".");
        }
    }

    @Override
    public void incActivity(double d) {
        this.activity += d;
    }

    public BigInteger slackConstraint() {
        return this.recalcLeftSide().subtract(this.degree);
    }

    public BigInteger slackConstraint(BigInteger[] bigIntegerArray, BigInteger bigInteger) {
        return this.recalcLeftSide(bigIntegerArray).subtract(bigInteger);
    }

    public BigInteger recalcLeftSide(BigInteger[] bigIntegerArray) {
        BigInteger bigInteger = BigInteger.ZERO;
        for (int i = 0; i < bigIntegerArray.length; ++i) {
            if (bigIntegerArray[i].signum() <= 0 || this.voc.isFalsified(this.lits[i])) continue;
            bigInteger = bigInteger.add(bigIntegerArray[i]);
        }
        return bigInteger;
    }

    public BigInteger recalcLeftSide() {
        return this.recalcLeftSide(this.coefs);
    }

    protected boolean isSatisfiable() {
        BigInteger bigInteger = BigInteger.ZERO;
        for (int i = 0; i < this.lits.length; ++i) {
            if (this.voc.isFalsified(this.lits[i])) continue;
            assert (this.coefs[i].signum() > 0);
            bigInteger = bigInteger.add(this.coefs[i]);
        }
        return bigInteger.compareTo(this.degree) >= 0;
    }

    @Override
    public boolean learnt() {
        return this.learnt;
    }

    @Override
    public boolean locked() {
        return true;
    }

    protected static BigInteger ppcm(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.divide(bigInteger.gcd(bigInteger2)).multiply(bigInteger2);
    }

    @Override
    public void rescaleBy(double d) {
        this.activity *= d;
    }

    void selectionSort(int n, int n2) {
        for (int i = n; i < n2 - 1; ++i) {
            int n3 = i;
            for (int j = i + 1; j < n2; ++j) {
                if (this.coefs[j].compareTo(this.coefs[n3]) <= 0) continue;
                n3 = j;
            }
            BigInteger bigInteger = this.coefs[i];
            this.coefs[i] = this.coefs[n3];
            this.coefs[n3] = bigInteger;
            int n4 = this.lits[i];
            this.lits[i] = this.lits[n3];
            this.lits[n3] = n4;
        }
    }

    @Override
    public void setLearnt() {
        this.learnt = true;
    }

    @Override
    public boolean simplify() {
        BigInteger bigInteger = BigInteger.ZERO;
        for (int i = 0; i < this.lits.length && bigInteger.compareTo(this.degree) < 0; ++i) {
            if (!this.voc.isSatisfied(this.lits[i])) continue;
            bigInteger = bigInteger.add(this.coefs[i]);
        }
        return bigInteger.compareTo(this.degree) >= 0;
    }

    @Override
    public int size() {
        return this.lits.length;
    }

    protected void sort() {
        assert (this.lits != null);
        if (this.size() > 0) {
            this.sort(0, this.size());
            BigInteger bigInteger = this.coefs[0];
            for (int i = 1; i < this.size(); ++i) {
                assert (bigInteger.compareTo(this.coefs[i]) >= 0);
                bigInteger = this.coefs[i];
            }
        }
    }

    protected void sort(int n, int n2) {
        int n3 = n2 - n;
        if (n2 - n <= 15) {
            this.selectionSort(n, n2);
        } else {
            BigInteger bigInteger = this.coefs[rand.nextInt(n3) + n];
            int n4 = n - 1;
            int n5 = n2;
            while (true) {
                if (this.coefs[++n4].compareTo(bigInteger) > 0) {
                    continue;
                }
                while (bigInteger.compareTo(this.coefs[--n5]) > 0) {
                }
                if (n4 >= n5) break;
                BigInteger bigInteger2 = this.coefs[n4];
                this.coefs[n4] = this.coefs[n5];
                this.coefs[n5] = bigInteger2;
                int n6 = this.lits[n4];
                this.lits[n4] = this.lits[n5];
                this.lits[n5] = n6;
            }
            this.sort(n, n4);
            this.sort(n4, n2);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.lits.length > 0) {
            stringBuffer.append(this.coefs[0]);
            stringBuffer.append(".");
            stringBuffer.append(Lits.toString(this.lits[0]));
            stringBuffer.append("[");
            stringBuffer.append(this.voc.valueToString(this.lits[0]));
            stringBuffer.append("@");
            stringBuffer.append(this.voc.getLevel(this.lits[0]));
            stringBuffer.append("]");
            stringBuffer.append(" ");
            for (int i = 1; i < this.lits.length; ++i) {
                stringBuffer.append(" + ");
                stringBuffer.append(this.coefs[i]);
                stringBuffer.append(".");
                stringBuffer.append(Lits.toString(this.lits[i]));
                stringBuffer.append("[");
                stringBuffer.append(this.voc.valueToString(this.lits[i]));
                stringBuffer.append("@");
                stringBuffer.append(this.voc.getLevel(this.lits[i]));
                stringBuffer.append("]");
                stringBuffer.append(" ");
            }
            stringBuffer.append(">= ");
            stringBuffer.append(this.degree);
        }
        return stringBuffer.toString();
    }

    public int getBacktrackLevel(int n) {
        int n2;
        int n3;
        int n4 = n;
        assert (this.isAssertive(n4));
        int n5 = -1;
        for (n3 = 0; n3 < this.lits.length; ++n3) {
            n2 = this.voc.getLevel(this.lits[n3]);
            if (n2 >= n4 || n2 <= n5) continue;
            if (this.isAssertive(n2)) {
                n4 = n2;
                continue;
            }
            n5 = n2;
        }
        n3 = 0;
        for (int i = 0; i < this.lits.length; ++i) {
            n2 = this.voc.getLevel(this.lits[i]);
            if (n2 <= n3 || n2 >= n4) continue;
            n3 = n2;
        }
        return n3;
    }

    @Override
    public void assertConstraint(UnitPropagationListener unitPropagationListener) {
        BigInteger bigInteger = this.slackConstraint();
        for (int i = 0; i < this.lits.length; ++i) {
            if (!this.voc.isUnassigned(this.lits[i]) || bigInteger.subtract(this.coefs[i]).signum() >= 0) continue;
            boolean bl = unitPropagationListener.enqueue(this.lits[i], this);
            assert (bl);
        }
    }

    public BigInteger getDegree() {
        return this.degree;
    }

    @Override
    public void register() {
        block3: {
            assert (this.learnt);
            try {
                this.computeWatches();
            }
            catch (ContradictionException contradictionException) {
                System.out.println(this);
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    protected static IVec<BigInteger> toVecBigInt(IVecInt iVecInt) {
        Vec<BigInteger> vec = new Vec<BigInteger>(iVecInt.size());
        for (int i = 0; i < iVecInt.size(); ++i) {
            vec.push(BigInteger.valueOf(iVecInt.get(i)));
        }
        return vec;
    }

    protected static BigInteger toBigInt(int n) {
        return BigInteger.valueOf(n);
    }

    protected Conflict createConflict() {
        HashMap<Integer, BigInteger> hashMap = new HashMap<Integer, BigInteger>();
        for (int i = 0; i < this.lits.length; ++i) {
            assert (this.lits[i] != 0);
            assert (this.coefs[i].signum() > 0);
            hashMap.put(this.lits[i], this.coefs[i]);
        }
        return new Conflict(hashMap, this.degree, this.voc);
    }

    protected BigInteger[] getCoefs() {
        BigInteger[] bigIntegerArray = new BigInteger[this.coefs.length];
        System.arraycopy(this.coefs, 0, bigIntegerArray, 0, this.coefs.length);
        return bigIntegerArray;
    }

    protected int[] getLits() {
        int[] nArray = new int[this.lits.length];
        System.arraycopy(this.lits, 0, nArray, 0, this.lits.length);
        return nArray;
    }
}

