/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.core;

import java.io.PrintStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.Timer;
import java.util.TimerTask;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.core.ActivityComparator;
import org.sat4j.minisat.core.ActivityListener;
import org.sat4j.minisat.core.AssertingClauseGenerator;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.DataStructureFactory;
import org.sat4j.minisat.core.Handle;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.Lbool;
import org.sat4j.minisat.core.Learner;
import org.sat4j.minisat.core.LearningStrategy;
import org.sat4j.minisat.core.NullSearchListener;
import org.sat4j.minisat.core.Propagatable;
import org.sat4j.minisat.core.SearchListener;
import org.sat4j.minisat.core.SearchParams;
import org.sat4j.minisat.core.SolverStats;
import org.sat4j.minisat.core.Undoable;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Solver
implements ISolver,
UnitPropagationListener,
ActivityListener,
Learner,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final double CLAUSE_RESCALE_FACTOR = 1.0E-20;
    private static final double CLAUSE_RESCALE_BOUND = 1.0E20;
    private final IVec<Constr> constrs = new Vec<Constr>();
    private final IVec<Constr> learnts = new Vec<Constr>();
    private double claInc = 1.0;
    private double claDecay = 1.0;
    private int qhead = 0;
    protected final IVecInt trail = new VecInt();
    protected final IVecInt trailLim = new VecInt();
    protected int rootLevel;
    private int[] model = null;
    protected final ILits voc;
    private IOrder order;
    private final Comparator<Constr> comparator = new ActivityComparator();
    private final SolverStats stats = new SolverStats();
    private final LearningStrategy learner;
    protected final AssertingClauseGenerator analyzer;
    private boolean undertimeout;
    private int timeout = Integer.MAX_VALUE;
    protected final DataStructureFactory dsfactory;
    private final SearchParams params;
    private final IVecInt __dimacs_out = new VecInt();
    private SearchListener slistener = new NullSearchListener();
    private boolean[] seen = new boolean[0];
    private final IVecInt preason = new VecInt();
    private final IVecInt outLearnt = new VecInt();
    public static final ISimplifier NO_SIMPLIFICATION = new ISimplifier(){
        private static final long serialVersionUID = 1L;

        public void simplify(IVecInt iVecInt) {
        }

        public String toString() {
            return "No reason simplification";
        }
    };
    public final ISimplifier SIMPLE_SIMPLIFICATION = new ISimplifier(){
        private static final long serialVersionUID = 1L;

        public void simplify(IVecInt iVecInt) {
            Solver.this.simpleSimplification(iVecInt);
        }

        public String toString() {
            return "Simple reason simplification";
        }
    };
    private ISimplifier simplifier = NO_SIMPLIFICATION;
    private final Handle<Constr> learntConstraint = new Handle();
    private double timebegin = 0.0;

    private IVecInt dimacs2internal(IVecInt iVecInt) {
        if (this.voc.nVars() == 0) {
            throw new RuntimeException("Please set the number of variables (solver.newVar() or solver.newVar(maxvar)) before adding constraints!");
        }
        this.__dimacs_out.clear();
        this.__dimacs_out.ensure(iVecInt.size());
        for (int i = 0; i < iVecInt.size(); ++i) {
            assert (iVecInt.get(i) != 0 && Math.abs(iVecInt.get(i)) <= this.voc.nVars());
            this.__dimacs_out.unsafePush(this.voc.getFromPool(iVecInt.get(i)));
        }
        return this.__dimacs_out;
    }

    public Solver(AssertingClauseGenerator assertingClauseGenerator, LearningStrategy learningStrategy, DataStructureFactory dataStructureFactory, IOrder iOrder) {
        this(assertingClauseGenerator, learningStrategy, dataStructureFactory, new SearchParams(), iOrder);
    }

    public Solver(AssertingClauseGenerator assertingClauseGenerator, LearningStrategy learningStrategy, DataStructureFactory dataStructureFactory, SearchParams searchParams, IOrder iOrder) {
        this.analyzer = assertingClauseGenerator;
        this.learner = learningStrategy;
        this.dsfactory = dataStructureFactory;
        this.dsfactory.setUnitPropagationListener(this);
        this.dsfactory.setLearner(this);
        this.order = iOrder;
        this.voc = dataStructureFactory.getVocabulary();
        iOrder.setLits(this.voc);
        this.params = searchParams;
    }

    public void setSearchListener(SearchListener searchListener) {
        this.slistener = searchListener;
    }

    @Override
    public void setTimeout(int n) {
        this.timeout = n;
    }

    protected int nAssigns() {
        return this.trail.size();
    }

    @Override
    public int nConstraints() {
        return this.constrs.size();
    }

    @Override
    public void learn(Constr constr) {
        this.learnts.push(constr);
        constr.setLearnt();
        constr.register();
        ++this.stats.learnedclauses;
        switch (constr.size()) {
            case 2: {
                ++this.stats.learnedbinaryclauses;
                break;
            }
            case 3: {
                ++this.stats.learnedternaryclauses;
            }
        }
    }

    public int decisionLevel() {
        return this.trailLim.size();
    }

    @Override
    public int newVar() {
        int n = this.voc.nVars() + 1;
        this.voc.ensurePool(n);
        this.seen = new boolean[n + 1];
        this.trail.ensure(n);
        this.trailLim.ensure(n);
        this.order.newVar();
        return n;
    }

    @Override
    public int newVar(int n) {
        this.voc.ensurePool(n);
        this.order.newVar(n);
        this.seen = new boolean[n + 1];
        this.trail.ensure(n);
        this.trailLim.ensure(n);
        return this.voc.nVars();
    }

    @Override
    public IConstr addClause(IVecInt iVecInt) throws ContradictionException {
        IVecInt iVecInt2 = this.dimacs2internal(iVecInt);
        return this.addConstr(this.dsfactory.createClause(iVecInt2));
    }

    @Override
    public boolean removeConstr(IConstr iConstr) {
        if (iConstr == null) {
            throw new UnsupportedOperationException("Reference to the constraint to remove needed!");
        }
        Constr constr = (Constr)iConstr;
        constr.remove();
        this.constrs.remove(constr);
        this.clearLearntClauses();
        this.cancelLearntLiterals();
        return true;
    }

    @Override
    public IConstr addPseudoBoolean(IVecInt iVecInt, IVec<BigInteger> iVec, boolean bl, BigInteger bigInteger) throws ContradictionException {
        IVecInt iVecInt2 = this.dimacs2internal(iVecInt);
        assert (iVecInt2.size() == iVecInt.size());
        assert (iVecInt.size() == iVec.size());
        return this.addConstr(this.dsfactory.createPseudoBooleanConstraint(iVecInt2, iVec, bl, bigInteger));
    }

    @Override
    public void addAllClauses(IVec<IVecInt> iVec) throws ContradictionException {
        for (int i = 0; i < iVec.size(); ++i) {
            this.addClause(iVec.get(i));
        }
    }

    @Override
    public IConstr addAtMost(IVecInt iVecInt, int n) throws ContradictionException {
        for (int i = 0; i < iVecInt.size(); ++i) {
            iVecInt.set(i, -iVecInt.get(i));
        }
        return this.addAtLeast(iVecInt, iVecInt.size() - n);
    }

    @Override
    public IConstr addAtLeast(IVecInt iVecInt, int n) throws ContradictionException {
        IVecInt iVecInt2 = this.dimacs2internal(iVecInt);
        return this.addConstr(this.dsfactory.createCardinalityConstraint(iVecInt2, n));
    }

    public boolean simplifyDB() {
        IVec[] iVecArray = new IVec[]{this.constrs, this.learnts};
        for (int i = 0; i < 2; ++i) {
            int n = 0;
            for (int j = 0; j < iVecArray[i].size(); ++j) {
                if (((Constr)iVecArray[i].get(j)).simplify()) {
                    ((Constr)iVecArray[i].get(j)).remove();
                    continue;
                }
                iVecArray[i].set(n++, iVecArray[i].get(j));
            }
            iVecArray[i].shrinkTo(n);
        }
        return true;
    }

    @Override
    public int[] model() {
        if (this.model == null) {
            throw new UnsupportedOperationException("Call the solve method first!!!");
        }
        int[] nArray = new int[this.model.length];
        System.arraycopy(this.model, 0, nArray, 0, this.model.length);
        return nArray;
    }

    @Override
    public boolean enqueue(int n) {
        return this.enqueue(n, null);
    }

    @Override
    public boolean enqueue(int n, Constr constr) {
        assert (n > 1);
        if (this.voc.isSatisfied(n)) {
            return true;
        }
        if (this.voc.isFalsified(n)) {
            return false;
        }
        this.voc.satisfies(n);
        this.voc.setLevel(n, this.decisionLevel());
        this.voc.setReason(n, constr);
        this.trail.push(n);
        return true;
    }

    public int analyze(Constr constr, Handle<Constr> handle) {
        int n;
        assert (constr != null);
        this.outLearnt.clear();
        assert (this.outLearnt.size() == 0);
        for (n = 0; n < this.seen.length; ++n) {
            this.seen[n] = false;
        }
        this.analyzer.initAnalyze();
        n = -1;
        this.outLearnt.push(-1);
        int n2 = 0;
        do {
            this.preason.clear();
            assert (constr != null);
            constr.calcReason(n, this.preason);
            if (constr.learnt()) {
                this.claBumpActivity(constr);
            }
            for (int i = 0; i < this.preason.size(); ++i) {
                int n3 = this.preason.get(i);
                this.order.updateVar(n3);
                if (this.seen[n3 >> 1]) continue;
                this.seen[n3 >> 1] = true;
                if (this.voc.getLevel(n3) == this.decisionLevel()) {
                    this.analyzer.onCurrentDecisionLevelLiteral(n3);
                    continue;
                }
                if (this.voc.getLevel(n3) <= 0) continue;
                this.outLearnt.push(n3 ^ 1);
                n2 = Math.max(n2, this.voc.getLevel(n3));
            }
            do {
                n = this.trail.last();
                constr = this.voc.getReason(n);
                this.undoOne();
            } while (!this.seen[n >> 1]);
        } while (this.analyzer.clauseNonAssertive(constr));
        this.simplifier.simplify(this.outLearnt);
        this.outLearnt.set(0, n ^ 1);
        Constr constr2 = this.dsfactory.createUnregisteredClause(this.outLearnt);
        this.slistener.learn(constr2);
        handle.obj = constr2;
        assert (n2 > -1);
        return n2;
    }

    public void setSimplifier(ISimplifier iSimplifier) {
        this.simplifier = iSimplifier;
    }

    private void simpleSimplification(IVecInt iVecInt) {
        int n;
        int n2 = 1;
        block0: for (n = 1; n < iVecInt.size(); ++n) {
            Constr constr = this.voc.getReason(iVecInt.get(n));
            if (constr == null) {
                iVecInt.moveTo(n2++, n);
                continue;
            }
            for (int i = 1; i < constr.size(); ++i) {
                if (this.seen[constr.get(i) >> 1] || this.voc.getLevel(constr.get(i)) == 0) continue;
                iVecInt.moveTo(n2++, n);
                continue block0;
            }
        }
        iVecInt.shrink(n - n2);
        this.stats.reducedliterals += (long)(n - n2);
    }

    public static int decode2dimacs(int n) {
        return ((n & 1) == 0 ? 1 : -1) * (n >> 1);
    }

    protected void undoOne() {
        int n = this.trail.last();
        assert (n > 1);
        assert (this.voc.getLevel(n) >= 0);
        int n2 = n >> 1;
        this.voc.unassign(n);
        this.voc.setReason(n, null);
        this.voc.setLevel(n, -1);
        this.order.undo(n2);
        this.trail.pop();
        IVec<Undoable> iVec = this.voc.undos(n);
        assert (iVec != null);
        while (iVec.size() > 0) {
            iVec.last().undo(n);
            iVec.pop();
        }
    }

    @Override
    public void claBumpActivity(Constr constr) {
        constr.incActivity(this.claInc);
        if (constr.getActivity() > 1.0E20) {
            this.claRescalActivity();
        }
    }

    @Override
    public void varBumpActivity(int n) {
        this.order.updateVar(n);
    }

    private void claRescalActivity() {
        for (int i = 0; i < this.learnts.size(); ++i) {
            this.learnts.get(i).rescaleBy(1.0E-20);
        }
        this.claInc *= 1.0E-20;
    }

    public Constr propagate() {
        while (this.qhead < this.trail.size()) {
            ++this.stats.propagations;
            int n = this.trail.get(this.qhead++);
            this.slistener.propagating(Solver.decode2dimacs(n));
            assert (n > 1);
            IVec<Propagatable> iVec = this.dsfactory.getWatchesFor(n);
            for (int i = 0; i < iVec.size(); ++i) {
                ++this.stats.inspects;
                if (iVec.get(i).propagate(this, n)) continue;
                this.dsfactory.conflictDetectedInWatchesFor(n, i);
                this.qhead = this.trail.size();
                return (Constr)iVec.get(i);
            }
        }
        return null;
    }

    void record(Constr constr) {
        constr.setLearnt();
        constr.assertConstraint(this);
        this.slistener.adding(Solver.decode2dimacs(constr.get(0)));
        if (constr.size() == 1) {
            ++this.stats.learnedliterals;
        } else {
            this.learner.learns(constr);
        }
    }

    public boolean assume(int n) {
        assert (this.trail.size() == this.qhead);
        this.trailLim.push(this.trail.size());
        return this.enqueue(n);
    }

    private void cancel() {
        int n = this.trail.unsafeGet(this.trailLim.last());
        this.slistener.backtracking(Solver.decode2dimacs(n));
        for (int i = this.trail.size() - this.trailLim.last(); i > 0; --i) {
            this.undoOne();
        }
        this.trailLim.pop();
    }

    private void cancelLearntLiterals() {
        for (int i = this.trail.size() - this.rootLevel; i > 0; --i) {
            this.undoOne();
        }
        this.qhead = this.trail.size();
    }

    protected void cancelUntil(int n) {
        while (this.decisionLevel() > n) {
            this.cancel();
        }
        this.qhead = this.trail.size();
    }

    Lbool search(long l, long l2) {
        assert (this.rootLevel == this.decisionLevel());
        ++this.stats.starts;
        int n = 0;
        this.order.setVarDecay(1.0 / this.params.getVarDecay());
        this.claDecay = 1.0 / this.params.getClaDecay();
        do {
            int n2;
            this.slistener.beginLoop();
            Constr constr = this.propagate();
            assert (this.trail.size() == this.qhead);
            if (constr != null) {
                ++this.stats.conflicts;
                ++n;
                this.slistener.conflictFound();
                if (this.decisionLevel() == this.rootLevel) {
                    return Lbool.FALSE;
                }
                assert (constr != null);
                n2 = this.analyze(constr, this.learntConstraint);
                assert (n2 < this.decisionLevel());
                this.cancelUntil(Math.max(n2, this.rootLevel));
                assert (this.decisionLevel() >= this.rootLevel && this.decisionLevel() >= n2);
                if (this.learntConstraint.obj == null) {
                    return Lbool.FALSE;
                }
                this.record((Constr)this.learntConstraint.obj);
                this.learntConstraint.obj = null;
                this.decayActivities();
                continue;
            }
            if (l2 >= 0L && (long)this.learnts.size() > l2) {
                this.reduceDB();
            }
            assert (this.nAssigns() <= this.voc.realnVars());
            if (this.nAssigns() == this.voc.realnVars()) {
                this.modelFound();
                this.slistener.solutionFound();
                return Lbool.TRUE;
            }
            if ((long)n >= l) {
                this.cancelUntil(this.rootLevel);
                return Lbool.UNDEFINED;
            }
            ++this.stats.decisions;
            n2 = this.order.select();
            assert (n2 > 1);
            this.slistener.assuming(Solver.decode2dimacs(n2));
            boolean bl = this.assume(n2);
            assert (bl);
        } while (this.undertimeout);
        return Lbool.UNDEFINED;
    }

    void modelFound() {
        this.model = new int[this.trail.size()];
        int n = 0;
        for (int i = 1; i <= this.voc.nVars(); ++i) {
            if (!this.voc.belongsToPool(i) || this.voc.isUnassigned(i)) continue;
            this.model[n++] = this.voc.isSatisfied(this.voc.getFromPool(i)) ? i : -i;
        }
        assert (n == this.model.length);
        this.cancelUntil(this.rootLevel);
    }

    protected void reduceDB() {
        this.reduceDB(this.claInc / (double)this.learnts.size());
    }

    protected void clearLearntClauses() {
        this.reduceDB(Double.MAX_VALUE);
    }

    protected void reduceDB(double d) {
        Constr constr;
        int n;
        this.sortOnActivity();
        ++this.stats.reduceddb;
        int n2 = 0;
        for (n = 0; n < this.learnts.size() / 2; ++n) {
            constr = this.learnts.get(n);
            if (!constr.locked()) {
                constr.remove();
                continue;
            }
            this.learnts.set(n2++, this.learnts.get(n));
        }
        while (n < this.learnts.size()) {
            constr = this.learnts.get(n);
            if (!constr.locked() && constr.getActivity() < d) {
                constr.remove();
            } else {
                this.learnts.set(n2++, this.learnts.get(n));
            }
            ++n;
        }
        this.learnts.shrinkTo(n2);
    }

    private void sortOnActivity() {
        this.learnts.sort(this.comparator);
    }

    protected void decayActivities() {
        this.order.varDecayActivity();
        this.claDecayActivity();
    }

    private void claDecayActivity() {
        this.claInc *= this.claDecay;
    }

    @Override
    public boolean isSatisfiable() throws TimeoutException {
        return this.isSatisfiable(VecInt.EMPTY);
    }

    @Override
    public boolean isSatisfiable(IVecInt iVecInt) throws TimeoutException {
        Lbool lbool = Lbool.UNDEFINED;
        double d = this.params.initConflictBound;
        double d2 = (double)this.nConstraints() * this.params.initLearntBoundConstraintFactor;
        this.order.init();
        this.learner.init();
        this.timebegin = System.currentTimeMillis();
        this.model = null;
        if (this.propagate() != null) {
            this.cancelUntil(0);
            return false;
        }
        Object object = iVecInt.iterator();
        while (object.hasNext()) {
            int n = (Integer)object.next();
            if (this.assume(this.voc.getFromPool(n)) && this.propagate() == null) continue;
            this.cancelUntil(0);
            return false;
        }
        this.rootLevel = this.decisionLevel();
        object = new TimerTask(){

            public void run() {
                Solver.this.undertimeout = false;
            }
        };
        this.undertimeout = true;
        Timer timer = new Timer(true);
        timer.schedule((TimerTask)object, (long)this.timeout * 1000L);
        while (lbool == Lbool.UNDEFINED && this.undertimeout) {
            lbool = this.search(Math.round(d), Math.round(d2));
            d *= this.params.conflictBoundIncFactor;
            d2 *= this.params.learntBoundIncFactor;
        }
        this.cancelUntil(0);
        timer.cancel();
        if (!this.undertimeout) {
            throw new TimeoutException(" Timeout (" + this.timeout + "s) exceeded");
        }
        return lbool == Lbool.TRUE;
    }

    public SolverStats getStats() {
        return this.stats;
    }

    public IOrder getOrder() {
        return this.order;
    }

    public void setOrder(IOrder iOrder) {
        this.order = iOrder;
        this.order.setLits(this.voc);
    }

    public ILits getVocabulary() {
        return this.voc;
    }

    @Override
    public void reset() {
        this.voc.resetPool();
        this.dsfactory.reset();
        this.constrs.clear();
        this.learnts.clear();
        this.stats.reset();
    }

    @Override
    public int nVars() {
        return this.voc.nVars();
    }

    IConstr addConstr(Constr constr) {
        if (constr != null) {
            this.constrs.push(constr);
        }
        return constr;
    }

    public DataStructureFactory getDSFactory() {
        return this.dsfactory;
    }

    public IVecInt getOutLearnt() {
        return this.outLearnt;
    }

    public IConstr getIthConstr(int n) {
        return this.constrs.get(n);
    }

    @Override
    public void printStat(PrintStream printStream, String string) {
        this.stats.printStat(printStream, string);
        double d = ((double)System.currentTimeMillis() - this.timebegin) / 1000.0;
        printStream.println(string + "speed (decisions/second)\t: " + (double)this.stats.decisions / d);
        this.order.printStat(printStream, string);
    }

    @Override
    public String toString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        Object[] objectArray = new Object[]{this.analyzer, this.dsfactory, this.learner, this.params, this.order, this.simplifier};
        stringBuilder.append(string);
        stringBuilder.append("--- Begin Solver configuration ---");
        stringBuilder.append("\n");
        for (Object object : objectArray) {
            stringBuilder.append(string);
            stringBuilder.append(object.toString());
            stringBuilder.append("\n");
        }
        stringBuilder.append(string);
        stringBuilder.append("--- End Solver configuration ---");
        return stringBuilder.toString();
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    static interface ISimplifier
    extends Serializable {
        public void simplify(IVecInt var1);
    }
}

