/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.orders;

import java.util.ArrayList;
import java.util.Collections;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.ILits23;
import org.sat4j.minisat.orders.VarOrder;

public class JWOrder
extends VarOrder {
    private static final long serialVersionUID = 1L;
    private ILits23 lits;

    private int computeWeight(int n) {
        int n2 = n << 1;
        int n3 = this.lits.nBinaryClauses(n2);
        int n4 = this.lits.nBinaryClauses(n2 ^ 1);
        int n5 = this.lits.nTernaryClauses(n2);
        int n6 = this.lits.nTernaryClauses(n2 ^ 1);
        return (n3 * n4 * 100 + n3 + n4) * 5 + n5 * n6 * 10 + n5 + n6;
    }

    public void setLits(ILits iLits) {
        super.setLits(iLits);
        this.lits = (ILits23)iLits;
    }

    public void init() {
        Temp temp;
        int n;
        super.init();
        ArrayList<Temp> arrayList = new ArrayList<Temp>(this.order.length);
        for (n = 1; n < this.order.length; ++n) {
            temp = new Temp(this.order[n]);
            arrayList.add(temp);
        }
        Collections.sort(arrayList);
        for (n = 0; n < arrayList.size(); ++n) {
            temp = (Temp)arrayList.get(n);
            this.order[n + 1] = temp.id;
            int n2 = temp.id >> 1;
            this.varpos[n2] = n + 1;
            this.activity[((Temp)temp).id >> 1] = temp.count;
        }
        this.lastVar = 1;
    }

    protected void updateActivity(int n) {
        this.activity[n] = this.computeWeight(n);
    }

    public String toString() {
        return "Jeroslow-Wang static like heuristics updated when new clauses are learnt";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Temp
    implements Comparable<Temp> {
        private final int id;
        private final int count;

        Temp(int n) {
            this.id = n;
            this.count = JWOrder.this.computeWeight(n >> 1);
        }

        @Override
        public int compareTo(Temp temp) {
            if (this.count == 0) {
                return Integer.MAX_VALUE;
            }
            if (temp.count == 0) {
                return -1;
            }
            return temp.count - this.count;
        }

        public String toString() {
            return "" + this.id + "(" + this.count + ")";
        }
    }
}

