/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Scanner;
import java.util.zip.GZIPInputStream;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.reader.csp.Nogoods;
import org.sat4j.reader.csp.Relation;
import org.sat4j.reader.csp.SupportsDirectEncoding;
import org.sat4j.reader.csp.Var;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;

public class CSPReader
implements Reader {
    private final ISolver solver;
    private int[][] domains;
    private Var[] vars;
    protected Relation[] relations;

    public CSPReader(ISolver iSolver) {
        this.solver = iSolver;
    }

    public IProblem parseInstance(String string) throws FileNotFoundException, ParseFormatException, IOException, ContradictionException {
        if (string.endsWith(".gz")) {
            this.parseInstance(new LineNumberReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(string)))));
        } else {
            this.parseInstance(new LineNumberReader(new FileReader(string)));
        }
        return this.solver;
    }

    public void parseInstance(LineNumberReader lineNumberReader) throws ParseFormatException, ContradictionException {
        this.solver.reset();
        try {
            this.readProblem(lineNumberReader);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseFormatException("integer value expected on line " + lineNumberReader.getLineNumber(), numberFormatException);
        }
    }

    public String decode(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.vars.length; ++i) {
            stringBuilder.append(this.vars[i].findValue(nArray));
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    private void readProblem(LineNumberReader lineNumberReader) throws ContradictionException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Scanner scanner = new Scanner(lineNumberReader);
        System.out.println("c reading problem named " + scanner.nextLine());
        System.out.print("c reading domains");
        int n6 = scanner.nextInt();
        this.domains = new int[n6][];
        for (n5 = 0; n5 < n6; ++n5) {
            n4 = scanner.nextInt();
            assert (n4 == n5);
            this.domains[n4] = this.readArrayOfInt(scanner);
        }
        System.out.println(" done.");
        System.out.print("c reading variables");
        n5 = scanner.nextInt();
        this.vars = new Var[n5];
        n4 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            System.out.print("\rc reading variables " + n3 + "/" + n5);
            n2 = scanner.nextInt();
            assert (n2 == n3);
            n = scanner.nextInt();
            this.vars[n2] = new Var(this.domains[n], n4);
            n4 += this.domains[n].length;
        }
        System.out.println("\rc reading variables (" + n5 + ") done.");
        this.solver.newVar(n4);
        for (n3 = 0; n3 < n5; ++n3) {
            this.vars[n3].toClause(this.solver);
        }
        System.out.print("c reading relations");
        n3 = scanner.nextInt();
        this.relations = new Relation[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            System.out.print("\rc reading relations " + n2 + "/" + n3);
            n = scanner.nextInt();
            assert (n == n2);
            boolean bl = scanner.nextInt() != 1;
            int[] nArray = this.readArrayOfInt(scanner);
            int n7 = scanner.nextInt();
            if (bl) {
                this.relations[n] = new Nogoods(nArray, n7);
            } else {
                this.manageAllowedTuples(n, nArray, n7);
            }
            for (int i = 0; i < n7; ++i) {
                int[] nArray2 = this.readArrayOfInt(scanner, this.relations[n].arity());
                this.relations[n].addTuple(i, nArray2);
            }
        }
        System.out.println("\rc reading relations (" + n3 + ") done.");
        System.out.print("c reading constraints");
        n2 = scanner.nextInt();
        for (n = 0; n < n2; ++n) {
            System.out.print("\rc reading constraints " + n + "/" + n2);
            int[] nArray = this.readArrayOfInt(scanner);
            int n8 = scanner.nextInt();
            this.relations[n8].toClause(this.solver, this.intToVar(nArray));
        }
        System.out.println("\rc reading constraints (" + n2 + ") done.");
    }

    protected void manageAllowedTuples(int n, int[] nArray, int n2) {
        this.relations[n] = new SupportsDirectEncoding(nArray, n2);
    }

    private Var[] intToVar(int[] nArray) {
        Var[] varArray = new Var[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            varArray[i] = this.vars[nArray[i]];
        }
        return varArray;
    }

    private int[] readArrayOfInt(Scanner scanner) {
        int n = scanner.nextInt();
        return this.readArrayOfInt(scanner, n);
    }

    private int[] readArrayOfInt(Scanner scanner, int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = scanner.nextInt();
        }
        return nArray;
    }
}

