/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import org.sat4j.core.VecInt;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;

public class DimacsReader
implements Reader,
Serializable {
    private static final long serialVersionUID = 1L;
    protected int expectedNbOfConstr;
    protected final ISolver solver;
    private boolean checkConstrNb = true;

    public DimacsReader(ISolver iSolver) {
        this.solver = iSolver;
    }

    public void disableNumberOfConstraintCheck() {
        this.checkConstrNb = false;
    }

    protected void skipComments(LineNumberReader lineNumberReader) throws IOException {
        int n;
        do {
            lineNumberReader.mark(4);
            n = lineNumberReader.read();
            if (n == 99) {
                lineNumberReader.readLine();
                continue;
            }
            lineNumberReader.reset();
        } while (n == 99);
    }

    protected void readProblemLine(LineNumberReader lineNumberReader) throws IOException, ParseFormatException {
        String string = lineNumberReader.readLine();
        if (string == null) {
            throw new ParseFormatException("premature end of file: <p cnf ...> expected  on line " + lineNumberReader.getLineNumber());
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (!(stringTokenizer.hasMoreTokens() && stringTokenizer.nextToken().equals("p") && stringTokenizer.hasMoreTokens() && stringTokenizer.nextToken().equals("cnf"))) {
            throw new ParseFormatException("problem line expected (p cnf ...) on line " + lineNumberReader.getLineNumber());
        }
        int n = Integer.parseInt(stringTokenizer.nextToken());
        assert (n > 0);
        this.solver.newVar(n);
        this.expectedNbOfConstr = Integer.parseInt(stringTokenizer.nextToken());
        assert (this.expectedNbOfConstr > 0);
    }

    protected void readConstrs(LineNumberReader lineNumberReader) throws IOException, ParseFormatException, ContradictionException {
        int n = 0;
        VecInt vecInt = new VecInt();
        while (true) {
            String string;
            if ((string = lineNumberReader.readLine()) == null) {
                if (vecInt.size() <= 0) break;
                this.solver.addClause(vecInt);
                ++n;
                break;
            }
            if (string.startsWith("c ")) {
                System.out.println("Found commmented line : " + string);
                continue;
            }
            if (string.startsWith("%") && this.expectedNbOfConstr == n) {
                System.out.println("Ignoring the rest of the file (SATLIB format");
                break;
            }
            boolean bl = this.handleConstr(string, vecInt);
            if (!bl) continue;
            ++n;
        }
        if (this.checkConstrNb && this.expectedNbOfConstr != n) {
            throw new ParseFormatException("wrong nbclauses parameter. Found " + n + ", " + this.expectedNbOfConstr + " expected");
        }
    }

    protected boolean handleConstr(String string, IVecInt iVecInt) throws ContradictionException {
        boolean bl = false;
        Scanner scanner = new Scanner(string);
        while (scanner.hasNext()) {
            int n = scanner.nextInt();
            if (n == 0) {
                if (iVecInt.size() <= 0) continue;
                this.solver.addClause(iVecInt);
                iVecInt.clear();
                bl = true;
                continue;
            }
            iVecInt.push(n);
        }
        return bl;
    }

    public IProblem parseInstance(String string) throws FileNotFoundException, ParseFormatException, IOException, ContradictionException {
        if (string.endsWith(".gz")) {
            this.parseInstance(new LineNumberReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(string)))));
        } else {
            this.parseInstance(new LineNumberReader(new FileReader(string)));
        }
        return this.solver;
    }

    public void parseInstance(LineNumberReader lineNumberReader) throws ParseFormatException, ContradictionException {
        this.solver.reset();
        try {
            this.skipComments(lineNumberReader);
            this.readProblemLine(lineNumberReader);
            this.readConstrs(lineNumberReader);
        }
        catch (IOException iOException) {
            throw new ParseFormatException(iOException);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseFormatException("integer value expected on line " + lineNumberReader.getLineNumber(), numberFormatException);
        }
    }

    public String decode(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(nArray[i]);
            stringBuffer.append(" ");
        }
        stringBuffer.append("0");
        return stringBuffer.toString();
    }

    protected ISolver getSolver() {
        return this.solver;
    }
}

