/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.zip.GZIPInputStream;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;

public class GoodOPBReader
implements Reader,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String COMMENT_SYMBOL = "*";
    private ISolver solver;
    private final Map<String, Integer> map = new HashMap<String, Integer>();
    private final IVec<String> decode = new Vec<String>();

    public GoodOPBReader(ISolver iSolver) {
        this.solver = iSolver;
    }

    public IProblem parseInstance(String string) throws FileNotFoundException, ParseFormatException, IOException, ContradictionException {
        if (string.endsWith(".gz")) {
            this.parseInstance(new LineNumberReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(string)))));
        } else {
            this.parseInstance(new LineNumberReader(new FileReader(string)));
        }
        return this.solver;
    }

    public void parseInstance(LineNumberReader lineNumberReader) throws ContradictionException, IOException {
        String string;
        this.solver.reset();
        while ((string = lineNumberReader.readLine()) != null) {
            if ((string = string.trim()).endsWith(";")) {
                string = string.substring(0, string.length() - 1);
            }
            this.parseLine(string);
        }
    }

    void parseLine(String string) throws ContradictionException {
        if (string.startsWith(COMMENT_SYMBOL)) {
            return;
        }
        if (string.startsWith("p")) {
            return;
        }
        if (string.startsWith("min:") || string.startsWith("min :")) {
            return;
        }
        if (string.startsWith("max:") || string.startsWith("max :")) {
            return;
        }
        int n = string.indexOf(":");
        if (n != -1) {
            string = string.substring(n + 1);
        }
        VecInt vecInt = new VecInt();
        Vec<BigInteger> vec = new Vec<BigInteger>();
        Scanner scanner = new Scanner(string).useDelimiter("\\s*\\*\\s*|\\s*\\+\\s*|\\s+");
        while (scanner.hasNext()) {
            Object object;
            String string2 = scanner.next();
            if (string2.equals(">=") || string2.equals("<=") || string2.equals("=")) {
                assert (scanner.hasNext());
                object = scanner.next();
                if (((String)object).startsWith("+")) {
                    object = ((String)object).substring(1);
                }
                BigInteger bigInteger = new BigInteger((String)object);
                try {
                    if (string2.equals(">=") || string2.equals("=")) {
                        this.solver.addPseudoBoolean(vecInt, vec, true, bigInteger);
                    }
                    if (!string2.equals("<=") && !string2.equals("=")) continue;
                    this.solver.addPseudoBoolean(vecInt, vec, false, bigInteger);
                    continue;
                }
                catch (ContradictionException contradictionException) {
                    System.out.println("c inconsistent constraint: " + string);
                    System.out.println("c lits: " + vecInt);
                    System.out.println("c coeffs: " + vec);
                    throw contradictionException;
                }
            }
            if (string2.equals("+")) {
                assert (scanner.hasNext());
                string2 = scanner.next();
            } else if (string2.equals("-")) {
                assert (scanner.hasNext());
                string2 = string2 + scanner.next();
            }
            try {
                if (string2.startsWith("+")) {
                    string2 = string2.substring(1);
                }
                object = new BigInteger(string2);
                assert (scanner.hasNext());
                string2 = scanner.next();
            }
            catch (NumberFormatException numberFormatException) {
                object = BigInteger.ONE;
            }
            if (string2.equals("-") || string2.equals("~")) {
                assert (scanner.hasNext());
                string2 = string2 + scanner.next();
            }
            boolean bl = false;
            if (string2.startsWith("+")) {
                string2 = string2.substring(1);
            } else if (string2.startsWith("-")) {
                string2 = string2.substring(1);
                assert (((BigInteger)object).equals(BigInteger.ONE));
                object = BigInteger.ONE.negate();
            } else if (string2.startsWith("~")) {
                string2 = string2.substring(1);
                bl = true;
            }
            Integer n2 = this.map.get(string2);
            if (n2 == null) {
                n2 = this.solver.newVar();
                this.map.put(string2, n2);
                this.decode.push(string2);
                assert (this.decode.size() == n2.intValue());
            }
            vec.push((BigInteger)object);
            int n3 = (bl ? -1 : 1) * n2;
            vecInt.push(n3);
            assert (vec.size() == vecInt.size());
        }
    }

    public String decode(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < 0) {
                stringBuffer.append("-");
                stringBuffer.append(this.decode.get(-nArray[i] - 1));
            } else {
                stringBuffer.append(this.decode.get(nArray[i] - 1));
            }
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }
}

