/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.sat4j.reader.CSPExtSupportReader;
import org.sat4j.reader.CSPReader;
import org.sat4j.reader.CSPSupportReader;
import org.sat4j.reader.ExtendedDimacsReader;
import org.sat4j.reader.GoodOPBReader;
import org.sat4j.reader.LecteurDimacs;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;

public class InstanceReader
implements Reader {
    private LecteurDimacs dimacs;
    private GoodOPBReader opb;
    private ExtendedDimacsReader edimacs;
    private CSPReader csp;
    private CSPReader csp2;
    private CSPReader csp3;
    private Reader reader = null;
    private final ISolver solver;

    public InstanceReader(ISolver iSolver) {
        this.solver = iSolver;
    }

    private Reader getDefaultSATReader() {
        if (this.dimacs == null) {
            this.dimacs = new LecteurDimacs(this.solver);
        }
        return this.dimacs;
    }

    private Reader getDefaultOPBReader() {
        if (this.opb == null) {
            this.opb = new GoodOPBReader(this.solver);
        }
        return this.opb;
    }

    private Reader getDefaultExtendedDimacsReader() {
        if (this.edimacs == null) {
            this.edimacs = new ExtendedDimacsReader(this.solver);
        }
        return this.edimacs;
    }

    private Reader getCSPReader1() {
        if (this.csp == null) {
            this.csp = new CSPReader(this.solver);
        }
        return this.csp;
    }

    private Reader getCSPReader2() {
        if (this.csp2 == null) {
            this.csp2 = new CSPSupportReader(this.solver);
        }
        return this.csp2;
    }

    private Reader getCSPReader3() {
        if (this.csp3 == null) {
            this.csp3 = new CSPExtSupportReader(this.solver);
        }
        return this.csp3;
    }

    public IProblem parseInstance(String string) throws FileNotFoundException, ParseFormatException, IOException, ContradictionException {
        String string2 = "";
        if (string.indexOf(58) != -1) {
            String[] stringArray = string.split(":");
            string = stringArray[1];
            string2 = stringArray[0].toUpperCase();
        }
        String string3 = string.endsWith(".gz") ? string.substring(0, string.lastIndexOf(46)) : string;
        this.reader = "CSP".equals(string2) ? this.getCSPReader1() : ("CSP3".equals(string2) ? this.getCSPReader3() : (string3.endsWith(".txt") || "CSP2".equals(string2) ? this.getCSPReader2() : (string3.endsWith(".opb") || "PB".equals(string2) ? this.getDefaultOPBReader() : (string3.endsWith(".edimacs") || string3.endsWith(".ncnf") || "EDIMACS".equals(string2) ? this.getDefaultExtendedDimacsReader() : this.getDefaultSATReader()))));
        return this.reader.parseInstance(string);
    }

    public String decode(int[] nArray) {
        return this.reader.decode(nArray);
    }
}

