/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.reader.ObjectiveFunction;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPBReader2005
implements Reader,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ISolver solver;
    private final IVec<String> decode = new Vec<String>();
    private final IVecInt lits;
    private final IVec<BigInteger> coeffs;
    private BigInteger d;
    private String operator;
    private final Map<String, Integer> map = new HashMap<String, Integer>();
    private final IVecInt objectiveVars = new VecInt();
    private final IVec<BigInteger> objectiveCoeffs = new Vec<BigInteger>();
    private boolean hasObjFunc = false;
    transient BufferedReader in;
    char savedChar;
    boolean charAvailable = false;
    boolean eofReached = false;

    protected void metaData(int n, int n2) {
        this.solver.newVar(n);
    }

    protected void beginObjective() {
    }

    protected void endObjective() {
        assert (this.lits.size() == this.coeffs.size());
        assert (this.lits.size() == this.coeffs.size());
        for (int i = 0; i < this.lits.size(); ++i) {
            this.objectiveVars.push(this.lits.get(i));
            this.objectiveCoeffs.push(this.coeffs.get(i));
        }
    }

    protected void beginConstraint() {
        this.lits.clear();
        this.coeffs.clear();
        assert (this.lits.size() == 0);
        assert (this.coeffs.size() == 0);
    }

    protected void endConstraint() throws ContradictionException {
        assert (this.lits.size() != 0);
        assert (this.coeffs.size() != 0);
        assert (this.lits.size() == this.coeffs.size());
        if (this.operator.equals("<=") || this.operator.equals("=")) {
            this.solver.addPseudoBoolean(this.lits, this.coeffs, false, this.d);
        }
        if (this.operator.equals(">=") || this.operator.equals("=")) {
            this.solver.addPseudoBoolean(this.lits, this.coeffs, true, this.d);
        }
    }

    protected void constraintTerm(BigInteger bigInteger, String string) {
        this.coeffs.push(bigInteger);
        Integer n = this.map.get(string);
        if (n == null) {
            assert (this.map.size() < this.solver.nVars());
            n = this.map.size() + 1;
            this.map.put(string, n);
            assert (n > 0);
            assert (n <= this.solver.nVars());
            this.decode.push(string);
            assert (this.decode.size() == n.intValue());
        }
        int n2 = (this.savedChar == '-' ? -1 : 1) * n;
        this.lits.push(n2);
    }

    protected void constraintRelOp(String string) {
        this.operator = string;
    }

    protected void constraintRightTerm(BigInteger bigInteger) {
        this.d = bigInteger;
    }

    private char get() throws IOException {
        if (this.charAvailable) {
            this.charAvailable = false;
            return this.savedChar;
        }
        int n = this.in.read();
        if (n == -1) {
            this.eofReached = true;
        }
        return (char)n;
    }

    public IVecInt getVars() {
        return this.objectiveVars;
    }

    public IVec<BigInteger> getCoeffs() {
        return this.objectiveCoeffs;
    }

    private void putback(char c) {
        this.savedChar = c;
        this.charAvailable = true;
    }

    private boolean eof() {
        return this.eofReached;
    }

    private void skipSpaces() throws IOException {
        char c;
        while (Character.isWhitespace(c = this.get())) {
        }
        this.putback(c);
    }

    public String readWord() throws IOException {
        char c;
        StringBuffer stringBuffer = new StringBuffer();
        this.skipSpaces();
        while (!Character.isWhitespace(c = this.get()) && !this.eof()) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public void readInteger(StringBuffer stringBuffer) throws IOException {
        this.skipSpaces();
        stringBuffer.setLength(0);
        char c = this.get();
        if (c == '-' || Character.isDigit(c)) {
            stringBuffer.append(c);
        }
        while (Character.isDigit(c = this.get()) && !this.eof()) {
            stringBuffer.append(c);
        }
        this.putback(c);
    }

    private boolean readIdentifier(StringBuffer stringBuffer) throws IOException {
        block3: {
            stringBuffer.setLength(0);
            this.skipSpaces();
            char c = this.get();
            if (this.eof()) {
                return false;
            }
            if (!Character.isLetter(c) && c != '_') {
                this.putback(c);
                return false;
            }
            stringBuffer.append(c);
            while (true) {
                c = this.get();
                if (this.eof()) break block3;
                if (!Character.isLetter(c) && !Character.isDigit(c) && c != '_') break;
                stringBuffer.append(c);
            }
            this.putback(c);
        }
        return true;
    }

    private String readRelOp() throws IOException {
        this.skipSpaces();
        char c = this.get();
        if (this.eof()) {
            return null;
        }
        if (c == '=') {
            return "=";
        }
        if (c == '>' && this.get() == '=') {
            return ">=";
        }
        return null;
    }

    private void readMetaData() throws IOException, ParseFormatException {
        char c = this.get();
        if (c != '*') {
            throw new ParseFormatException("First line of input file should be a comment");
        }
        String string = this.readWord();
        if (this.eof() || !string.equals("#variable=")) {
            throw new ParseFormatException("First line should contain #variable= as first keyword");
        }
        int n = Integer.parseInt(this.readWord());
        string = this.readWord();
        if (this.eof() || !string.equals("#constraint=")) {
            throw new ParseFormatException("First line should contain #constraint= as second keyword");
        }
        int n2 = Integer.parseInt(this.readWord());
        this.in.readLine();
        this.metaData(n, n2);
    }

    private void skipComments() throws IOException {
        char c = ' ';
        while (!this.eof() && (c = this.get()) == '*') {
            this.in.readLine();
        }
        this.putback(c);
    }

    private void readTerm(StringBuffer stringBuffer, StringBuffer stringBuffer2) throws IOException, ParseFormatException {
        this.readInteger(stringBuffer);
        this.skipSpaces();
        char c = this.get();
        if (c != '*') {
            throw new ParseFormatException("'*' expected between a coefficient and a variable");
        }
        if (!this.readIdentifier(stringBuffer2)) {
            throw new ParseFormatException("identifier expected");
        }
    }

    private void readObjective() throws IOException, ParseFormatException {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        this.skipSpaces();
        char c = this.get();
        if (c != 'm') {
            this.putback(c);
            return;
        }
        this.hasObjFunc = true;
        if (this.get() == 'i' && this.get() == 'n' && this.get() == ':') {
            this.beginObjective();
            while (!this.eof()) {
                this.readTerm(stringBuffer2, stringBuffer);
                this.constraintTerm(new BigInteger(stringBuffer2.toString()), stringBuffer.toString());
                this.skipSpaces();
                c = this.get();
                if (c == ';') break;
                if (c == '-' || c == '+' || Character.isDigit(c)) {
                    this.putback(c);
                    continue;
                }
                throw new ParseFormatException("unexpected character in objective function");
            }
        } else {
            throw new ParseFormatException("input format error: 'min:' expected");
        }
        this.endObjective();
    }

    private void readConstraint() throws IOException, ParseFormatException, ContradictionException {
        char c;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        this.beginConstraint();
        while (!this.eof()) {
            this.readTerm(stringBuffer2, stringBuffer);
            this.constraintTerm(new BigInteger(stringBuffer2.toString()), stringBuffer.toString());
            this.skipSpaces();
            c = this.get();
            if (c == '>' || c == '=') {
                this.putback(c);
                break;
            }
            if (c == '-' || c == '+' || Character.isDigit(c)) {
                this.putback(c);
                continue;
            }
            throw new ParseFormatException("unexpected character in constraint");
        }
        if (this.eof()) {
            throw new ParseFormatException("unexpected EOF before end of constraint");
        }
        String string = this.readRelOp();
        if (string == null) {
            throw new ParseFormatException("unexpected relational operator in constraint");
        }
        this.constraintRelOp(string);
        this.readInteger(stringBuffer2);
        this.constraintRightTerm(new BigInteger(stringBuffer2.toString()));
        this.skipSpaces();
        c = this.get();
        if (this.eof() || c != ';') {
            throw new ParseFormatException("semicolon expected at end of constraint");
        }
        this.endConstraint();
    }

    public OPBReader2005(ISolver iSolver) {
        this.solver = iSolver;
        this.lits = new VecInt();
        this.coeffs = new Vec<BigInteger>();
    }

    public void parse() throws IOException, ParseFormatException, ContradictionException {
        this.readMetaData();
        this.skipComments();
        this.readObjective();
        while (!this.eof()) {
            this.skipSpaces();
            if (this.eof()) break;
            this.readConstraint();
        }
    }

    @Override
    public IProblem parseInstance(String string) throws FileNotFoundException, ParseFormatException, IOException, ContradictionException {
        if (string.endsWith(".gz")) {
            this.parseInstance(new LineNumberReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(string)))));
        } else {
            this.parseInstance(new LineNumberReader(new FileReader(string)));
        }
        return this.solver;
    }

    public void parseInstance(LineNumberReader lineNumberReader) throws ParseFormatException, ContradictionException {
        this.solver.reset();
        this.in = lineNumberReader;
        try {
            this.parse();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public String decode(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < 0) {
                stringBuffer.append("-");
                stringBuffer.append(this.decode.get(-nArray[i] - 1));
            } else {
                stringBuffer.append(this.decode.get(nArray[i] - 1));
            }
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public ObjectiveFunction getObjectiveFunction() {
        if (this.hasObjFunc) {
            return new ObjectiveFunction(this.getVars(), this.getCoeffs());
        }
        return null;
    }
}

