/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectiveFunction {
    private final IVec<BigInteger> coeffs;
    private final IVecInt vars;

    public ObjectiveFunction(IVecInt iVecInt, IVec<BigInteger> iVec) {
        this.vars = new VecInt(iVecInt.size());
        iVecInt.copyTo(this.vars);
        this.coeffs = new Vec<BigInteger>(iVec.size());
        iVec.copyTo(this.coeffs);
    }

    public BigInteger calculateDegree(int[] nArray) {
        BigInteger bigInteger = BigInteger.ZERO;
        for (int i = 0; i < this.vars.size(); ++i) {
            if (!this.varInModel(this.vars.get(i), nArray)) continue;
            bigInteger = bigInteger.add(this.coeffs.get(i));
        }
        return bigInteger;
    }

    private boolean varInModel(int n, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            return true;
        }
        return false;
    }

    public IVec<BigInteger> getCoeffs() {
        Vec<BigInteger> vec = new Vec<BigInteger>(this.coeffs.size());
        this.coeffs.copyTo(vec);
        return vec;
    }

    public IVecInt getVars() {
        VecInt vecInt = new VecInt(this.vars.size());
        this.vars.copyTo(vecInt);
        return vecInt;
    }
}

