/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader.csp;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.sat4j.core.VecInt;
import org.sat4j.reader.csp.SupportsDirectEncoding;
import org.sat4j.reader.csp.Var;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinarySupportsACEncoding
extends SupportsDirectEncoding {
    public BinarySupportsACEncoding(int[] nArray, int n) {
        super(nArray, n);
        if (nArray.length != 2) {
            throw new UnsupportedOperationException("Works only for binary constraints");
        }
    }

    @Override
    public void toClause(ISolver iSolver, Var[] varArray) throws ContradictionException {
        HashMap<Integer, IVecInt> hashMap = new HashMap<Integer, IVecInt>();
        HashMap<Integer, IVecInt> hashMap2 = new HashMap<Integer, IVecInt>();
        for (int i = 0; i < this.tuples.length; ++i) {
            assert (this.domains.length == 2);
            int n = this.tuples[i][0];
            int n2 = this.tuples[i][1];
            this.addSupport(n, varArray[1], n2, hashMap);
            this.addSupport(n2, varArray[0], n, hashMap2);
        }
        this.generateClauses(varArray[0], hashMap, iSolver);
        this.generateClauses(varArray[1], hashMap2, iSolver);
    }

    private void addSupport(int n, Var var, int n2, Map<Integer, IVecInt> map) {
        IVecInt iVecInt = map.get(n);
        if (iVecInt == null) {
            iVecInt = new VecInt();
            map.put(n, iVecInt);
        }
        iVecInt.push(var.translate(n2));
    }

    private void generateClauses(Var var, Map<Integer, IVecInt> map, ISolver iSolver) throws ContradictionException {
        VecInt vecInt = new VecInt();
        for (int n : var.domain()) {
            vecInt.clear();
            IVecInt iVecInt = map.get(n);
            vecInt.push(-var.translate(n));
            if (iVecInt != null) {
                Iterator iterator = iVecInt.iterator();
                while (iterator.hasNext()) {
                    int n2 = (Integer)iterator.next();
                    vecInt.push(n2);
                }
            }
            iSolver.addClause(vecInt);
        }
    }
}

