/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader.csp;

import org.sat4j.core.VecInt;
import org.sat4j.reader.csp.Relation;
import org.sat4j.reader.csp.Var;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;

public class SupportsDirectEncoding
implements Relation {
    protected final int[] domains;
    protected int[][] tuples;
    private IVecInt clause;
    private int lastmatch;

    public SupportsDirectEncoding(int[] nArray, int n) {
        this.domains = nArray;
        this.tuples = new int[n][];
    }

    public void addTuple(int n, int[] nArray) {
        this.tuples[n] = nArray;
    }

    public void toClause(ISolver iSolver, Var[] varArray) throws ContradictionException {
        this.clause = new VecInt();
        int[] nArray = new int[varArray.length];
        this.lastmatch = -1;
        this.find(nArray, 0, varArray, iSolver);
    }

    private void find(int[] nArray, int n, Var[] varArray, ISolver iSolver) throws ContradictionException {
        if (n == varArray.length) {
            if (this.notPresent(nArray)) {
                this.clause.clear();
                for (int i = 0; i < varArray.length; ++i) {
                    this.clause.push(-varArray[i].translate(nArray[i]));
                }
                iSolver.addClause(this.clause);
            }
        } else {
            int[] nArray2 = varArray[n].domain();
            for (int i = 0; i < nArray2.length; ++i) {
                nArray[n] = nArray2[i];
                this.find(nArray, n + 1, varArray, iSolver);
            }
        }
    }

    private boolean notPresent(int[] nArray) {
        int n = this.lastmatch + 1;
        int n2 = 0;
        while (n < this.tuples.length && n2 < nArray.length) {
            if (this.tuples[n][n2] < nArray[n2]) {
                ++n;
                n2 = 0;
                continue;
            }
            if (this.tuples[n][n2] > nArray[n2]) {
                return true;
            }
            ++n2;
        }
        if (n2 == nArray.length) {
            this.lastmatch = n;
            return false;
        }
        return true;
    }

    public int arity() {
        return this.domains.length;
    }
}

