/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader.csp;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.sat4j.core.VecInt;
import org.sat4j.reader.csp.SupportsDirectEncoding;
import org.sat4j.reader.csp.Var;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SupportsGeneralizedACEncoding
extends SupportsDirectEncoding {
    public SupportsGeneralizedACEncoding(int[] nArray, int n) {
        super(nArray, n);
    }

    @Override
    public void toClause(ISolver iSolver, Var[] varArray) throws ContradictionException {
        int n;
        HashMap<Set<Integer>, IVecInt> hashMap = new HashMap<Set<Integer>, IVecInt>();
        int[] nArray = new int[varArray.length];
        this.fill(0, varArray, nArray, hashMap);
        for (int[] object2 : this.tuples) {
            for (n = 0; n < object2.length; ++n) {
                HashSet<Integer> hashSet = new HashSet<Integer>();
                for (int i = 0; i < object2.length; ++i) {
                    if (n == i) continue;
                    hashSet.add(varArray[i].translate(object2[i]));
                }
                IVecInt iVecInt = (IVecInt)hashMap.get(hashSet);
                assert (iVecInt != null);
                iVecInt.push(varArray[n].translate(object2[n]));
            }
        }
        Object object = new VecInt();
        for (Map.Entry entry : hashMap.entrySet()) {
            object.clear();
            Iterator iterator = ((Set)entry.getKey()).iterator();
            while (iterator.hasNext()) {
                n = (Integer)iterator.next();
                object.push(-n);
            }
            Iterator iterator2 = ((IVecInt)entry.getValue()).iterator();
            while (iterator2.hasNext()) {
                n = (Integer)iterator2.next();
                object.push(n);
            }
            iSolver.addClause((IVecInt)object);
        }
    }

    private void fill(int n, Var[] varArray, int[] nArray, Map<Set<Integer>, IVecInt> map) {
        if (varArray.length == n) {
            for (int i = 0; i < nArray.length; ++i) {
                HashSet<Integer> hashSet = new HashSet<Integer>();
                for (int j = 0; j < nArray.length; ++j) {
                    if (j == i) continue;
                    hashSet.add(varArray[j].translate(nArray[j]));
                }
                map.put(hashSet, new VecInt());
            }
        } else {
            int[] nArray2 = varArray[n].domain();
            int n2 = nArray2.length;
            for (int i = 0; i < n2; ++i) {
                int n3;
                nArray[n] = n3 = nArray2[i];
                this.fill(n + 1, varArray, nArray, map);
            }
        }
    }
}

