/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader.csp;

import java.util.HashMap;
import java.util.Map;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;

public class Var {
    Map<Integer, Integer> mapping = new HashMap<Integer, Integer>();
    private final int[] domain;

    public Var(int[] nArray, int n) {
        this.domain = nArray;
        for (int i = 0; i < nArray.length; ++i) {
            this.mapping.put(nArray[i], ++n);
        }
    }

    public int[] domain() {
        return this.domain;
    }

    public int translate(int n) {
        return this.mapping.get(n);
    }

    public void toClause(ISolver iSolver) throws ContradictionException {
        VecInt vecInt = new VecInt();
        for (int n : this.mapping.values()) {
            vecInt.push(n);
        }
        iSolver.addClause(vecInt);
        iSolver.addAtMost(vecInt, 1);
    }

    public int findValue(int[] nArray) {
        for (Map.Entry<Integer, Integer> entry : this.mapping.entrySet()) {
            if (nArray[entry.getValue() - 1] != entry.getValue()) continue;
            return entry.getKey();
        }
        throw new RuntimeException("BIG PROBLEM: no value for a var!");
    }
}

