/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import java.io.Serializable;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.SolverDecorator;

public class ModelIterator
extends SolverDecorator
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean trivialfalsity = false;

    public ModelIterator(ISolver iSolver) {
        super(iSolver);
    }

    public int[] model() {
        int[] nArray = super.model();
        VecInt vecInt = new VecInt(nArray.length);
        for (int n : nArray) {
            vecInt.push(-n);
        }
        try {
            this.addClause(vecInt);
        }
        catch (ContradictionException contradictionException) {
            this.trivialfalsity = true;
        }
        return nArray;
    }

    public boolean isSatisfiable() throws TimeoutException {
        if (this.trivialfalsity) {
            return false;
        }
        this.trivialfalsity = false;
        return super.isSatisfiable();
    }

    public boolean isSatisfiable(IVecInt iVecInt) throws TimeoutException {
        if (this.trivialfalsity) {
            return false;
        }
        this.trivialfalsity = false;
        return super.isSatisfiable(iVecInt);
    }

    public void reset() {
        this.trivialfalsity = false;
        super.reset();
    }
}

