/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.ubcsat.core;

import java.io.PrintStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.ubcsat.Random;
import org.sat4j.ubcsat.algorithms.IAlgorithm;
import org.sat4j.ubcsat.info.Info;
import org.sat4j.ubcsat.lit.Lits;
import org.sat4j.ubcsat.structure.Constraint;
import org.sat4j.ubcsat.triggers.BestFalse;
import org.sat4j.ubcsat.triggers.BestScoreList;
import org.sat4j.ubcsat.triggers.DefaultStateInfo;
import org.sat4j.ubcsat.triggers.ITrigger;
import org.sat4j.ubcsat.triggers.TrackChanges;
import org.sat4j.ubcsat.triggers.TriggerAdapter;
import org.sat4j.ubcsat.triggers.VarScore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Solver
implements ISolver {
    private Info info;
    private IAlgorithm algorithm;
    private Constraint constr = new Constraint();
    private int numberOfVars;
    private boolean undertimeout;
    private int timeout = Integer.MAX_VALUE;
    private int[] model = null;
    private int iNumRuns = 1;
    private long iCutoff = 100000L;
    private long iPeriodicRestart = 0L;
    private int iTarget = 0;
    private ITrigger defaultStateInfo;
    private ITrigger bestFalse;
    private VarScore varScore;
    private ITrigger trackChanges;
    private ITrigger bestScoreList;
    private float iProbRestart = 0.0f;
    private int iStagnateRestart = 0;

    public Solver(Info info, IAlgorithm iAlgorithm) {
        this.info = info;
        this.algorithm = iAlgorithm;
    }

    @Override
    public int newVar() {
        return 0;
    }

    @Override
    public int newVar(int n) {
        this.numberOfVars = n;
        return this.numberOfVars;
    }

    @Override
    public IConstr addClause(IVecInt iVecInt) throws ContradictionException {
        this.constr.addClause(iVecInt);
        return null;
    }

    @Override
    public boolean removeConstr(IConstr iConstr) {
        return false;
    }

    @Override
    public void addAllClauses(IVec<IVecInt> iVec) throws ContradictionException {
    }

    @Override
    public IConstr addAtMost(IVecInt iVecInt, int n) throws ContradictionException {
        return null;
    }

    @Override
    public IConstr addAtLeast(IVecInt iVecInt, int n) throws ContradictionException {
        return null;
    }

    @Override
    public void setTimeout(int n) {
        this.timeout = n;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public void reset() {
    }

    public void backUp() {
    }

    public void restore() {
    }

    @Override
    public void printStat(PrintStream printStream, String string) {
    }

    @Override
    public String toString(String string) {
        return this.info.toString();
    }

    @Override
    public int[] model() {
        if (this.model == null) {
            throw new UnsupportedOperationException("Call the solve method first!!!");
        }
        int[] nArray = new int[this.model.length];
        System.arraycopy(this.model, 0, nArray, 0, this.model.length);
        return nArray;
    }

    public void setNumRuns(int n) {
        this.iNumRuns = n;
    }

    public void setCutoff(long l) {
        this.iCutoff = l;
    }

    public void setPeriodicRestart(long l) {
        this.iPeriodicRestart = l;
    }

    public void setTarget(int n) {
        this.iTarget = n;
    }

    @Override
    public boolean isSatisfiable() throws TimeoutException {
        System.out.println("c Cutoff : " + this.iCutoff);
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        int n3 = this.nConstraints();
        int n4 = this.nVars();
        long l = this.nLits();
        boolean bl2 = false;
        this.model = new int[this.nVars()];
        this.defaultStateInfo = new DefaultStateInfo(n3, n4, l, this.constr);
        this.bestFalse = new BestFalse(n3, n4, l, this.constr);
        this.varScore = new VarScore(n3, n4, l, this.constr);
        this.trackChanges = new TrackChanges(n3, n4, l, this.constr);
        this.bestScoreList = new BestScoreList(n3, n4, l, this.constr);
        ArrayList<ITrigger> arrayList = new ArrayList<ITrigger>();
        arrayList.add(this.defaultStateInfo);
        arrayList.add(this.bestFalse);
        arrayList.add(this.varScore);
        arrayList.add(this.trackChanges);
        arrayList.add(this.bestScoreList);
        for (ITrigger object2 : arrayList) {
            object2.create();
        }
        TimerTask timerTask = new TimerTask(){

            public void run() {
                Solver.this.undertimeout = false;
            }
        };
        this.undertimeout = true;
        Timer timer = new Timer(true);
        timer.schedule(timerTask, (long)this.timeout * 1000L);
        while (n2 < this.iNumRuns && !bl && this.undertimeout) {
            ++n2;
            int n5 = 0;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = true;
            for (ITrigger iTrigger : arrayList) {
                iTrigger.init(n5);
            }
            while ((long)n5 < this.iCutoff && !bl3 && !bl4) {
                ++n5;
                if (bl5) {
                    this.defaultStateInfo.defaultInitVars();
                    this.algorithm.init(n4);
                    for (ITrigger iTrigger : arrayList) {
                        iTrigger.init(n5);
                    }
                    bl5 = false;
                } else {
                    this.algorithm.selectVariableToFlip(n3, n4, this.varScore);
                    this.varScore.flip();
                    this.bestFalse.update(n2, n5);
                }
                bl3 = this.checkTermination(bl3, this.iTarget);
            }
            if (!bl3) continue;
            bl2 = true;
            if (++n != 0) continue;
            bl = true;
        }
        timer.cancel();
        if (!this.undertimeout || !bl2) {
            throw new TimeoutException(" Timeout (" + this.timeout + "s) exceeded");
        }
        return bl2;
    }

    private void setModel() {
        for (int i = 0; i < this.nVars(); ++i) {
            if (Lits.aVarValue[i] == 0) {
                this.model[i] = -i;
            }
            this.model[i] = i;
        }
    }

    @Override
    public boolean isSatisfiable(IVecInt iVecInt) throws TimeoutException {
        return false;
    }

    private boolean checkTermination(boolean bl, int n) {
        if (TriggerAdapter.iNumFalse <= n) {
            bl = true;
        }
        return bl;
    }

    private boolean checkForRestarts(int n, boolean bl, BestFalse bestFalse, int n2) {
        if (n2 > 0 && n % n2 == 0) {
            bl = true;
        }
        if (this.iProbRestart > 0.0f && Random.randomProb(this.iProbRestart)) {
            bl = true;
        }
        if (this.iStagnateRestart > 0 && n > bestFalse.getIBestStepNumFalse() + this.iStagnateRestart) {
            bl = true;
            bestFalse.init(n);
        }
        return bl;
    }

    public long nLits() {
        long l = 0L;
        for (long i = 0L; i < (long)this.constr.size(); ++i) {
            l += (long)this.constr.getConstrSize((int)i);
        }
        return l;
    }

    @Override
    public int nConstraints() {
        return this.constr.size();
    }

    @Override
    public int nVars() {
        return this.numberOfVars;
    }

    @Override
    public IConstr addPseudoBoolean(IVecInt iVecInt, IVec<BigInteger> iVec, boolean bl, BigInteger bigInteger) throws ContradictionException {
        return null;
    }
}

