/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.ubcsat.structure;

import org.sat4j.core.VecInt;
import org.sat4j.specs.IVecInt;
import org.sat4j.ubcsat.lit.Lits;

public class Constraint {
    private static final int INITIAL_CAPACITY_OF_VEC = 10;
    private VecInt[] constr = new VecInt[10];
    private VecInt[] litClause = new VecInt[10];
    private int[] numLitOcc = new int[10];
    private int[] numTrueLit;
    private int sizeVec = 0;
    private int sizeLitClause = 10;
    private int sizeNumLitOcc = 10;

    public Constraint() {
        for (int i = 0; i < 10; ++i) {
            this.numLitOcc[i] = 0;
            this.constr[i] = new VecInt();
            this.litClause[i] = new VecInt();
        }
    }

    private void growVec(int n) {
        if (n > 10) {
            VecInt[] vecIntArray = new VecInt[n];
            System.arraycopy(this.constr, 0, vecIntArray, 0, this.sizeVec);
            this.constr = vecIntArray;
            this.constr[this.sizeVec] = new VecInt();
        }
    }

    private void createLitClause(IVecInt iVecInt) {
        for (int i = 0; i < iVecInt.size(); ++i) {
            this.growLitClause(iVecInt.get(i));
            this.growNumLitOcc(iVecInt.get(i));
            int n = iVecInt.get(i);
            this.numLitOcc[n] = this.numLitOcc[n] + 1;
            assert (this.litClause[iVecInt.get(i)] != null);
            this.litClause[iVecInt.get(i)].push(this.sizeVec);
        }
    }

    private void growLitClause(int n) {
        if (n >= this.sizeLitClause) {
            VecInt[] vecIntArray = new VecInt[n + 1];
            System.arraycopy(this.litClause, 0, vecIntArray, 0, this.sizeLitClause);
            this.litClause = vecIntArray;
            for (int i = this.sizeLitClause; i <= n; ++i) {
                this.litClause[i] = new VecInt();
            }
            this.sizeLitClause = n + 1;
        }
    }

    private void growNumLitOcc(int n) {
        if (n >= this.sizeNumLitOcc) {
            int[] nArray = new int[n + 1];
            System.arraycopy(this.numLitOcc, 0, nArray, 0, this.sizeNumLitOcc);
            this.numLitOcc = nArray;
            for (int i = this.sizeNumLitOcc; i <= n; ++i) {
                this.numLitOcc[i] = 0;
            }
            this.sizeNumLitOcc = n + 1;
        }
    }

    public void addClause(IVecInt iVecInt) {
        this.growVec(this.sizeVec + 1);
        IVecInt iVecInt2 = this.convertLiterals(iVecInt);
        iVecInt2.sort();
        this.createLitClause(iVecInt2);
        this.constr[this.sizeVec++].pushAll(iVecInt2);
    }

    private IVecInt convertLiterals(IVecInt iVecInt) {
        VecInt vecInt = new VecInt();
        for (int i = 0; i < iVecInt.size(); ++i) {
            vecInt.push(Lits.getLit(iVecInt.get(i)));
        }
        return vecInt;
    }

    public int getConstrSize(int n) {
        return this.constr[n].size();
    }

    public int getLit(int n, int n2) {
        return this.constr[n].get(n2);
    }

    public void createNumTrueLit(int n) {
        this.numTrueLit = new int[n];
    }

    public int getNumTrueLit(int n) {
        return this.numTrueLit[n];
    }

    public void setNumTrueLit(int n, int n2) {
        this.numTrueLit[n] = n2;
    }

    public void incNumTrueLit(int n) {
        int n2 = n;
        this.numTrueLit[n2] = this.numTrueLit[n2] + 1;
    }

    public void decNumTrueLit(int n) {
        int n2 = n;
        this.numTrueLit[n2] = this.numTrueLit[n2] - 1;
    }

    public IVecInt getOneConstr(int n) {
        return this.constr[n];
    }

    public IVecInt getLitClause(int n) {
        return this.litClause[n];
    }

    public int getNumLitOcc(int n) {
        return this.numLitOcc[n];
    }

    public int size() {
        return this.sizeVec;
    }
}

