/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.ubcsat.triggers;

import org.sat4j.specs.IVecInt;
import org.sat4j.ubcsat.Random;
import org.sat4j.ubcsat.lit.Lits;
import org.sat4j.ubcsat.structure.Constraint;
import org.sat4j.ubcsat.triggers.ITrigger;

public abstract class TriggerAdapter
implements ITrigger {
    private final int nClauses;
    private final int nVars;
    private final long nLits;
    protected Constraint c;
    public static int iNumFalse;
    public long iFlipCandidate;
    protected long[] aCritSat;
    protected int iBestNumFalse;
    protected int iNumLogDistValues;
    protected long[] aLogDistValues;
    protected long[] aChangeList;
    protected long[] aChangeOldScore;
    protected int iNumChanges;
    protected int[] aVarInit;
    private int iInitVarFlip = 0;
    private boolean bVarInitGreedy = false;

    public TriggerAdapter(int n, int n2, long l, Constraint constraint) {
        this.nClauses = n;
        this.nVars = n2;
        this.nLits = l;
        this.c = constraint;
    }

    public abstract void init();

    public abstract void init(int var1);

    public abstract void create();

    public abstract void update();

    public abstract void flip();

    public abstract void flip(int var1);

    public abstract void update(int var1, int var2);

    public abstract void finish(int var1);

    public int getNClauses() {
        return this.nClauses;
    }

    public long getNLits() {
        return this.nLits;
    }

    public int getNVars() {
        return this.nVars;
    }

    public void defaultInitVars() {
        boolean bl = false;
        for (int i = 1; i <= this.nVars; ++i) {
            Lits.aVarValue[i] = this.aVarInit[i] == 2 ? (int)Random.randomInt(2) : this.aVarInit[i];
        }
    }

    public void createLogDist(int n) {
        int n2 = 10;
        int n3 = (int)(Math.log10(n) * (double)n2 + 2.0);
        this.aLogDistValues = new long[n3];
        double d = Math.pow(10.0, 1.0f / (float)n2);
        this.iNumLogDistValues = 0;
        for (double d2 = 10.0; d2 <= (double)n; d2 *= d) {
            this.aLogDistValues[this.iNumLogDistValues++] = (int)d2;
        }
        if (this.aLogDistValues[this.iNumLogDistValues - 1] != (long)n) {
            this.aLogDistValues[this.iNumLogDistValues++] = n;
        }
    }

    public void defaultFlip() {
        if (this.iFlipCandidate == 0L) {
            return;
        }
        long l = Lits.getTrueLit(this.iFlipCandidate);
        long l2 = Lits.getFalseLit(this.iFlipCandidate);
        Lits.aVarValue[(int)this.iFlipCandidate] = 1 - Lits.aVarValue[(int)this.iFlipCandidate];
        IVecInt iVecInt = this.c.getLitClause((int)l);
        for (int i = 0; i < this.c.getNumLitOcc((int)l); ++i) {
            this.c.decNumTrueLit(iVecInt.get(i));
            if (this.c.getNumTrueLit(iVecInt.get(i)) != 0) continue;
            ++iNumFalse;
        }
        IVecInt iVecInt2 = this.c.getLitClause((int)l2);
        for (int i = 0; i < this.c.getNumLitOcc((int)l2); ++i) {
            this.c.incNumTrueLit(iVecInt2.get(i));
            if (this.c.getNumTrueLit(iVecInt2.get(i)) != 1) continue;
            --iNumFalse;
        }
    }

    public int getINumFalse() {
        return iNumFalse;
    }

    public void setINumFalse(int n) {
        iNumFalse = n;
    }
}

