/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.apps.sudoku;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.sat4j.apps.sudoku.CellStatus;
import org.sat4j.apps.sudoku.GUIInput;
import org.sat4j.apps.sudoku.GraphicalOneCell;
import org.sat4j.apps.sudoku.OneCell;
import org.sat4j.apps.sudoku.SDSize;
import org.sat4j.apps.sudoku.SuDokuResources;
import org.sat4j.apps.sudoku.TextualOneCell;

class CellGrid
extends JPanel
implements Printable {
    OneCell[][] cells;
    private static boolean graphical = true;
    SDSize sdSize;
    GUIInput guiInput;

    CellGrid(SDSize sDSize, GUIInput gUIInput) {
        this.sdSize = sDSize;
        this.guiInput = gUIInput;
        if (graphical) {
            this.setBackground(Color.BLACK);
        } else {
            this.setBackground(null);
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(0), "SuDoku Puzzle"));
        }
        this.setLayout(new BoxLayout(this, 0));
        this.setMaximumSize(new Dimension(1000, 1000));
        this.add(Box.createRigidArea(new Dimension(1, 400)));
        Box box = Box.createVerticalBox();
        box.add(Box.createRigidArea(new Dimension(400, 1)));
        this.cells = new OneCell[sDSize.getLargeSide()][sDSize.getLargeSide()];
        for (int i = 0; i < sDSize.getLargeSide(); ++i) {
            if (i > 0 && i % sDSize.getSmallRows() == 0) {
                box.add(Box.createRigidArea(new Dimension(22 * sDSize.getLargeSide(), 3)));
            }
            Box box2 = Box.createHorizontalBox();
            for (int j = 0; j < sDSize.getLargeSide(); ++j) {
                if (j > 0 && j % sDSize.getSmallCols() == 0) {
                    box2.add(Box.createRigidArea(new Dimension(3, 22)));
                }
                this.cells[i][j] = this.createCell(sDSize, gUIInput, i, box2, j);
            }
            box.add(box2);
        }
        this.add(Box.createVerticalGlue());
        box.setMinimumSize(new Dimension(22 * sDSize.getLargeSide(), 22 * sDSize.getLargeSide()));
        this.add(box);
        this.add(Box.createVerticalGlue());
        if (gUIInput.getUseXSudoku()) {
            this.enableXGrid(gUIInput.getDiagonalColors());
        }
    }

    private OneCell createCell(SDSize sDSize, GUIInput gUIInput, int n, Box box, int n2) {
        if (graphical) {
            GraphicalOneCell graphicalOneCell = new GraphicalOneCell(sDSize.getLargeSide(), gUIInput, this.cellColors(n, n2));
            graphicalOneCell.addMouseListener(new CellClicked(n, n2));
            box.add(graphicalOneCell);
            return graphicalOneCell;
        }
        TextualOneCell textualOneCell = new TextualOneCell(sDSize.getLargeSide(), gUIInput, this.cellColors(n, n2));
        textualOneCell.addMouseListener(new CellClicked(n, n2));
        box.add(textualOneCell);
        return textualOneCell;
    }

    Color[] cellColors(int n, int n2) {
        int n3;
        int n4 = n / this.sdSize.getSmallRows();
        return n4 % 2 == (n3 = n2 / this.sdSize.getSmallCols()) % 2 ? this.guiInput.getBlueColors() : this.guiInput.getWhiteColors();
    }

    public static void setGraphical(boolean bl) {
        graphical = bl;
    }

    public OneCell getCell(int n, int n2) {
        return this.cells[n - 1][n2 - 1];
    }

    public int getIntValue(int n, int n2) {
        return this.cells[n - 1][n2 - 1].getIntValue();
    }

    public CellStatus getStatus(int n, int n2) {
        return this.cells[n - 1][n2 - 1].getStatus();
    }

    public void setIntValue(int n, int n2, int n3) {
        if (1 <= n && n <= this.sdSize.getLargeSide() && 1 <= n2 && n2 <= this.sdSize.getLargeSide()) {
            this.cells[n - 1][n2 - 1].setIntValue(n3);
        }
    }

    public void solverSetIntValue(int n, int n2, int n3) {
        if (1 <= n && n <= this.sdSize.getLargeSide() && 1 <= n2 && n2 <= this.sdSize.getLargeSide()) {
            this.cells[n - 1][n2 - 1].solverSetIntValue(n3);
        }
    }

    public void clear() {
        for (int i = 0; i < this.sdSize.getLargeSide(); ++i) {
            for (int j = 0; j < this.sdSize.getLargeSide(); ++j) {
                this.cells[i][j].clear();
            }
        }
    }

    public void refreshCells() {
        for (int i = 0; i < this.sdSize.getLargeSide(); ++i) {
            for (int j = 0; j < this.sdSize.getLargeSide(); ++j) {
                this.cells[i][j].refresh();
            }
        }
    }

    public void clearComputers() {
        for (int i = 0; i < this.sdSize.getLargeSide(); ++i) {
            for (int j = 0; j < this.sdSize.getLargeSide(); ++j) {
                this.cells[i][j].clearComputers();
            }
        }
    }

    public void protect() {
        for (int i = 0; i < this.sdSize.getLargeSide(); ++i) {
            for (int j = 0; j < this.sdSize.getLargeSide(); ++j) {
                this.cells[i][j].protectIfNotClear();
            }
        }
    }

    public void clearProtection() {
        for (int i = 0; i < this.sdSize.getLargeSide(); ++i) {
            for (int j = 0; j < this.sdSize.getLargeSide(); ++j) {
                this.cells[i][j].clearProtection();
            }
        }
    }

    public void clearAll() {
        for (int i = 0; i < this.sdSize.getLargeSide(); ++i) {
            for (int j = 0; j < this.sdSize.getLargeSide(); ++j) {
                this.cells[i][j].clearProtection();
                this.cells[i][j].clear();
            }
        }
    }

    public void unHighlightAll() {
        for (int i = 0; i < this.sdSize.getLargeSide(); ++i) {
            for (int j = 0; j < this.sdSize.getLargeSide(); ++j) {
                this.cells[i][j].unHighlight();
            }
        }
    }

    public void highlight(int n, int n2) {
        this.cells[n - 1][n2 - 1].highlight();
    }

    public String exportString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        for (int i = 0; i < this.sdSize.getLargeSide(); ++i) {
            for (int j = 0; j < this.sdSize.getLargeSide(); ++j) {
                int n = this.cells[i][j].getIntValue();
                if (j != 0) {
                    stringBuffer.append(" ");
                }
                if (n < 10) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(n);
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public void importString(String string) {
        ImportParser importParser = new ImportParser(string);
        for (int i = 0; i < this.sdSize.getLargeSide(); ++i) {
            for (int j = 0; j < this.sdSize.getLargeSide(); ++j) {
                int n = importParser.nextValue();
                if (n == 0) continue;
                this.cells[i][j].setIntValue(n);
            }
        }
    }

    int scaleWidthToHeight(int n, ImageIcon imageIcon) {
        return n * imageIcon.getIconHeight() / imageIcon.getIconWidth();
    }

    void drawCell(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5) {
        graphics2D.drawLine(n + n5 * n3, n2 + n4 * n3, n + (n5 + 1) * n3, n2 + n4 * n3);
        graphics2D.drawLine(n + (n5 + 1) * n3, n2 + n4 * n3, n + (n5 + 1) * n3, n2 + (n4 + 1) * n3);
        graphics2D.drawLine(n + (n5 + 1) * n3, n2 + (n4 + 1) * n3, n + n5 * n3, n2 + (n4 + 1) * n3);
        graphics2D.drawLine(n + n5 * n3, n2 + (n4 + 1) * n3, n + n5 * n3, n2 + n4 * n3);
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n == 0) {
            String[] stringArray;
            CharSequence charSequence;
            int n2;
            int n3;
            int n4 = 60;
            int n5 = (int)pageFormat.getImageableX() + 5;
            int n6 = (int)pageFormat.getImageableY() + 5;
            int n7 = (int)pageFormat.getImageableWidth() - 10;
            double d = 0.5;
            if (n7 > (int)pageFormat.getImageableHeight() - 10) {
                n7 = (int)pageFormat.getImageableHeight() - 10;
            }
            if (d * (double)n4 * (double)this.sdSize.getLargeSide() > (double)n7) {
                n4 = (int)((double)n7 / (d * (double)this.sdSize.getLargeSide()));
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.scale(d, d);
            n5 = (int)((double)n5 / d);
            n6 = (int)((double)n6 / d);
            graphics2D.setColor(Color.BLACK);
            BasicStroke basicStroke = new BasicStroke();
            BasicStroke basicStroke2 = new BasicStroke(3.0f);
            BasicStroke basicStroke3 = new BasicStroke(5.0f);
            for (n3 = 0; n3 <= this.sdSize.getLargeSide(); ++n3) {
                if (n3 % this.sdSize.getSmallRows() == 0) {
                    graphics2D.setStroke(basicStroke2);
                } else {
                    graphics2D.setStroke(basicStroke);
                }
                graphics2D.drawLine(n5, n6 + n3 * n4, n5 + this.sdSize.getLargeSide() * n4, n6 + n3 * n4);
            }
            for (n3 = 0; n3 <= this.sdSize.getLargeSide(); ++n3) {
                if (n3 % this.sdSize.getSmallCols() == 0) {
                    graphics2D.setStroke(basicStroke2);
                } else {
                    graphics2D.setStroke(basicStroke);
                }
                graphics2D.drawLine(n5 + n3 * n4, n6, n5 + n3 * n4, n6 + this.sdSize.getLargeSide() * n4);
            }
            graphics2D.setStroke(basicStroke);
            Font font = graphics2D.getFont().deriveFont((float)((double)n4 / 2.0));
            graphics2D.setFont(font);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n8 = fontMetrics.getMaxDescent();
            for (n2 = 0; n2 < this.sdSize.getLargeSide(); ++n2) {
                for (int i = 0; i < this.sdSize.getLargeSide(); ++i) {
                    charSequence = this.cells[n2][i].getaText();
                    if ("".equals(charSequence)) continue;
                    Rectangle2D rectangle2D = font.getStringBounds((String)charSequence, graphics2D.getFontRenderContext());
                    graphics2D.setColor(this.cells[n2][i].getForeground());
                    graphics2D.drawString((String)charSequence, (int)((double)(n5 + i * n4) + ((double)n4 - rectangle2D.getWidth()) / 2.0), (int)((double)(n6 + n2 * n4) + ((double)n4 + rectangle2D.getHeight()) / 2.0) - n8);
                }
            }
            graphics2D.setColor(Color.BLACK);
            if (this.guiInput.getUseXSudoku()) {
                graphics2D.setStroke(basicStroke3);
                for (n2 = 0; n2 < this.sdSize.getLargeSide(); ++n2) {
                    this.drawCell(graphics2D, n5, n6, n4, n2, n2);
                    this.drawCell(graphics2D, n5, n6, n4, n2, this.sdSize.getLargeSide() - (n2 + 1));
                }
                graphics2D.setStroke(basicStroke);
            }
            n2 = 18;
            Font font2 = font.deriveFont((float)n2);
            graphics2D.setFont(font2);
            charSequence = new StringBuilder();
            if (this.guiInput.getUseExtra()) {
                ((StringBuilder)charSequence).append("Complete ");
            }
            if (this.guiInput.getUseXSudoku()) {
                ((StringBuilder)charSequence).append("X-SuDoku ");
            } else {
                ((StringBuilder)charSequence).append("SuDoku ");
            }
            int n9 = n6 + (this.sdSize.getLargeSide() + 1) * n4;
            String string = this.guiInput.getSuDoku().getSuDokuResources().getParsedProperty("printout.footer");
            if (string == null || string.length() == 0) {
                string = this.guiInput.getSuDoku().getSuDokuResources().getStringFromKey("DEFAULT_PRINTER_FOOTER");
            }
            if ((stringArray = string.split("\n")).length >= 1) {
                ((StringBuilder)charSequence).append(stringArray[0]);
                graphics2D.drawString(((StringBuilder)charSequence).toString(), n5, n9);
            }
            for (int i = 1; i < stringArray.length; ++i) {
                graphics2D.drawString(stringArray[i], n5, n9 + i * n2);
            }
            n9 += n2 * stringArray.length;
            SuDokuResources suDokuResources = this.guiInput.getSuDoku().getSuDokuResources();
            ImageIcon imageIcon = suDokuResources.getSat4jIcon();
            ImageIcon imageIcon2 = suDokuResources.getECITIcon();
            ImageIcon imageIcon3 = suDokuResources.getCRILIcon();
            ImageIcon imageIcon4 = suDokuResources.getObjectWebIcon();
            ImageIcon imageIcon5 = suDokuResources.getEventIcon();
            int n10 = n6;
            if (this.sdSize.getLargeSide() <= 9) {
                int n11 = 250;
                int n12 = n5 + (this.sdSize.getLargeSide() + 1) * n4;
                int n13 = this.scaleWidthToHeight(n11, imageIcon);
                graphics2D.drawImage(imageIcon.getImage(), n12, n10, n11, n13, imageIcon.getImageObserver());
                n10 += n13 + 20;
                n13 = this.scaleWidthToHeight(n11, imageIcon2);
                graphics2D.drawImage(imageIcon2.getImage(), n12, n10, n11, n13, imageIcon2.getImageObserver());
                n10 += n13 + 20;
                n13 = this.scaleWidthToHeight(n11, imageIcon3);
                graphics2D.drawImage(imageIcon3.getImage(), n12, n10, n11, n13, imageIcon3.getImageObserver());
                n10 += n13 + 20;
                n13 = this.scaleWidthToHeight(n11, imageIcon4);
                graphics2D.drawImage(imageIcon4.getImage(), n12, n10, n11, n13, imageIcon4.getImageObserver());
                n10 += n13 + 20;
                n13 = this.scaleWidthToHeight(n11, imageIcon5);
                graphics2D.drawImage(imageIcon5.getImage(), n12 + 10, n10, n11, n13, imageIcon5.getImageObserver());
            } else {
                int n14 = n5;
                n10 = n9 + 20;
                int n15 = 200;
                n14 = n5;
                int n16 = this.scaleWidthToHeight(n15, imageIcon);
                graphics2D.drawImage(imageIcon.getImage(), n14, n10, n15, n16, imageIcon.getImageObserver());
                n16 = this.scaleWidthToHeight(n15, imageIcon2);
                graphics2D.drawImage(imageIcon2.getImage(), n14 += n15 + 20, n10, n15, n16, imageIcon2.getImageObserver());
                n16 = this.scaleWidthToHeight(n15, imageIcon3);
                graphics2D.drawImage(imageIcon3.getImage(), n14 += n15 + 20, n10, n15, n16, imageIcon3.getImageObserver());
                n16 = this.scaleWidthToHeight(n15, imageIcon4);
                graphics2D.drawImage(imageIcon4.getImage(), n14 += n15 + 20, n10, n15, n16, imageIcon4.getImageObserver());
                n16 = this.scaleWidthToHeight(n15, imageIcon5);
                graphics2D.drawImage(imageIcon5.getImage(), n14 += n15 + 15, n10 - 75, n15, n16, imageIcon5.getImageObserver());
            }
            return 0;
        }
        return 1;
    }

    public void setCellRenderer(TextualOneCell.SudokuRenderer sudokuRenderer) {
        TextualOneCell.setRenderer(sudokuRenderer);
    }

    public void updateContextualMenus() {
        for (int i = 0; i < this.sdSize.getLargeSide(); ++i) {
            for (int j = 0; j < this.sdSize.getLargeSide(); ++j) {
                this.cells[i][j].updateContextualMenu();
            }
        }
    }

    public void enableXGrid(Color[] colorArray) {
        for (int i = 0; i < this.sdSize.getLargeSide(); ++i) {
            if (graphical) {
                this.cells[i][i].setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
                this.cells[i][this.sdSize.getLargeSide() - i - 1].setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
                continue;
            }
            this.cells[i][i].setColors(colorArray);
            this.cells[i][this.sdSize.getLargeSide() - i - 1].setColors(colorArray);
        }
    }

    public void disableXgrid() {
        for (int i = 0; i < this.sdSize.getLargeSide(); ++i) {
            if (graphical) {
                this.cells[i][i].setBorder(null);
                this.cells[i][this.sdSize.getLargeSide() - i - 1].setBorder(null);
                continue;
            }
            this.cells[i][i].setColors(this.cellColors(i, i));
            this.cells[i][this.sdSize.getLargeSide() - i - 1].setColors(this.cellColors(i, this.sdSize.getLargeSide() - i - 1));
        }
    }

    class CellClicked
    extends MouseAdapter {
        int row;
        int column;

        CellClicked(int n, int n2) {
            this.row = n;
            this.column = n2;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (CellGrid.this.guiInput.getHintForCell() && !CellGrid.this.cells[this.row][this.column].getProtected()) {
                CellGrid.this.cells[this.row][this.column].setCursor(Cursor.getPredefinedCursor(12));
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (CellGrid.this.guiInput.getHintForCell()) {
                CellGrid.this.cells[this.row][this.column].setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (CellGrid.this.guiInput.getHintForCell()) {
                try {
                    CellGrid.this.guiInput.getSuDoku().graphicalSolveOneCell(CellGrid.this, this.row + 1, this.column + 1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                CellGrid.this.guiInput.clearHintForCell();
                CellGrid.this.cells[this.row][this.column].setCursor(Cursor.getPredefinedCursor(0));
                CellGrid.this.guiInput.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    class ImportParser {
        char[] line;
        int p;

        ImportParser(String string) {
            this.line = string.toCharArray();
            this.p = 0;
        }

        public int nextValue() {
            boolean bl = false;
            int n = 0;
            if (this.p < this.line.length) {
                while (this.p < this.line.length && this.line[this.p] != '.' && (this.line[this.p] < '0' || this.line[this.p] > '9')) {
                    ++this.p;
                }
                if (this.p < this.line.length && this.line[this.p] == '.') {
                    ++this.p;
                } else {
                    while (this.p < this.line.length && !bl && '0' <= this.line[this.p] && this.line[this.p] <= '9') {
                        char c = this.line[this.p];
                        int n2 = c - 48;
                        n = n * 10 + n2;
                        ++this.p;
                        if (this.p < this.line.length) {
                            c = this.line[this.p];
                        }
                        if (CellGrid.this.sdSize.getLargeSide() >= 10) continue;
                        bl = true;
                    }
                }
                while (this.p < this.line.length && this.line[this.p] != '.' && (this.line[this.p] < '0' || this.line[this.p] > '9')) {
                    ++this.p;
                }
            }
            return n;
        }
    }
}

