/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.apps.sudoku;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import org.sat4j.apps.sudoku.CellGrid;
import org.sat4j.apps.sudoku.CommandHandler;
import org.sat4j.apps.sudoku.EditCommand;
import org.sat4j.apps.sudoku.SuDoku;

public class EditCommandHandler
extends CommandHandler {
    public EditCommandHandler(SuDoku suDoku) {
        super(suDoku);
    }

    void writeToClipboard(String string) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(string);
        clipboard.setContents(stringSelection, null);
    }

    String readFromClipboard() {
        String string = "";
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            string = (String)clipboard.getContents(this).getTransferData(DataFlavor.stringFlavor);
            if (string == null) {
                string = "";
            }
        }
        catch (Exception exception) {
            string = "";
        }
        return string;
    }

    public void execute(Enum enum_) {
        switch ((EditCommand)enum_) {
            case COPY_PUZZLE: {
                String string = this.sudoku.getGui().getCellGrid().exportString();
                if (this.sudoku.getMainProgramWindow().isApplication()) {
                    this.writeToClipboard(string);
                    break;
                }
                this.sudoku.getGui().setPuzzlePaste(string);
                break;
            }
            case PASTE_PUZZLE: {
                String string = this.sudoku.getMainProgramWindow().isApplication() ? this.readFromClipboard() : this.sudoku.getGui().getPuzzlePaste();
                CellGrid cellGrid = this.sudoku.getGui().getCellGrid();
                cellGrid.clearProtection();
                cellGrid.clearAll();
                this.sudoku.getGui().getCellGrid().importString(string);
                this.sudoku.getGui().setProtection(true);
            }
        }
    }
}

