/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.apps.sudoku;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.sat4j.apps.sudoku.CellGrid;
import org.sat4j.apps.sudoku.CommandHandler;
import org.sat4j.apps.sudoku.EditCommandHandler;
import org.sat4j.apps.sudoku.EditMenu;
import org.sat4j.apps.sudoku.FileCommandHandler;
import org.sat4j.apps.sudoku.FileMenu;
import org.sat4j.apps.sudoku.GeneralMenu;
import org.sat4j.apps.sudoku.GraphicalOneCell;
import org.sat4j.apps.sudoku.HelpCommandHandler;
import org.sat4j.apps.sudoku.HelpMenu;
import org.sat4j.apps.sudoku.MainProgramWindow;
import org.sat4j.apps.sudoku.SDSize;
import org.sat4j.apps.sudoku.ShowVersions;
import org.sat4j.apps.sudoku.SuDoku;
import org.sat4j.apps.sudoku.SuDokuResources;
import org.sat4j.apps.sudoku.TextualOneCell;

class GUIInput
extends JTabbedPane {
    Color[] blueColors;
    Color[] whiteColors;
    Color[] diagonalColors;
    static Color userColor = Color.WHITE;
    static Color solverColor = new Color(255, 230, 230);
    static Color highlightColor = Color.RED;
    SDSize sdSize;
    boolean protectionSet = false;
    CellGrid cellGrid;
    AbstractButton hintForCell;
    JButton check;
    JButton solve;
    JButton exit;
    JButton clear;
    JButton clearComputers;
    JButton protect;
    JButton clearAll;
    JPanel cellGridPanel;
    JButton twoSize;
    JButton threeSize;
    JButton fourSize;
    JButton fiveSize = null;
    JButton sixSize = null;
    JButton randomCellHint;
    JSpinner rowSpinner;
    JSpinner colSpinner;
    SpinnerNumberModel rowSpinnerNumberModel;
    SpinnerNumberModel colSpinnerNumberModel;
    JButton protectedColor;
    JButton saveCNF;
    JButton readModel;
    JButton create;
    TextualOneCell fillCount;
    JSpinner.DefaultEditor fillCountEditor;
    JCheckBox onlyCreateUnique;
    JCheckBox useExtra;
    JCheckBox useXSudoku;
    JTextField result;
    JTextArea cnfFile;
    JTextArea cnfModel;
    JTextArea puzzlePasteArea;
    JScrollPane cnfScroll;
    JScrollPane modelScroll;
    JButton fullCNF;
    JButton simplerCNF;
    JButton showModel;
    JButton interpretModel;
    JComponent gridAndControls;
    MainProgramWindow mainProgramWindow;
    SuDoku sudoku;
    SuDokuResources suDokuResources;
    private JComboBox textualrenderers;
    private JComboBox graphrenderers;

    GUIInput(MainProgramWindow mainProgramWindow, SDSize sDSize, SuDoku suDoku, int n) {
        Box box;
        this.mainProgramWindow = mainProgramWindow;
        this.sdSize = sDSize;
        this.sudoku = suDoku;
        this.suDokuResources = suDoku.getSuDokuResources();
        this.createMenuBar(mainProgramWindow.getJMenuBar());
        this.useXSudoku = new JCheckBox("X-SuDoku");
        this.blueColors = new Color[TextualOneCell.getNumberOfColours()];
        this.blueColors[0] = new Color(0, 0, 0);
        this.blueColors[5] = new Color(230, 230, 255);
        this.blueColors[1] = new Color(255, 0, 0);
        this.blueColors[2] = new Color(100, 100, 255);
        this.blueColors[4] = new Color(51, 51, 255);
        this.whiteColors = new Color[TextualOneCell.getNumberOfColours()];
        this.whiteColors[0] = new Color(0, 0, 0);
        this.whiteColors[1] = new Color(255, 0, 0);
        this.whiteColors[5] = new Color(255, 255, 255);
        this.whiteColors[2] = new Color(100, 100, 255);
        this.whiteColors[4] = new Color(51, 51, 255);
        this.diagonalColors = new Color[TextualOneCell.getNumberOfColours()];
        this.diagonalColors[0] = new Color(0, 0, 0);
        this.diagonalColors[1] = new Color(255, 0, 0);
        this.diagonalColors[5] = new Color(170, 170, 170);
        this.diagonalColors[2] = new Color(100, 100, 255);
        this.diagonalColors[4] = new Color(51, 51, 255);
        this.cellGrid = new CellGrid(sDSize, this);
        this.gridAndControls = new JPanel();
        this.gridAndControls.setLayout(new BorderLayout());
        this.add((Component)this.gridAndControls, "Puzzle");
        this.cellGridPanel = new JPanel();
        this.cellGridPanel.add(this.cellGrid);
        this.gridAndControls.add((Component)this.cellGridPanel, "Center");
        Box box2 = Box.createVerticalBox();
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder(this.suDokuResources.getStringFromKey("LABEL_GENERATION")));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        URL uRL = this.getClass().getResource("/toolbarButtonGraphics/general/New24.gif");
        this.create = new JButton(this.suDokuResources.getStringFromKey("BUTTON_CREATE"), new ImageIcon(uRL));
        ActionListener actionListener = new CreateActionListener();
        this.create.addActionListener(actionListener);
        jPanel2.add(this.create);
        JButton jButton = new JButton(new ImageIcon(uRL));
        jButton.addActionListener(actionListener);
        this.fillCount = new TextualOneCell(sDSize.getLargeSide() * sDSize.getLargeSide(), this, this.whiteColors);
        this.fillCount.clear();
        this.fillCount.setColumns(3);
        this.fillCount.setMaximumSize(new Dimension(50, 25));
        jPanel3.add(new JLabel(this.suDokuResources.getStringFromKey("BUTTON_FILLED_CELLS")));
        jPanel3.add(this.fillCount);
        this.useXSudoku.addActionListener(new UseXSudokuActionListener());
        jPanel2.add(this.useXSudoku);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        this.onlyCreateUnique = new JCheckBox(this.suDokuResources.getStringFromKey("BUTTON_UNIQUE"));
        this.onlyCreateUnique.addActionListener(new OnlyCreateUniqueActionListener());
        this.onlyCreateUnique.setSelected(true);
        this.fillCount.protect();
        this.useExtra = new JCheckBox(this.suDokuResources.getStringFromKey("BUTTON_COMPLETE"));
        final JPanel jPanel4 = new JPanel();
        jPanel4.add(this.onlyCreateUnique);
        jPanel4.add(this.useExtra);
        this.textualrenderers = new JComboBox();
        this.textualrenderers.setToolTipText(this.suDokuResources.getStringFromKey("TOOLTIP_TEXT_RENDERERS"));
        this.textualrenderers.addItem(TextualOneCell.CLASSIC_RENDERER);
        this.textualrenderers.addItem(TextualOneCell.HEXA_RENDERER);
        this.textualrenderers.addItem(TextualOneCell.OCTAL_RENDERER);
        this.textualrenderers.addItem(TextualOneCell.BINARY_RENDERER);
        this.textualrenderers.addItem(TextualOneCell.LETTER_RENDERER);
        this.textualrenderers.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUIInput.this.cellGrid.setCellRenderer((TextualOneCell.SudokuRenderer)GUIInput.this.textualrenderers.getSelectedItem());
                GUIInput.this.cellGrid.updateContextualMenus();
            }
        });
        this.graphrenderers = new JComboBox();
        this.graphrenderers.setToolTipText(this.suDokuResources.getStringFromKey("TOOLTIP_GRAPH_RENDERERS"));
        this.graphrenderers.addItem("default");
        this.graphrenderers.addItem("bamboo");
        this.graphrenderers.addItem("signs");
        this.graphrenderers.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Method method = GraphicalOneCell.class.getMethod(GUIInput.this.graphrenderers.getSelectedItem() + "Order", new Class[0]);
                    method.invoke(null, new Object[0]);
                    GUIInput.this.cellGrid.updateContextualMenus();
                }
                catch (SecurityException securityException) {
                    securityException.printStackTrace();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    noSuchMethodException.printStackTrace();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    illegalArgumentException.printStackTrace();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.printStackTrace();
                }
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        final JRadioButton jRadioButton = new JRadioButton("Graphical");
        jRadioButton.setToolTipText(this.suDokuResources.getStringFromKey("TOOLTIP_GRAPH_BUTTON"));
        JRadioButton jRadioButton2 = new JRadioButton("Textual");
        jRadioButton2.setToolTipText(this.suDokuResources.getStringFromKey("TOOLTIP_TEXT_BUTTON"));
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = jRadioButton.isSelected();
                CellGrid.setGraphical(bl);
                GUIInput.this.setNewSize(GUIInput.this.rowSpinnerNumberModel.getNumber().intValue(), GUIInput.this.colSpinnerNumberModel.getNumber().intValue());
                if (bl) {
                    jPanel4.remove(GUIInput.this.textualrenderers);
                    jPanel4.add(GUIInput.this.graphrenderers);
                } else {
                    jPanel4.remove(GUIInput.this.graphrenderers);
                    jPanel4.add(GUIInput.this.textualrenderers);
                }
                GUIInput.this.cellGrid.clearProtection();
                GUIInput.this.cellGrid.clear();
                GUIInput.this.mainProgramWindow.pack();
            }
        };
        jRadioButton.addActionListener(actionListener2);
        jRadioButton2.addActionListener(actionListener2);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(2, 1));
        jPanel5.setBorder(new TitledBorder(this.suDokuResources.getStringFromKey("LABEL_UNUSUAL_FEATURES")));
        jPanel5.add(jPanel4);
        JPanel jPanel6 = new JPanel();
        jPanel6.add(jRadioButton);
        jPanel6.add(jRadioButton2);
        jPanel5.add(jPanel6);
        jPanel.add(jPanel5);
        JPanel jPanel7 = new JPanel();
        jPanel7.setBorder(new TitledBorder(this.suDokuResources.getStringFromKey("LABEL_SET_SIZE")));
        jPanel7.setLayout(new GridLayout(2, 1));
        JPanel jPanel8 = new JPanel();
        this.twoSize = new JButton("2 x 2");
        this.twoSize.addActionListener(new GridSizeListener(2));
        jPanel8.add(this.twoSize);
        JButton jButton2 = new JButton("2 x 3");
        jButton2.addActionListener(new GridSizeListener(2, 3));
        jPanel8.add(jButton2);
        this.threeSize = new JButton("3 x 3");
        this.threeSize.addActionListener(new GridSizeListener(3));
        jPanel8.add(this.threeSize);
        jPanel7.add(jPanel8);
        JPanel jPanel9 = new JPanel();
        this.fourSize = new JButton("4 x 4");
        this.fourSize.addActionListener(new GridSizeListener(4));
        jPanel9.add(this.fourSize);
        if (n >= 25) {
            this.fiveSize = new JButton("5 x 5");
            this.fiveSize.addActionListener(new GridSizeListener(5));
            jPanel9.add(this.fiveSize);
        }
        this.rowSpinnerNumberModel = new SpinnerNumberModel(3, 1, 6, 1);
        this.rowSpinner = new JSpinner(this.rowSpinnerNumberModel);
        this.rowSpinner.setEditor(new JSpinner.DefaultEditor(this.rowSpinner));
        this.rowSpinner.addChangeListener(new SpinnerListener());
        this.colSpinnerNumberModel = new SpinnerNumberModel(3, 1, 6, 1);
        this.colSpinner = new JSpinner(this.colSpinnerNumberModel);
        this.colSpinner.addChangeListener(new SpinnerListener());
        this.colSpinner.setEditor(new JSpinner.DefaultEditor(this.colSpinner));
        jPanel9.add(new JLabel(" "));
        jPanel9.add(this.rowSpinner);
        jPanel9.add(new JLabel("X"));
        jPanel9.add(this.colSpinner);
        jPanel7.add(jPanel9);
        jPanel.add(jPanel7);
        box2.add(jPanel);
        box2.add(Box.createVerticalGlue());
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new GridLayout(3, 1));
        JPanel jPanel11 = new JPanel();
        this.protect = new JButton(this.suDokuResources.getStringFromKey("BUTTON_PROTECT"));
        this.protect.addActionListener(new ProtectActionListener());
        jPanel11.add(this.protect);
        this.check = new JButton(this.suDokuResources.getStringFromKey("BUTTON_CHECK"));
        this.check.addActionListener(new CheckActionListener());
        jPanel11.add(this.check);
        this.solve = new JButton(this.suDokuResources.getStringFromKey("BUTTON_SOLVE"));
        this.solve.addActionListener(new SolveActionListener());
        jPanel11.add(this.solve);
        jPanel10.add(jPanel11);
        JPanel jPanel12 = new JPanel();
        uRL = this.getClass().getResource("/toolbarButtonGraphics/general/TipOfTheDay24.gif");
        this.randomCellHint = new JButton(this.suDokuResources.getStringFromKey("BUTTON_RANDOM"), new ImageIcon(uRL));
        actionListener = new RandomCellHintActionListener();
        this.randomCellHint.addActionListener(actionListener);
        jPanel12.add(this.randomCellHint);
        jButton = new JButton(new ImageIcon(uRL));
        jButton.addActionListener(actionListener);
        uRL = this.getClass().getResource("/toolbarButtonGraphics/general/ContextualHelp24.gif");
        this.hintForCell = new JToggleButton(this.suDokuResources.getStringFromKey("BUTTON_CHOSEN"), new ImageIcon(uRL));
        jPanel12.add(this.hintForCell);
        this.hintForCell.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUIInput.this.setCursor(Cursor.getPredefinedCursor(12));
            }
        });
        jPanel10.add(jPanel12);
        JPanel jPanel13 = new JPanel();
        this.clearComputers = new JButton(this.suDokuResources.getStringFromKey("BUTTON_CLEAR_SOLVERS"));
        this.clearComputers.addActionListener(new ClearComputersActionListener());
        jPanel13.add(this.clearComputers);
        this.clear = new JButton(this.suDokuResources.getStringFromKey("BUTTON_CLEAR_MINE"));
        this.clear.addActionListener(new ClearActionListener());
        jPanel13.add(this.clear);
        jPanel10.add(jPanel13);
        box2.add(jPanel10);
        box2.add(Box.createVerticalGlue());
        JPanel jPanel14 = new JPanel();
        jPanel14.setBorder(new TitledBorder(this.suDokuResources.getStringFromKey("LABEL_SET_COLOURS")));
        jPanel14.add(new ColorButton(4, this.suDokuResources.getStringFromKey("COLOURS_PROTECTED")));
        jPanel14.add(new ColorButton(1, this.suDokuResources.getStringFromKey("COLOURS_COMPUTERS")));
        jPanel14.add(new ColorButton(0, this.suDokuResources.getStringFromKey("COLOURS_MINE")));
        box2.add(Box.createVerticalGlue());
        box2.add(jPanel14);
        if (!mainProgramWindow.isApplication()) {
            box2.add(Box.createVerticalGlue());
            this.puzzlePasteArea = new JTextArea(1, 5);
            box = Box.createHorizontalBox();
            box.add(new JLabel("Paste area"));
            box.add(new JScrollPane(this.puzzlePasteArea));
            box2.add(box);
        }
        box2.add(Box.createVerticalGlue());
        this.result = new JTextField(20);
        this.result.setEditable(false);
        this.gridAndControls.add((Component)this.result, "South");
        box = Box.createHorizontalBox();
        box.add(new ShowVersions());
        box2.add(box);
        this.gridAndControls.add((Component)box2, "East");
        Box box3 = Box.createHorizontalBox();
        Box box4 = Box.createVerticalBox();
        box4.add(new JLabel("cnf problem"));
        this.cnfFile = new JTextArea(20, 20);
        this.cnfFile.setEditable(false);
        this.cnfScroll = new JScrollPane(this.cnfFile);
        box4.add(this.cnfScroll);
        box3.add(box4);
        Box box5 = Box.createVerticalBox();
        box5.add(new JLabel("solution"));
        this.cnfModel = new JTextArea(10, 10);
        this.modelScroll = new JScrollPane(this.cnfModel);
        box5.add(this.modelScroll);
        box3.add(Box.createHorizontalStrut(4));
        box3.add(box5);
        Box box6 = Box.createVerticalBox();
        Box box7 = Box.createHorizontalBox();
        this.fullCNF = new JButton("Full cnf");
        this.fullCNF.addActionListener(new FullCNFActionListener());
        box7.add(this.fullCNF);
        this.simplerCNF = new JButton("Simpler cnf");
        this.simplerCNF.addActionListener(new SimplerCNFActionListener());
        box7.add(this.simplerCNF);
        box6.add(box7);
        Box box8 = Box.createHorizontalBox();
        this.showModel = new JButton("Show Model");
        this.showModel.addActionListener(new ShowModelActionListener());
        this.showModel.setEnabled(true);
        box8.add(this.showModel);
        this.interpretModel = new JButton("Interpret Model");
        this.interpretModel.addActionListener(new InterpretModelActionListener());
        box8.add(this.interpretModel);
        box6.add(box8);
        if (mainProgramWindow.fileAccess()) {
            Box box9 = Box.createHorizontalBox();
            this.saveCNF = new JButton("Save cnf to file");
            this.saveCNF.addActionListener(new SaveCNFActionListener());
            box9.add(this.saveCNF);
            this.readModel = new JButton("Read model from file");
            this.readModel.addActionListener(new ReadModelActionListener());
            box9.add(this.readModel);
            box6.add(box9);
        }
        box3.add(Box.createRigidArea(new Dimension(4, 400)));
        box3.add(box6);
        this.add((Component)box3, "CNF");
        this.setLocalToolTipText(this.create, "TOOLTIP_CREATE");
        this.setLocalToolTipText(this.fillCount, "TOOLTIP_FILLED_CELLS");
        this.setLocalToolTipText(this.useXSudoku, "TOOLTIP_XSUDOKU");
        this.setLocalToolTipText(this.onlyCreateUnique, "TOOLTIP_UNIQUE");
        this.setLocalToolTipText(this.useExtra, "TOOLTIP_COMPLETE");
        this.setLocalToolTipText(this.protect, "TOOLTIP_PROTECT");
        this.setLocalToolTipText(this.check, "TOOLTIP_CHECK");
        this.setLocalToolTipText(this.solve, "TOOLTIP_SOLVE");
        this.setLocalToolTipText(this.randomCellHint, "TOOLTIP_RANDOM");
        this.setLocalToolTipText(this.hintForCell, "TOOLTIP_CHOSEN");
        this.setLocalToolTipText(this.clearComputers, "TOOLTIP_CLEARSOL");
        this.setLocalToolTipText(this.clear, "TOOLTIP_CLEARMINE");
        this.setLocalToolTipText(this.twoSize, "TOOLTIP_SIZE_4_4");
        this.setLocalToolTipText(this.threeSize, "TOOLTIP_SIZE_9_9");
        this.setLocalToolTipText(this.fourSize, "TOOLTIP_SIZE_16_16");
        if (this.fiveSize != null) {
            this.setLocalToolTipText(this.fiveSize, "TOOLTIP_SIZE_25_25");
        }
        if (this.sixSize != null) {
            this.setLocalToolTipText(this.sixSize, "TOOLTIP_SIZE_36_36");
        }
        this.setNewSize(3, 3);
        jRadioButton2.doClick();
        this.setVisible(true);
    }

    void createMenuBar(JMenuBar jMenuBar) {
        GeneralMenu generalMenu;
        CommandHandler commandHandler;
        if (this.mainProgramWindow.fileAccess()) {
            commandHandler = new FileCommandHandler(this.sudoku);
            generalMenu = new FileMenu(commandHandler, this.sudoku);
            jMenuBar.add(generalMenu);
        }
        commandHandler = new EditCommandHandler(this.sudoku);
        generalMenu = new EditMenu(commandHandler, this.sudoku);
        jMenuBar.add(generalMenu);
        HelpCommandHandler helpCommandHandler = new HelpCommandHandler(this.sudoku);
        HelpMenu helpMenu = new HelpMenu(helpCommandHandler, this.sudoku);
        jMenuBar.add(helpMenu);
    }

    void setLocalToolTipText(JComponent jComponent, String string) {
        jComponent.setToolTipText(this.suDokuResources.getStringFromKey(string));
    }

    public void puzzleChanged() {
        this.cnfModel.setText("");
        this.cnfFile.setText("");
        this.showModel.setEnabled(false);
    }

    public String getPuzzlePaste() {
        return this.puzzlePasteArea.getText();
    }

    public void setPuzzlePaste(String string) {
        this.puzzlePasteArea.setText(string);
    }

    public boolean getUseExtra() {
        return this.useExtra.isSelected();
    }

    public boolean getUseXSudoku() {
        return this.useXSudoku.isSelected();
    }

    public void setResult(String string) {
        this.result.setText(string);
    }

    public void setCNFFile(String string) {
        this.cnfFile.setText(string);
    }

    public String getCNFFile() {
        return this.cnfFile.getText();
    }

    public void setCNFModel(String string) {
        this.cnfModel.setText(string);
    }

    public String getCNFModel() {
        return this.cnfModel.getText();
    }

    public void clearCNF() {
        this.setCNFFile("");
        this.setCNFModel("");
    }

    public CellGrid getCellGrid() {
        return this.cellGrid;
    }

    public void setColor(int n, Color color) {
        this.blueColors[n] = color;
        this.whiteColors[n] = color;
        this.cellGrid.refreshCells();
    }

    public void setSize(int n, int n2) {
        this.mainProgramWindow.setMainWindowSize(n, n2);
        super.setSize(n, n2);
    }

    public void setFillCount(int n) {
        this.fillCount.clearProtection();
        this.fillCount.setText("" + n);
        if (this.onlyCreateUnique.isSelected()) {
            this.fillCount.protect();
        }
    }

    public Color[] getBlueColors() {
        return this.blueColors;
    }

    public Color[] getWhiteColors() {
        return this.whiteColors;
    }

    public Color[] getDiagonalColors() {
        return this.diagonalColors;
    }

    long memoryNeeded() {
        long l = 0L;
        switch (this.sdSize.getLargeSide()) {
            case 4: {
                l = 20000000L;
                break;
            }
            case 9: {
                l = 50000000L;
                break;
            }
            case 16: {
                l = 50000000L;
                break;
            }
            case 25: {
                l = 50000000L;
            }
        }
        return l;
    }

    boolean enoughMemory() {
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.maxMemory();
        boolean bl = l > this.memoryNeeded();
        return bl;
    }

    void solve(boolean bl) {
        this.setResult("");
        if (this.enoughMemory()) {
            try {
                this.sudoku.graphicalSolve(this.cellGrid, bl);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            this.notEnoughMemory();
        }
    }

    void notEnoughMemory() {
        this.setResult("For this grid, java memory of " + this.memoryNeeded() + " needed");
    }

    void setProtection(boolean bl) {
        if (bl) {
            this.cellGrid.protect();
            this.protect.setText(this.suDokuResources.getStringFromKey("BUTTON_UNPROTECT"));
            this.protect.setToolTipText(this.suDokuResources.getStringFromKey("TOOLTIP_UNPROTECT"));
            this.protectionSet = true;
        } else {
            this.cellGrid.clearProtection();
            this.protect.setText(this.suDokuResources.getStringFromKey("BUTTON_PROTECT"));
            this.protect.setToolTipText(this.suDokuResources.getStringFromKey("TOOLTIP_PROTECT"));
            this.protectionSet = false;
        }
    }

    public boolean getHintForCell() {
        return this.hintForCell.isSelected();
    }

    public void clearHintForCell() {
        this.hintForCell.setSelected(false);
    }

    public SuDoku getSuDoku() {
        return this.sudoku;
    }

    public void setNewSize(int n, int n2) {
        this.setResult("");
        this.sdSize.setSide(n, n2);
        this.useExtra.setEnabled(n == n2);
        CellGrid cellGrid = new CellGrid(this.sdSize, this);
        this.fillCount.clearProtection();
        this.fillCount.setMax(this.sdSize.getLargeSide() * this.sdSize.getLargeSide());
        this.fillCount.clear();
        this.cellGridPanel.remove(this.cellGrid);
        this.cellGrid = cellGrid;
        this.cellGridPanel.add((Component)this.cellGrid, 0);
        this.onlyCreateUnique.setSelected(true);
        this.fillCount.protect();
        if (n > 4 && n2 > 4) {
            if (!this.sudoku.getCreateUniqueAllowed()) {
                this.onlyCreateUnique.setEnabled(false);
                this.fillCount.clearProtection();
            }
            this.mainProgramWindow.maximize();
        } else {
            this.onlyCreateUnique.setEnabled(true);
        }
        this.setProtection(false);
        this.gridAndControls.validate();
        this.gridAndControls.repaint();
        this.mainProgramWindow.pack();
    }

    class ReadModelActionListener
    implements ActionListener {
        ReadModelActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUIInput.this.setCNFModel(GUIInput.this.mainProgramWindow.readFile());
        }
    }

    class SaveCNFActionListener
    implements ActionListener {
        SaveCNFActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUIInput.this.mainProgramWindow.writeFile(GUIInput.this.getCNFFile());
        }
    }

    class ExitActionListener
    implements ActionListener {
        ExitActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUIInput.this.setResult("");
            System.exit(1);
        }
    }

    class ClearAllActionListener
    implements ActionListener {
        ClearAllActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUIInput.this.setResult("");
            GUIInput.this.clearCNF();
            GUIInput.this.cellGrid.clearAll();
        }
    }

    class ProtectActionListener
    implements ActionListener {
        ProtectActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUIInput.this.setResult("");
            GUIInput.this.setProtection(!GUIInput.this.protectionSet);
        }
    }

    class ClearComputersActionListener
    implements ActionListener {
        ClearComputersActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUIInput.this.setResult("");
            GUIInput.this.cellGrid.clearComputers();
        }
    }

    class ClearActionListener
    implements ActionListener {
        ClearActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUIInput.this.setResult("");
            GUIInput.this.clearCNF();
            GUIInput.this.cellGrid.clear();
        }
    }

    class SpinnerListener
    implements ChangeListener {
        SpinnerListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            GUIInput.this.setNewSize(GUIInput.this.rowSpinnerNumberModel.getNumber().intValue(), GUIInput.this.colSpinnerNumberModel.getNumber().intValue());
        }
    }

    class GridSizeListener
    implements ActionListener {
        int rows;
        int cols;

        GridSizeListener(int n) {
            this.rows = n;
            this.cols = n;
        }

        GridSizeListener(int n, int n2) {
            this.rows = n;
            this.cols = n2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUIInput.this.rowSpinner.setValue(this.rows);
            GUIInput.this.colSpinner.setValue(this.cols);
            GUIInput.this.setNewSize(this.rows, this.cols);
        }
    }

    class ColorActionListener
    implements ActionListener {
        int id;
        String title;
        ColorButton owner;

        public ColorActionListener(ColorButton colorButton, int n, String string) {
            this.id = n;
            this.title = string;
            this.owner = colorButton;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Color color = JColorChooser.showDialog(GUIInput.this, this.title, GUIInput.this.whiteColors[this.id]);
            if (color != null) {
                GUIInput.this.setColor(this.id, color);
                GUIInput.this.fillCount.refresh();
                this.owner.setForeground(color);
            }
        }
    }

    class ColorButton
    extends JButton {
        ColorButton(int n, String string) {
            super(string);
            this.setBackground(Color.WHITE);
            this.setForeground(GUIInput.this.whiteColors[n]);
            this.addActionListener(new ColorActionListener(this, n, "Set " + string + " colour"));
        }
    }

    class OnlyCreateUniqueActionListener
    implements ActionListener {
        OnlyCreateUniqueActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (GUIInput.this.onlyCreateUnique.isSelected()) {
                GUIInput.this.fillCount.clearProtection();
                GUIInput.this.fillCount.clear();
                GUIInput.this.fillCount.protect();
            } else {
                GUIInput.this.fillCount.clearProtection();
                GUIInput.this.fillCount.clear();
            }
        }
    }

    class InterpretModelActionListener
    implements ActionListener {
        InterpretModelActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUIInput.this.setResult("");
            GUIInput.this.cellGrid.clearComputers();
            GUIInput.this.sudoku.interpretModel(GUIInput.this.cellGrid);
        }
    }

    class ShowModelActionListener
    implements ActionListener {
        ShowModelActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUIInput.this.setResult("");
            GUIInput.this.setCNFModel("");
            GUIInput.this.solve(true);
        }
    }

    class FullCNFActionListener
    implements ActionListener {
        FullCNFActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUIInput.this.setResult("");
            GUIInput.this.sudoku.fullCNF(GUIInput.this.cellGrid);
        }
    }

    class SimplerCNFActionListener
    implements ActionListener {
        SimplerCNFActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUIInput.this.setResult("");
            GUIInput.this.sudoku.simplerCNF(GUIInput.this.cellGrid);
        }
    }

    class UseXSudokuActionListener
    implements ActionListener {
        UseXSudokuActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (GUIInput.this.getUseXSudoku()) {
                GUIInput.this.cellGrid.clearProtection();
                GUIInput.this.cellGrid.clear();
                GUIInput.this.cellGrid.enableXGrid(GUIInput.this.diagonalColors);
            } else {
                GUIInput.this.cellGrid.disableXgrid();
            }
        }
    }

    class SolveActionListener
    implements ActionListener {
        SolveActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUIInput.this.solve(false);
        }
    }

    class CreateActionListener
    implements ActionListener {
        CreateActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUIInput.this.setCursor(Cursor.getPredefinedCursor(3));
            GUIInput.this.setResult("");
            GUIInput.this.clearCNF();
            if (GUIInput.this.enoughMemory()) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        GUIInput.this.sudoku.createPuzzle(GUIInput.this.fillCount.getIntValue(), GUIInput.this.cellGrid, GUIInput.this.onlyCreateUnique.isSelected());
                    }
                };
                Thread thread = new Thread(runnable);
                thread.start();
            } else {
                GUIInput.this.notEnoughMemory();
            }
            GUIInput.this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    class RandomCellHintActionListener
    implements ActionListener {
        RandomCellHintActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUIInput.this.setResult("");
            GUIInput.this.sudoku.randomCellHint(GUIInput.this.cellGrid);
        }
    }

    class CheckActionListener
    implements ActionListener {
        CheckActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUIInput.this.setResult("");
            GUIInput.this.sudoku.checkSolution(GUIInput.this.cellGrid);
        }
    }
}

