/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.apps.sudoku;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.sat4j.apps.sudoku.CommandHandler;
import org.sat4j.apps.sudoku.HelpCommand;
import org.sat4j.apps.sudoku.ShowVersions;
import org.sat4j.apps.sudoku.SuDoku;
import org.sat4j.apps.sudoku.SuDokuResources;

public class HelpCommandHandler
extends CommandHandler {
    static String sudokuURL = "http://www.cs.qub.ac.uk/~i.spence/SuDoku/SuDoku.html";
    static String completeSudokuURL = "http://www.cs.qub.ac.uk/~i.spence/SuDoku/Complete.html";
    static String sat4jURL = "http://www.sat4j.org/";

    public HelpCommandHandler(SuDoku suDoku) {
        super(suDoku);
    }

    void processWebPage(String string) {
        try {
            if (this.sudoku.getMainProgramWindow().isApplet()) {
                ((JApplet)((Object)this.sudoku.getMainProgramWindow())).getAppletContext().showDocument(new URL(string), "SD_HELP_WINDOW");
            } else {
                WebPage webPage = new WebPage((JFrame)((Object)this.sudoku.getMainProgramWindow()), string);
                webPage.setVisible(true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.sudoku.getGui().setResult(exception.toString());
        }
    }

    void processAboutPage() {
        ShowVersions showVersions = new ShowVersions();
        String string = "<html>SuDoku " + showVersions.getVersion("sudoku") + " at " + sudokuURL + "<p>" + "satj4 " + showVersions.getVersion("sat4j") + " at " + sat4jURL + " (includes source code)";
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 3));
        jPanel2.setBackground(Color.WHITE);
        jPanel2.setOpaque(true);
        SuDokuResources suDokuResources = this.sudoku.getSuDokuResources();
        ImageIcon imageIcon = suDokuResources.getSat4jIcon();
        ImageIcon imageIcon2 = suDokuResources.getECITIcon();
        ImageIcon imageIcon3 = suDokuResources.getCRILIcon();
        ImageIcon imageIcon4 = suDokuResources.getObjectWebIcon();
        ImageIcon imageIcon5 = suDokuResources.getEventIcon();
        int n = 150;
        ImageIcon imageIcon6 = new ImageIcon(imageIcon.getImage().getScaledInstance(n, -1, 0));
        ImageIcon imageIcon7 = new ImageIcon(imageIcon2.getImage().getScaledInstance(n, -1, 0));
        ImageIcon imageIcon8 = new ImageIcon(imageIcon3.getImage().getScaledInstance(n, -1, 0));
        ImageIcon imageIcon9 = new ImageIcon(imageIcon4.getImage().getScaledInstance(n, -1, 0));
        ImageIcon imageIcon10 = new ImageIcon(imageIcon5.getImage().getScaledInstance(n, -1, 0));
        jPanel2.add(new JLabel(imageIcon7));
        jPanel2.add(new JLabel(imageIcon8));
        jPanel2.add(new JLabel(imageIcon9));
        jPanel2.add(new JLabel(imageIcon10));
        jPanel.add(jPanel2);
        jPanel.add(new JLabel(string));
        JOptionPane.showMessageDialog(null, jPanel, this.sudoku.getSuDokuResources().getStringFromKey("HELP_ABOUT"), 1, imageIcon6);
    }

    public void execute(Enum enum_) {
        switch ((HelpCommand)enum_) {
            case ABOUT: {
                this.processAboutPage();
                break;
            }
            case SUDOKU: {
                this.processWebPage(sudokuURL);
                break;
            }
            case COMPLETE_SUDOKU: {
                this.processWebPage(completeSudokuURL);
                break;
            }
            case SAT4J: {
                this.processWebPage(sat4jURL);
            }
        }
    }

    class WebPage
    extends JDialog {
        private static final long serialVersionUID = 1L;

        WebPage(Frame frame, String string) throws Exception {
            super(frame, "Help");
            this.setPreferredSize(new Dimension(600, 500));
            this.setDefaultCloseOperation(2);
            JEditorPane jEditorPane = new JEditorPane();
            jEditorPane.setContentType("text/html");
            jEditorPane.setEditable(false);
            jEditorPane.setPage(string);
            JLabel jLabel = new JLabel("<html>Note that this window does not support hyperlinks.<p>You can copy the following address to paste into a browser if needed:<p>" + string);
            jLabel.setBackground(Color.YELLOW);
            this.getContentPane().add("North", jLabel);
            this.getContentPane().add("Center", new JScrollPane(jEditorPane, 20, 30));
        }
    }
}

