/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.apps.sudoku;

import java.util.Random;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import org.sat4j.apps.sudoku.CellGrid;
import org.sat4j.apps.sudoku.CellStatus;
import org.sat4j.apps.sudoku.Coordinate;
import org.sat4j.apps.sudoku.CoordinateSet;
import org.sat4j.apps.sudoku.GUIInput;
import org.sat4j.apps.sudoku.LineScanner;
import org.sat4j.apps.sudoku.MainProgramWindow;
import org.sat4j.apps.sudoku.RandomPermutation;
import org.sat4j.apps.sudoku.SDSize;
import org.sat4j.apps.sudoku.SortedCoordinateSet;
import org.sat4j.apps.sudoku.SuDokuResources;
import org.sat4j.apps.sudoku.WordScanner;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.minisat.core.DataStructureFactory;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.ILits2;
import org.sat4j.minisat.core.Solver;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;

public class SuDoku {
    SDSize sdSize;
    int clauses;
    GUIInput gui;
    boolean fullCNF;
    boolean createUniqueAllowed;
    SuDokuResources suDokuResources;
    MainProgramWindow mainProgramWindow;
    VecInt vi = new VecInt();
    VecInt vi1 = new VecInt();
    VecInt vi2 = new VecInt();
    ISolver solver;
    Random randomCellChooser;
    boolean passesCheck;
    boolean completed;

    int variable(int n, int n2, int n3) {
        return n * this.sdSize.getBase() * this.sdSize.getBase() + n2 * this.sdSize.getBase() + n3;
    }

    public MainProgramWindow getMainProgramWindow() {
        return this.mainProgramWindow;
    }

    public SuDokuResources getSuDokuResources() {
        return this.suDokuResources;
    }

    void addOneSquareSolver(int n, int n2, ClauseHandler clauseHandler) {
        int n3;
        if (this.fullCNF) {
            this.vi.clear();
            for (n3 = 1; n3 <= this.sdSize.getLargeSide(); ++n3) {
                this.vi.push(this.variable(n, n2, n3));
            }
            clauseHandler.addClause(this.vi);
        }
        for (n3 = 1; n3 <= this.sdSize.getLargeSide() - 1; ++n3) {
            for (int i = n3 + 1; i <= this.sdSize.getLargeSide(); ++i) {
                this.vi.clear();
                this.vi.push(-this.variable(n, n2, n3));
                this.vi.push(-this.variable(n, n2, i));
                clauseHandler.addClause(this.vi);
            }
        }
    }

    int numOfVariables() {
        int n = this.sdSize.getBase() + 1;
        switch (this.sdSize.getLargeSide()) {
            case 4: {
                return 444;
            }
            case 9: {
                return 999;
            }
        }
        return n * n * n;
    }

    void readPuzzleSolver(CellGrid cellGrid, ClauseHandler clauseHandler) {
        for (int i = 1; i <= this.sdSize.getLargeSide(); ++i) {
            for (int j = 1; j <= this.sdSize.getLargeSide(); ++j) {
                int n;
                if (cellGrid.getStatus(i, j) == CellStatus.SOLVER_ENTERED || (n = cellGrid.getIntValue(i, j)) <= 0) continue;
                this.setSquareSolver(i, j, n, clauseHandler);
            }
        }
    }

    void addOneSquaresSolver(ClauseHandler clauseHandler) {
        for (int i = 1; i <= this.sdSize.getLargeSide(); ++i) {
            for (int j = 1; j <= this.sdSize.getLargeSide(); ++j) {
                this.addOneSquareSolver(i, j, clauseHandler);
            }
        }
    }

    int blockVariable(int n, int n2, int n3, int n4, int n5) {
        return this.variable((n - 1) * this.sdSize.getSmallRows() + n3, (n2 - 1) * this.sdSize.getSmallCols() + n4, n5);
    }

    int blockVariable1(int n, int n2, int n3, int n4, int n5) {
        return this.variable((n - 1) * this.sdSize.getSmallRows() + n3, n4, (n2 - 1) * this.sdSize.getSmallRows() + n5);
    }

    int blockVariable2(int n, int n2, int n3, int n4, int n5) {
        return this.variable(n3, (n2 - 1) * this.sdSize.getSmallCols() + n4, (n - 1) * this.sdSize.getSmallRows() + n5);
    }

    void addOneBlockSolver(int n, int n2, ClauseHandler clauseHandler) {
        for (int i = 1; i <= this.sdSize.getLargeSide(); ++i) {
            int n3;
            int n4;
            this.vi.clear();
            if (this.gui.getUseExtra()) {
                this.vi1.clear();
                this.vi2.clear();
            }
            for (n4 = 1; n4 <= this.sdSize.getSmallRows(); ++n4) {
                for (n3 = 1; n3 <= this.sdSize.getSmallCols(); ++n3) {
                    this.vi.push(this.blockVariable(n, n2, n4, n3, i));
                    if (!this.gui.getUseExtra()) continue;
                    this.vi1.push(this.blockVariable1(n, n2, n4, i, n3));
                    this.vi2.push(this.blockVariable2(n, n2, i, n3, n4));
                }
            }
            clauseHandler.addClause(this.vi);
            if (this.gui.getUseExtra()) {
                clauseHandler.addClause(this.vi1);
                clauseHandler.addClause(this.vi2);
            }
            if (!this.fullCNF) continue;
            for (n4 = 1; n4 <= this.sdSize.getLargeSide() - 1; ++n4) {
                for (n3 = n4 + 1; n3 <= this.sdSize.getLargeSide(); ++n3) {
                    int n5 = (n4 - 1) / this.sdSize.getSmallCols() + 1;
                    int n6 = (n4 - 1) % this.sdSize.getSmallCols() + 1;
                    int n7 = (n3 - 1) / this.sdSize.getSmallCols() + 1;
                    int n8 = (n3 - 1) % this.sdSize.getSmallCols() + 1;
                    this.vi.clear();
                    this.vi.push(-this.blockVariable(n, n2, n5, n6, i));
                    this.vi.push(-this.blockVariable(n, n2, n7, n8, i));
                    clauseHandler.addClause(this.vi);
                    if (!this.gui.getUseExtra()) continue;
                    this.vi1.clear();
                    this.vi1.push(-this.blockVariable1(n, n2, n5, i, n6));
                    this.vi1.push(-this.blockVariable1(n, n2, n7, i, n8));
                    clauseHandler.addClause(this.vi1);
                    this.vi2.clear();
                    this.vi2.push(-this.blockVariable2(n, n2, i, n6, n5));
                    this.vi2.push(-this.blockVariable2(n, n2, i, n8, n7));
                    clauseHandler.addClause(this.vi2);
                }
            }
        }
    }

    void addOneRowSolver(int n, ClauseHandler clauseHandler) {
        for (int i = 1; i <= this.sdSize.getLargeSide(); ++i) {
            int n2;
            this.vi.clear();
            for (n2 = 1; n2 <= this.sdSize.getLargeSide(); ++n2) {
                this.vi.push(this.variable(n, n2, i));
            }
            clauseHandler.addClause(this.vi);
            if (!this.fullCNF) continue;
            for (n2 = 1; n2 <= this.sdSize.getLargeSide() - 1; ++n2) {
                for (int j = n2 + 1; j <= this.sdSize.getLargeSide(); ++j) {
                    this.vi.clear();
                    this.vi.push(-this.variable(n, n2, i));
                    this.vi.push(-this.variable(n, j, i));
                    clauseHandler.addClause(this.vi);
                }
            }
        }
    }

    void addOneRowsSolver(ClauseHandler clauseHandler) {
        for (int i = 1; i <= this.sdSize.getLargeSide(); ++i) {
            this.addOneRowSolver(i, clauseHandler);
        }
    }

    void addOneColumnSolver(int n, ClauseHandler clauseHandler) {
        for (int i = 1; i <= this.sdSize.getLargeSide(); ++i) {
            int n2;
            this.vi.clear();
            for (n2 = 1; n2 <= this.sdSize.getLargeSide(); ++n2) {
                this.vi.push(this.variable(n2, n, i));
            }
            clauseHandler.addClause(this.vi);
            if (!this.fullCNF) continue;
            for (n2 = 1; n2 <= this.sdSize.getLargeSide() - 1; ++n2) {
                for (int j = n2 + 1; j <= this.sdSize.getLargeSide(); ++j) {
                    this.vi.clear();
                    this.vi.push(-this.variable(n2, n, i));
                    this.vi.push(-this.variable(j, n, i));
                    clauseHandler.addClause(this.vi);
                }
            }
        }
    }

    void addFallingDiagonalSolver(ClauseHandler clauseHandler) {
        for (int i = 1; i <= this.sdSize.getLargeSide(); ++i) {
            int n;
            this.vi.clear();
            for (n = 1; n <= this.sdSize.getLargeSide(); ++n) {
                this.vi.push(this.variable(n, n, i));
            }
            clauseHandler.addClause(this.vi);
            if (!this.fullCNF) continue;
            for (n = 1; n <= this.sdSize.getLargeSide() - 1; ++n) {
                for (int j = n + 1; j <= this.sdSize.getLargeSide(); ++j) {
                    this.vi.clear();
                    this.vi.push(-this.variable(n, n, i));
                    this.vi.push(-this.variable(j, j, i));
                    clauseHandler.addClause(this.vi);
                }
            }
        }
    }

    void addRisingDiagonalSolver(ClauseHandler clauseHandler) {
        for (int i = 1; i <= this.sdSize.getLargeSide(); ++i) {
            int n;
            this.vi.clear();
            for (n = 1; n <= this.sdSize.getLargeSide(); ++n) {
                this.vi.push(this.variable(n, this.sdSize.getLargeSide() + 1 - n, i));
            }
            clauseHandler.addClause(this.vi);
            if (!this.fullCNF) continue;
            for (n = 1; n <= this.sdSize.getLargeSide() - 1; ++n) {
                for (int j = n + 1; j <= this.sdSize.getLargeSide(); ++j) {
                    this.vi.clear();
                    this.vi.push(-this.variable(n, this.sdSize.getLargeSide() + 1 - n, i));
                    this.vi.push(-this.variable(j, this.sdSize.getLargeSide() + 1 - j, i));
                    clauseHandler.addClause(this.vi);
                }
            }
        }
    }

    void addOneColumnsSolver(ClauseHandler clauseHandler) {
        for (int i = 1; i <= this.sdSize.getLargeSide(); ++i) {
            this.addOneColumnSolver(i, clauseHandler);
        }
    }

    void addOneBlocksSolver(ClauseHandler clauseHandler) {
        for (int i = 1; i <= this.sdSize.getSmallCols(); ++i) {
            for (int j = 1; j <= this.sdSize.getSmallRows(); ++j) {
                this.addOneBlockSolver(i, j, clauseHandler);
            }
        }
    }

    void setSquareSolver(int n, int n2, int n3, ClauseHandler clauseHandler) {
        this.vi.clear();
        this.vi.push(this.variable(n, n2, n3));
        clauseHandler.addClause(this.vi);
    }

    void addSuDokuRules(ClauseHandler clauseHandler) {
        this.addOneSquaresSolver(clauseHandler);
        this.addOneBlocksSolver(clauseHandler);
        this.addOneRowsSolver(clauseHandler);
        this.addOneColumnsSolver(clauseHandler);
        if (this.gui.getUseXSudoku()) {
            this.addFallingDiagonalSolver(clauseHandler);
            this.addRisingDiagonalSolver(clauseHandler);
        }
    }

    public SuDoku(MainProgramWindow mainProgramWindow, int n, boolean bl) {
        this.mainProgramWindow = mainProgramWindow;
        this.createUniqueAllowed = bl;
        this.suDokuResources = new SuDokuResources();
        this.sdSize = new SDSize();
        this.gui = new GUIInput(mainProgramWindow, this.sdSize, this, n);
        this.solver = SolverFactory.newMiniLearning(20);
        this.randomCellChooser = new Random();
    }

    public GUIInput getGui() {
        return this.gui;
    }

    public boolean getCreateUniqueAllowed() {
        return this.createUniqueAllowed;
    }

    void checkSquares(CellGrid cellGrid) {
        for (int i = 1; i <= this.sdSize.getLargeSide() && this.passesCheck; ++i) {
            for (int j = 1; j <= this.sdSize.getLargeSide() && this.passesCheck; ++j) {
                int n = cellGrid.getIntValue(i, j);
                if (n >= 1 && n <= this.sdSize.getLargeSide()) continue;
                this.completed = false;
            }
        }
    }

    void checkBlock(CellGrid cellGrid, int[][] nArray, int[][] nArray2, int n, int n2) {
        block0: for (int i = 1; i <= this.sdSize.getLargeSide() - 1 && this.passesCheck; ++i) {
            for (int j = i + 1; j <= this.sdSize.getLargeSide() && this.passesCheck; ++j) {
                int n3 = (i - 1) / this.sdSize.getSmallCols() + 1;
                int n4 = (i - 1) % this.sdSize.getSmallCols() + 1;
                int n5 = (j - 1) / this.sdSize.getSmallCols() + 1;
                int n6 = (j - 1) % this.sdSize.getSmallCols() + 1;
                int n7 = n * this.sdSize.getSmallRows() + n3;
                int n8 = n2 * this.sdSize.getSmallCols() + n4;
                int n9 = n * this.sdSize.getSmallRows() + n5;
                int n10 = n2 * this.sdSize.getSmallCols() + n6;
                if (cellGrid.getIntValue(n7, n8) != 0 && cellGrid.getIntValue(n7, n8) == cellGrid.getIntValue(n9, n10)) {
                    cellGrid.highlight(n7, n8);
                    cellGrid.highlight(n9, n10);
                    this.passesCheck = false;
                    this.gui.setResult(this.suDokuResources.getStringFromKey("MSG_SAME_IN_BLOCK"));
                    continue block0;
                }
                if (!this.gui.getUseExtra()) continue;
                if (nArray[n7 - 1][n8 - 1] != 0 && nArray[n7 - 1][n8 - 1] == nArray[n9 - 1][n10 - 1]) {
                    cellGrid.highlight(n7, nArray[n7 - 1][n8 - 1]);
                    cellGrid.highlight(n9, nArray[n9 - 1][n10 - 1]);
                    this.passesCheck = false;
                    this.gui.setResult(this.suDokuResources.getStringFromKey("MSG_RELATED_IN_COLUMN"));
                    continue block0;
                }
                if (nArray2[n7 - 1][n8 - 1] == 0 || nArray2[n7 - 1][n8 - 1] != nArray2[n9 - 1][n10 - 1]) continue;
                cellGrid.highlight(nArray2[n7 - 1][n8 - 1], n8);
                cellGrid.highlight(nArray2[n9 - 1][n10 - 1], n10);
                this.passesCheck = false;
                this.gui.setResult(this.suDokuResources.getStringFromKey("MSG_RELATED_IN_ROW"));
                continue block0;
            }
        }
    }

    void checkBlocks(CellGrid cellGrid) {
        int n;
        int n2;
        int[][] nArray = null;
        int[][] nArray2 = null;
        if (this.gui.getUseExtra()) {
            nArray = new int[this.sdSize.getLargeSide()][this.sdSize.getLargeSide()];
            nArray2 = new int[this.sdSize.getLargeSide()][this.sdSize.getLargeSide()];
            for (n2 = 0; n2 < this.sdSize.getLargeSide(); ++n2) {
                for (n = 0; n < this.sdSize.getLargeSide(); ++n) {
                    nArray[n2][n] = 0;
                    nArray2[n2][n] = 0;
                }
            }
            for (n2 = 0; n2 < this.sdSize.getLargeSide(); ++n2) {
                for (n = 0; n < this.sdSize.getLargeSide(); ++n) {
                    int n3 = cellGrid.getIntValue(n2 + 1, n + 1);
                    if (n3 <= 0) continue;
                    nArray[n2][n3 - 1] = n + 1;
                    nArray2[n3 - 1][n] = n2 + 1;
                }
            }
        }
        for (n2 = 0; n2 < this.sdSize.getSmallCols() && this.passesCheck; ++n2) {
            for (n = 0; n < this.sdSize.getSmallRows() && this.passesCheck; ++n) {
                this.checkBlock(cellGrid, nArray, nArray2, n2, n);
            }
        }
    }

    void checkRow(CellGrid cellGrid, int n) {
        block0: for (int i = 1; i < this.sdSize.getLargeSide() && this.passesCheck; ++i) {
            for (int j = i + 1; j <= this.sdSize.getLargeSide() && this.passesCheck; ++j) {
                if (cellGrid.getIntValue(n, i) == 0 || cellGrid.getIntValue(n, i) != cellGrid.getIntValue(n, j)) continue;
                cellGrid.highlight(n, i);
                cellGrid.highlight(n, j);
                this.passesCheck = false;
                this.gui.setResult(this.suDokuResources.getStringFromKey("MSG_SAME_IN_ROW"));
                continue block0;
            }
        }
    }

    void checkRows(CellGrid cellGrid) {
        for (int i = 1; i <= this.sdSize.getLargeSide() && this.passesCheck; ++i) {
            this.checkRow(cellGrid, i);
        }
    }

    void checkColumn(CellGrid cellGrid, int n) {
        block0: for (int i = 1; i < this.sdSize.getLargeSide() && this.passesCheck; ++i) {
            for (int j = i + 1; j <= this.sdSize.getLargeSide() && this.passesCheck; ++j) {
                if (cellGrid.getIntValue(i, n) == 0 || cellGrid.getIntValue(i, n) != cellGrid.getIntValue(j, n)) continue;
                cellGrid.highlight(i, n);
                cellGrid.highlight(j, n);
                this.passesCheck = false;
                this.gui.setResult(this.suDokuResources.getStringFromKey("MSG_SAME_IN_COLUMN"));
                continue block0;
            }
        }
    }

    void checkFallingDiagonal(CellGrid cellGrid) {
        block0: for (int i = 1; i < this.sdSize.getLargeSide() && this.passesCheck; ++i) {
            for (int j = i + 1; j <= this.sdSize.getLargeSide() && this.passesCheck; ++j) {
                if (cellGrid.getIntValue(i, i) == 0 || cellGrid.getIntValue(i, i) != cellGrid.getIntValue(j, j)) continue;
                cellGrid.highlight(i, i);
                cellGrid.highlight(j, j);
                this.passesCheck = false;
                this.gui.setResult(this.suDokuResources.getStringFromKey("MSG_SAME_IN_FALLING_DIAGONAL"));
                continue block0;
            }
        }
    }

    void checkRisingDiagonal(CellGrid cellGrid) {
        block0: for (int i = 1; i < this.sdSize.getLargeSide() && this.passesCheck; ++i) {
            for (int j = i + 1; j <= this.sdSize.getLargeSide() && this.passesCheck; ++j) {
                if (cellGrid.getIntValue(i, this.sdSize.getLargeSide() + 1 - i) == 0 || cellGrid.getIntValue(i, this.sdSize.getLargeSide() + 1 - i) != cellGrid.getIntValue(j, this.sdSize.getLargeSide() + 1 - j)) continue;
                cellGrid.highlight(i, this.sdSize.getLargeSide() + 1 - i);
                cellGrid.highlight(j, this.sdSize.getLargeSide() + 1 - j);
                this.passesCheck = false;
                this.gui.setResult(this.suDokuResources.getStringFromKey("MSG_SAME_IN_RISING_DIAGONAL"));
                continue block0;
            }
        }
    }

    void checkColumns(CellGrid cellGrid) {
        for (int i = 1; i <= this.sdSize.getLargeSide() && this.passesCheck; ++i) {
            this.checkColumn(cellGrid, i);
        }
    }

    public void checkSolution(CellGrid cellGrid) {
        this.passesCheck = true;
        this.completed = true;
        cellGrid.unHighlightAll();
        this.checkSquares(cellGrid);
        if (this.passesCheck) {
            this.checkBlocks(cellGrid);
        }
        if (this.passesCheck) {
            this.checkRows(cellGrid);
        }
        if (this.passesCheck) {
            this.checkColumns(cellGrid);
        }
        if (this.passesCheck && this.gui.getUseXSudoku()) {
            this.checkFallingDiagonal(cellGrid);
            this.checkRisingDiagonal(cellGrid);
        }
        if (this.passesCheck) {
            if (this.completed) {
                this.gui.setResult(this.suDokuResources.getStringFromKey("MSG_CORRECT_SUDOKU"));
                JOptionPane.showMessageDialog(null, this.suDokuResources.getStringFromKey("MSG_CORRECT_SUDOKU"));
            } else {
                this.gui.setResult(this.suDokuResources.getStringFromKey("MSG_NO_BROKEN_RULES"));
                JOptionPane.showMessageDialog(null, this.suDokuResources.getStringFromKey("MSG_NO_BROKEN_RULES"));
            }
        }
    }

    public void graphicalSolveOneCell(CellGrid cellGrid, int n, int n2) throws Exception {
        boolean bl = false;
        System.gc();
        this.fullCNF = true;
        StringBuffer stringBuffer = new StringBuffer("s SATISFIABLE\n");
        this.clauses = 0;
        this.solver = SolverFactory.newMiniLearning();
        Sat4jClauseHandler sat4jClauseHandler = new Sat4jClauseHandler(this.numOfVariables(), this.solver);
        this.addSuDokuRules(sat4jClauseHandler);
        this.readPuzzleSolver(cellGrid, sat4jClauseHandler);
        sat4jClauseHandler.finish();
        this.gui.setResult("");
        try {
            if (this.solver.isSatisfiable()) {
                int[] nArray = this.solver.model();
                for (int i = 0; i < nArray.length; ++i) {
                    if (bl) {
                        stringBuffer.append("v " + nArray[i] + "\n");
                    }
                    if (nArray[i] <= 0 || nArray[i] % this.sdSize.getBase() == 0 || nArray[i] / this.sdSize.getBase2() != n || nArray[i] % this.sdSize.getBase2() / this.sdSize.getBase() != n2) continue;
                    this.gui.getCellGrid().solverSetIntValue(nArray[i] / this.sdSize.getBase2(), nArray[i] % this.sdSize.getBase2() / this.sdSize.getBase(), nArray[i] % this.sdSize.getBase());
                }
                if (bl) {
                    stringBuffer.append("v 0\n");
                    this.gui.setCNFModel(stringBuffer.toString());
                }
            } else {
                this.gui.setResult("Cannot be solved");
                if (bl) {
                    this.gui.setCNFModel("s UNSATISFIABLE");
                }
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.gc();
            this.gui.setResult("Increased Java Heap size required");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void randomCellHint(CellGrid cellGrid) {
        try {
            int n;
            int n2;
            int n3 = this.sdSize.getLargeSide() * this.sdSize.getLargeSide();
            for (n2 = 1; n2 <= this.sdSize.getLargeSide(); ++n2) {
                for (n = 1; n <= this.sdSize.getLargeSide(); ++n) {
                    if (cellGrid.getIntValue(n2, n) == 0) continue;
                    --n3;
                }
            }
            n2 = this.randomCellChooser.nextInt(n3);
            n = -1;
            int n4 = 1;
            int n5 = 1;
            for (int i = 1; i <= this.sdSize.getLargeSide() && n < n2; ++i) {
                for (int j = 1; j <= this.sdSize.getLargeSide() && n < n2; ++j) {
                    if (cellGrid.getIntValue(i, j) != 0 || ++n != n2) continue;
                    n4 = i;
                    n5 = j;
                }
            }
            this.graphicalSolveOneCell(cellGrid, n4, n5);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void graphicalSolve(CellGrid cellGrid, boolean bl) throws Exception {
        System.gc();
        this.fullCNF = true;
        StringBuffer stringBuffer = new StringBuffer("s SATISFIABLE\n");
        this.clauses = 0;
        this.solver = SolverFactory.newMiniLearning();
        Sat4jClauseHandler sat4jClauseHandler = new Sat4jClauseHandler(this.numOfVariables(), this.solver);
        this.addSuDokuRules(sat4jClauseHandler);
        this.readPuzzleSolver(cellGrid, sat4jClauseHandler);
        sat4jClauseHandler.finish();
        this.gui.setResult("");
        try {
            if (this.solver.isSatisfiable()) {
                int[] nArray = this.solver.model();
                for (int i = 0; i < nArray.length; ++i) {
                    if (bl) {
                        stringBuffer.append("v " + nArray[i] + "\n");
                    }
                    if (nArray[i] <= 0 || nArray[i] % this.sdSize.getBase() == 0) continue;
                    this.gui.getCellGrid().solverSetIntValue(nArray[i] / this.sdSize.getBase2(), nArray[i] % this.sdSize.getBase2() / this.sdSize.getBase(), nArray[i] % this.sdSize.getBase());
                }
                if (bl) {
                    stringBuffer.append("v 0\n");
                    this.gui.setCNFModel(stringBuffer.toString());
                }
            } else {
                this.gui.setResult("Cannot be solved");
                if (bl) {
                    this.gui.setCNFModel("s UNSATISFIABLE");
                }
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.gc();
            this.gui.setResult("Increased Java Heap size required");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void simplerCNF(CellGrid cellGrid) {
        System.gc();
        this.fullCNF = false;
        StringClauseHandler stringClauseHandler = new StringClauseHandler(this.numOfVariables());
        this.addSuDokuRules(stringClauseHandler);
        this.readPuzzleSolver(cellGrid, stringClauseHandler);
        stringClauseHandler.finish();
        this.gui.setCNFFile(stringClauseHandler.toString());
        this.gui.setResult("cnf available for solving");
    }

    public void fullCNF(CellGrid cellGrid) {
        System.gc();
        this.fullCNF = true;
        StringClauseHandler stringClauseHandler = new StringClauseHandler(this.numOfVariables());
        this.addSuDokuRules(stringClauseHandler);
        this.readPuzzleSolver(cellGrid, stringClauseHandler);
        stringClauseHandler.finish();
        this.gui.setCNFFile(stringClauseHandler.toString());
        this.gui.setResult("cnf available for solving");
    }

    public void parseLine(String string, CellGrid cellGrid) {
        if (string.length() > 0 && string.charAt(0) == 'v') {
            WordScanner wordScanner = new WordScanner(string);
            wordScanner.next();
            while (wordScanner.hasNext()) {
                String string2 = wordScanner.next();
                try {
                    int n = Integer.parseInt(string2);
                    if (n <= 0 || n % this.sdSize.getBase() <= 0) continue;
                    cellGrid.solverSetIntValue(n / this.sdSize.getBase2(), n % this.sdSize.getBase2() / this.sdSize.getBase(), n % this.sdSize.getBase());
                }
                catch (Exception exception) {}
            }
            wordScanner.close();
        }
    }

    public void interpretModel(CellGrid cellGrid) {
        LineScanner lineScanner = new LineScanner(this.gui.getCNFModel());
        while (lineScanner.hasNext()) {
            this.parseLine(lineScanner.next(), cellGrid);
        }
        lineScanner.close();
    }

    public void createPuzzle(int n, CellGrid cellGrid, boolean bl) {
        int n2;
        Object object;
        Object object2;
        System.gc();
        int[][] nArray = new int[this.sdSize.getLargeSide() + 1][this.sdSize.getLargeSide() + 1];
        int[][] nArray2 = new int[this.sdSize.getLargeSide() + 1][this.sdSize.getLargeSide() + 1];
        cellGrid.clearAll();
        boolean bl2 = false;
        this.fullCNF = true;
        ProgressMonitor progressMonitor = new ProgressMonitor(null, this.suDokuResources.getStringFromKey("MSG_PROGRESS_DIALOG"), "", 0, this.sdSize.getLargeSide() * this.sdSize.getLargeSide() / 2);
        progressMonitor.setProgress(0);
        while (!bl2) {
            Solver<ILits2, DataStructureFactory<ILits2>> solver = SolverFactory.newMiniLearning2Heap();
            object2 = new Sat4jClauseHandler(this.numOfVariables(), solver);
            this.addSuDokuRules((ClauseHandler)object2);
            object = new CoordinateSet(this.sdSize.getLargeSide(), this.sdSize.getLargeSide());
            n2 = this.sdSize.getLargeSide();
            for (int i = 1; i <= n2; ++i) {
                Coordinate coordinate = ((CoordinateSet)object).getCoordinate();
                this.vi.clear();
                this.vi.push(this.variable(coordinate.getRow(), coordinate.getColumn(), i));
                ((Sat4jClauseHandler)object2).addClause(this.vi);
            }
            ((Sat4jClauseHandler)object2).finish();
            try {
                if (!solver.isSatisfiable()) continue;
                bl2 = true;
                int[] nArray3 = solver.model();
                for (int i = 0; i < nArray3.length; ++i) {
                    if (nArray3[i] <= 0 || nArray3[i] % this.sdSize.getBase() == 0) continue;
                    nArray[nArray3[i] / this.sdSize.getBase2()][nArray3[i] % this.sdSize.getBase2() / this.sdSize.getBase()] = nArray3[i] % this.sdSize.getBase();
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.gui.setResult("Increased Java Heap size required");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        object2 = new CoordinateSet(this.sdSize.getLargeSide(), this.sdSize.getLargeSide());
        object = this.gui.getUseExtra() ? new RandomPermutation(this.sdSize.getSmallRows(), this.sdSize.getSmallCols()) : new RandomPermutation(this.sdSize.getLargeSide());
        for (n2 = 1; n2 <= this.sdSize.getLargeSide(); ++n2) {
            for (int i = 1; i <= this.sdSize.getLargeSide(); ++i) {
                nArray[n2][i] = ((RandomPermutation)object).permute(nArray[n2][i]);
            }
        }
        n2 = n;
        if (bl) {
            n2 = 0;
            try {
                int n3;
                Solver<ILits, DataStructureFactory<ILits>> solver = SolverFactory.newBackjumping();
                Sat4jClauseHandler sat4jClauseHandler = new Sat4jClauseHandler(this.numOfVariables(), solver);
                this.addSuDokuRules(sat4jClauseHandler);
                this.vi.clear();
                for (n3 = 1; n3 <= this.sdSize.getLargeSide(); ++n3) {
                    for (int i = 1; i <= this.sdSize.getLargeSide(); ++i) {
                        this.vi.push(-this.variable(n3, i, nArray[n3][i]));
                    }
                }
                sat4jClauseHandler.addClause(this.vi);
                n3 = 0;
                SortedCoordinateSet sortedCoordinateSet = new SortedCoordinateSet(this.sdSize.getLargeSide(), this.sdSize.getLargeSide(), this.sdSize.getSmallRows(), this.sdSize.getSmallCols(), nArray);
                int n4 = 0;
                while (n3 == 0) {
                    if (solver.isSatisfiable()) {
                        int n5;
                        int n6;
                        if (progressMonitor.isCanceled()) break;
                        progressMonitor.setProgress(n4 + 1);
                        int[] nArray4 = solver.model();
                        for (n6 = 0; n6 < nArray4.length; ++n6) {
                            int n7;
                            if (nArray4[n6] <= 0) continue;
                            int n8 = nArray4[n6] / this.sdSize.getBase2();
                            n5 = nArray4[n6] % this.sdSize.getBase2() / this.sdSize.getBase();
                            nArray2[n8][n5] = n7 = nArray4[n6] % this.sdSize.getBase();
                        }
                        n6 = 0;
                        Coordinate[] coordinateArray = sortedCoordinateSet.getAll();
                        n5 = 0;
                        while (n6 == 0) {
                            int n9;
                            Coordinate coordinate = coordinateArray[n5];
                            int n10 = coordinate.getRow();
                            if (nArray[n10][n9 = coordinate.getColumn()] != nArray2[n10][n9]) {
                                sortedCoordinateSet.note(coordinate);
                                cellGrid.setIntValue(n10, n9, nArray[n10][n9]);
                                ++n2;
                                n6 = 1;
                                ++n4;
                                this.vi.clear();
                                this.vi.push(this.variable(n10, n9, nArray[n10][n9]));
                                try {
                                    sat4jClauseHandler.addClauseUnTrapped(this.vi);
                                }
                                catch (ContradictionException contradictionException) {
                                    n3 = 1;
                                }
                            }
                            ++n5;
                        }
                        continue;
                    }
                    n3 = 1;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            int n11;
            for (n11 = 0; n11 < n2 / 4; ++n11) {
                Coordinate[] coordinateArray = ((CoordinateSet)object2).getGroup();
                for (int i = 0; i < 4; ++i) {
                    cellGrid.setIntValue(coordinateArray[i].getRow(), coordinateArray[i].getColumn(), nArray[coordinateArray[i].getRow()][coordinateArray[i].getColumn()]);
                }
            }
            for (n11 = 0; n11 < n2 % 4; ++n11) {
                Coordinate coordinate = ((CoordinateSet)object2).getCoordinate();
                cellGrid.setIntValue(coordinate.getRow(), coordinate.getColumn(), nArray[coordinate.getRow()][coordinate.getColumn()]);
            }
        }
        if (progressMonitor.isCanceled()) {
            cellGrid.clearAll();
        } else {
            this.gui.setFillCount(n2);
            this.gui.setProtection(true);
        }
        progressMonitor.close();
    }

    static class StringClauseHandler
    implements ClauseHandler {
        StringBuffer buffer = new StringBuffer();
        String string;
        int clauses;
        int variables;

        StringClauseHandler(int n) {
            this.variables = n;
            this.clauses = 0;
        }

        public void addClause(VecInt vecInt) {
            for (int i = 0; i < vecInt.size(); ++i) {
                this.buffer.append(vecInt.get(i) + " ");
            }
            this.buffer.append("0\n");
            ++this.clauses;
        }

        public void finish() {
            this.string = "p cnf " + this.variables + " " + this.clauses + "\n" + this.buffer.toString();
        }

        public String toString() {
            return this.string;
        }
    }

    static class Sat4jClauseHandler
    implements ClauseHandler {
        ISolver solver;

        Sat4jClauseHandler(int n, ISolver iSolver) {
            this.solver = iSolver;
            iSolver.newVar(n);
        }

        public void addClause(VecInt vecInt) {
            try {
                this.solver.addClause(vecInt);
            }
            catch (ContradictionException contradictionException) {
                // empty catch block
            }
        }

        public void addClauseUnTrapped(VecInt vecInt) throws ContradictionException {
            this.solver.addClause(vecInt);
        }

        public void finish() {
        }
    }

    static interface ClauseHandler {
        public void addClause(VecInt var1);

        public void finish();
    }
}

