/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.apps.sudoku;

import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;

public class SuDokuResources {
    boolean iconsLoaded = false;
    ImageIcon sat4jIcon;
    ImageIcon ecitIcon;
    ImageIcon crilIcon;
    ImageIcon objectWebIcon;
    ImageIcon eventIcon;
    ResourceBundle resourceBundle;

    public SuDokuResources() {
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.sat4j.apps.sudoku.sudoku");
        }
        catch (Exception exception) {
            System.out.println(" Exception in ResourceBundle.getBundle() ");
            exception.printStackTrace();
            System.exit(0);
        }
        this.iconsLoaded = false;
    }

    public URL getURLFromKey(String string) {
        String string2 = this.resourceBundle.getString(string);
        return this.getClass().getResource(string2);
    }

    public String getStringFromKey(String string) {
        String string2 = this.resourceBundle.getString(string);
        return string2 == null ? "" : string2;
    }

    public String getParsedProperty(String string) {
        String string2 = System.getProperties().getProperty(string);
        if (string2 == null) {
            return "";
        }
        return this.checkForEscapes(string2);
    }

    boolean isHex(char c) {
        return '0' <= c && c <= '9' || 'A' <= c && c <= 'F' || 'a' <= c && c <= 'f';
    }

    int hexValue(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('A' <= c && c <= 'F') {
            return 10 + c - 65;
        }
        return 10 + c - 97;
    }

    String checkForEscapes(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\\') {
                if (++n >= string.length()) continue;
                char c2 = string.charAt(n);
                switch (c2) {
                    case 'n': {
                        stringBuffer.append('\n');
                        ++n;
                        break;
                    }
                    case 't': {
                        stringBuffer.append('\t');
                        ++n;
                        break;
                    }
                    case 'u': {
                        int n2;
                        char c3 = '\u0000';
                        boolean bl = true;
                        ++n;
                        for (n2 = 0; bl && n2 < 4; ++n2) {
                            bl = this.isHex(string.charAt(n + n2));
                            if (!bl) continue;
                            c3 = (char)(16 * c3 + this.hexValue(string.charAt(n + n2)));
                        }
                        stringBuffer.append(c3);
                        n += n2;
                        break;
                    }
                    default: {
                        stringBuffer.append(c2);
                        ++n;
                        break;
                    }
                }
                continue;
            }
            stringBuffer.append(c);
            ++n;
        }
        return stringBuffer.toString();
    }

    ImageIcon getSat4jIcon() {
        this.ensureIcons();
        return this.sat4jIcon;
    }

    ImageIcon getECITIcon() {
        this.ensureIcons();
        return this.ecitIcon;
    }

    ImageIcon getCRILIcon() {
        this.ensureIcons();
        return this.crilIcon;
    }

    ImageIcon getObjectWebIcon() {
        this.ensureIcons();
        return this.objectWebIcon;
    }

    ImageIcon getEventIcon() {
        this.ensureIcons();
        return this.eventIcon;
    }

    void ensureIcons() {
        if (!this.iconsLoaded) {
            URL uRL = this.getURLFromKey("ICON_SAT4J");
            this.sat4jIcon = new ImageIcon(uRL);
            URL uRL2 = this.getURLFromKey("ICON_ECIT");
            this.ecitIcon = new ImageIcon(uRL2);
            URL uRL3 = this.getURLFromKey("ICON_CRIL");
            this.crilIcon = new ImageIcon(uRL3);
            URL uRL4 = this.getURLFromKey("ICON_OBJECT_WEB");
            this.objectWebIcon = new ImageIcon(uRL4);
            URL uRL5 = this.getURLFromKey("ICON_EVENT");
            this.eventIcon = new ImageIcon(uRL5);
            this.iconsLoaded = true;
        }
    }

    public ImageIcon getIconFromKey(String string) {
        try {
            URL uRL = this.getURLFromKey("ICON_" + string);
            if (uRL == null) {
                return null;
            }
            return new ImageIcon(uRL);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }
}

