/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.apps.sudoku;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.sat4j.apps.sudoku.CellStatus;
import org.sat4j.apps.sudoku.GUIInput;
import org.sat4j.apps.sudoku.OneCell;

public class TextualOneCell
extends JTextField
implements ActionListener,
OneCell {
    int max;
    boolean protcted;
    GUIInput guiInput;
    CellStatus status;
    Color[] colors;
    static Color[] nullColors = new Color[]{Color.BLACK, Color.WHITE, Color.RED, Color.WHITE, Color.RED, Color.WHITE};
    JPopupMenu popup;
    private static SudokuRenderer renderer = new ClassicRenderer();
    public static SudokuRenderer CLASSIC_RENDERER = new ClassicRenderer();
    public static SudokuRenderer HEXA_RENDERER = new HexaRenderer();
    public static SudokuRenderer OCTAL_RENDERER = new OctalRenderer();
    public static SudokuRenderer BINARY_RENDERER = new BinaryRenderer();
    public static SudokuRenderer LETTER_RENDERER = new LetterRenderer();

    public TextualOneCell(GUIInput gUIInput, Color[] colorArray) {
        super(2);
        this.guiInput = gUIInput;
        this.status = CellStatus.USER_ENTERED;
        this.colors = colorArray;
        this.setFont(this.getFont().deriveFont(1, 18.0f));
        this.setHorizontalAlignment(0);
        this.unHighlight();
    }

    public TextualOneCell() {
        this(null, nullColors);
    }

    public void protect() {
        this.protcted = true;
        this.setStatus(CellStatus.PROTECTED);
    }

    public void protectIfNotClear() {
        if (this.getText().length() > 0) {
            this.protect();
        }
    }

    public boolean getProtected() {
        return this.protcted;
    }

    public void clearProtection() {
        this.protcted = false;
        this.setEditable(true);
        this.setStatus(CellStatus.USER_ENTERED);
    }

    public TextualOneCell(int n, GUIInput gUIInput, Color[] colorArray) {
        this(gUIInput, colorArray);
        this.max = n;
        this.protcted = false;
        this.updateContextualMenu();
        PopupListener popupListener = new PopupListener();
        this.addMouseListener(popupListener);
    }

    public void setColors(Color[] colorArray) {
        this.colors = colorArray;
        this.refresh();
    }

    public TextualOneCell(int n) {
        this(n, null, nullColors);
    }

    public void setMax(int n) {
        this.max = n;
    }

    public String getaText() {
        return this.getText();
    }

    public int getIntValue() {
        int n = 0;
        if (this.getText().length() != 0) {
            try {
                n = renderer.parseInt(this.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    public void setIntValue(int n) {
        if (!this.protcted) {
            this.setText(renderer.intToString(n));
        }
    }

    public void setIntValue(String string) {
        if (!this.protcted) {
            this.setText(string);
        }
    }

    public void solverSetIntValue(int n) {
        if (!this.protcted && this.getText().equals("")) {
            this.setText(renderer.intToString(n));
            this.setStatus(CellStatus.SOLVER_ENTERED);
        }
    }

    public static void setRenderer(SudokuRenderer sudokuRenderer) {
        renderer = sudokuRenderer;
    }

    public void clear() {
        this.unHighlight();
        if (!this.protcted) {
            this.setText("");
            this.setStatus(CellStatus.USER_ENTERED);
        }
    }

    public void clearComputers() {
        this.unHighlight();
        if (!this.protcted && this.status == CellStatus.SOLVER_ENTERED) {
            this.setText("");
            this.setStatus(CellStatus.USER_ENTERED);
        }
    }

    public void highlight() {
        this.setBackground(this.colors[2]);
    }

    public void unHighlight() {
        this.setStatus(this.status);
    }

    public void refresh() {
        this.setStatus(this.status);
    }

    public void setStatus(CellStatus cellStatus) {
        this.status = cellStatus;
        switch (cellStatus) {
            case PROTECTED: {
                this.setBackground(this.colors[5]);
                this.setForeground(this.colors[4]);
                this.setToolTipText(this.guiInput.suDokuResources.getStringFromKey("TOOLTIP_CELL_PROTECTED"));
                break;
            }
            case USER_ENTERED: {
                this.setForeground(this.colors[0]);
                this.setBackground(this.colors[5]);
                this.setToolTipText(this.guiInput.suDokuResources.getStringFromKey("TOOLTIP_CELL_NOT_PROTECTED_TEXT"));
                break;
            }
            case SOLVER_ENTERED: {
                this.setForeground(this.colors[1]);
                this.setBackground(this.colors[5]);
                this.setToolTipText(this.guiInput.suDokuResources.getStringFromKey("TOOLTIP_CELL_COMPUTER"));
            }
        }
    }

    public CellStatus getStatus() {
        return this.status;
    }

    public static int getNumberOfColours() {
        return 6;
    }

    protected Document createDefaultModel() {
        return new BoundedIntegerDocument();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = ((JMenuItem)actionEvent.getSource()).getText();
        this.setIntValue(string);
        this.refresh();
    }

    public void updateContextualMenu() {
        this.popup = new JPopupMenu();
        for (int i = 1; i <= this.max; ++i) {
            JMenuItem jMenuItem = new JMenuItem(renderer.intToString(i));
            jMenuItem.addActionListener(this);
            this.popup.add(jMenuItem);
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
            TextualOneCell.this.refresh();
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (!TextualOneCell.this.protcted && mouseEvent.isPopupTrigger()) {
                TextualOneCell.this.setBackground(Color.DARK_GRAY);
                TextualOneCell.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public class BoundedIntegerDocument
    extends PlainDocument {
        BoundedIntegerDocument() {
        }

        public void remove(int n, int n2) throws BadLocationException {
            if (TextualOneCell.this.status != CellStatus.PROTECTED) {
                super.remove(n, n2);
            }
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null || TextualOneCell.this.status == CellStatus.PROTECTED) {
                return;
            }
            string = string.toUpperCase();
            TextualOneCell.this.unHighlight();
            if (n == 0 && string.length() == 0) {
                TextualOneCell.this.setStatus(CellStatus.USER_ENTERED);
                super.insertString(n, string, attributeSet);
                return;
            }
            boolean bl = false;
            try {
                int n2 = renderer.parseInt(TextualOneCell.this.getaText() + string);
                boolean bl2 = bl = n2 >= 1 && n2 <= TextualOneCell.this.max;
                if (bl) {
                    TextualOneCell.this.setStatus(CellStatus.USER_ENTERED);
                    super.insertString(n, string, attributeSet);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static class LetterRenderer
    implements SudokuRenderer {
        LetterRenderer() {
        }

        public String intToString(int n) {
            return Character.toString((char)(65 + n - 1));
        }

        public int parseInt(String string) throws NumberFormatException {
            if (string.length() == 0 || string.length() > 1) {
                throw new NumberFormatException();
            }
            char c = string.charAt(0);
            return '\u0001' + c - 65;
        }

        public String toString() {
            return "LETTER";
        }
    }

    static class BinaryRenderer
    implements SudokuRenderer {
        BinaryRenderer() {
        }

        public String intToString(int n) {
            return Integer.toBinaryString(n);
        }

        public int parseInt(String string) throws NumberFormatException {
            return Integer.parseInt(string, 2);
        }

        public String toString() {
            return "BINARY";
        }
    }

    static class OctalRenderer
    implements SudokuRenderer {
        OctalRenderer() {
        }

        public String intToString(int n) {
            return Integer.toOctalString(n).toUpperCase();
        }

        public int parseInt(String string) throws NumberFormatException {
            return Integer.parseInt(string, 8);
        }

        public String toString() {
            return "OCTAL";
        }
    }

    static class HexaRenderer
    implements SudokuRenderer {
        HexaRenderer() {
        }

        public String intToString(int n) {
            return Integer.toHexString(n).toUpperCase();
        }

        public int parseInt(String string) throws NumberFormatException {
            return Integer.parseInt(string, 16);
        }

        public String toString() {
            return "HEXA";
        }
    }

    static class ClassicRenderer
    implements SudokuRenderer {
        ClassicRenderer() {
        }

        public String intToString(int n) {
            return Integer.toString(n);
        }

        public int parseInt(String string) throws NumberFormatException {
            return Integer.parseInt(string);
        }

        public String toString() {
            return "CLASSIC";
        }
    }

    static interface SudokuRenderer {
        public String intToString(int var1);

        public int parseInt(String var1);
    }
}

