/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.cnf;

import java.io.Serializable;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.IVecInt;

public class BinaryClauses
implements Constr,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ILits voc;
    private final IVecInt clauses = new VecInt();
    private final int reason;
    private int conflictindex = -1;

    public BinaryClauses(ILits iLits, int n) {
        this.voc = iLits;
        this.reason = n;
    }

    public void addBinaryClause(int n) {
        this.clauses.push(n);
    }

    public void remove() {
    }

    public boolean propagate(UnitPropagationListener unitPropagationListener, int n) {
        assert (this.voc.isFalsified(this.reason));
        this.voc.watch(n, this);
        for (int i = 0; i < this.clauses.size(); ++i) {
            int n2 = this.clauses.get(i);
            if (unitPropagationListener.enqueue(n2, this)) continue;
            this.conflictindex = i;
            return false;
        }
        return true;
    }

    public boolean simplify() {
        IVecInt iVecInt = this.clauses;
        int n = this.clauses.size();
        for (int i = 0; i < n; ++i) {
            if (this.voc.isSatisfied(iVecInt.get(i))) {
                return true;
            }
            if (!this.voc.isFalsified(iVecInt.get(i))) continue;
            iVecInt.delete(i);
        }
        return false;
    }

    public void undo(int n) {
    }

    public void calcReason(int n, IVecInt iVecInt) {
        iVecInt.push(this.reason ^ 1);
        if (n == -1) {
            assert (this.conflictindex > -1);
            iVecInt.push(this.clauses.get(this.conflictindex) ^ 1);
        }
    }

    public boolean learnt() {
        return false;
    }

    public void incActivity(double d) {
    }

    public double getActivity() {
        return 0.0;
    }

    public boolean locked() {
        return false;
    }

    public void setLearnt() {
    }

    public void register() {
    }

    public void rescaleBy(double d) {
    }

    public int size() {
        return this.clauses.size();
    }

    public int get(int n) {
        throw new UnsupportedOperationException();
    }

    public void assertConstraint(UnitPropagationListener unitPropagationListener) {
        throw new UnsupportedOperationException();
    }
}

