/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Scanner;
import java.util.StringTokenizer;
import org.sat4j.core.VecInt;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;

public class DimacsReader
extends Reader
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected int expectedNbOfConstr;
    protected final ISolver solver;
    private boolean checkConstrNb = true;
    protected final String formatString;

    public DimacsReader(ISolver iSolver) {
        this(iSolver, "cnf");
    }

    public DimacsReader(ISolver iSolver, String string) {
        this.solver = iSolver;
        this.formatString = string;
    }

    public void disableNumberOfConstraintCheck() {
        this.checkConstrNb = false;
    }

    protected void skipComments(LineNumberReader lineNumberReader) throws IOException {
        int n;
        do {
            lineNumberReader.mark(4);
            n = lineNumberReader.read();
            if (n == 99) {
                lineNumberReader.readLine();
                continue;
            }
            lineNumberReader.reset();
        } while (n == 99);
    }

    protected void readProblemLine(LineNumberReader lineNumberReader) throws IOException, ParseFormatException {
        String string = lineNumberReader.readLine();
        if (string == null) {
            throw new ParseFormatException("premature end of file: <p cnf ...> expected  on line " + lineNumberReader.getLineNumber());
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (!(stringTokenizer.hasMoreTokens() && stringTokenizer.nextToken().equals("p") && stringTokenizer.hasMoreTokens() && stringTokenizer.nextToken().equals(this.formatString))) {
            throw new ParseFormatException("problem line expected (p cnf ...) on line " + lineNumberReader.getLineNumber());
        }
        int n = Integer.parseInt(stringTokenizer.nextToken());
        assert (n > 0);
        this.solver.newVar(n);
        this.expectedNbOfConstr = Integer.parseInt(stringTokenizer.nextToken());
        assert (this.expectedNbOfConstr > 0);
        this.solver.setExpectedNumberOfClauses(this.expectedNbOfConstr);
    }

    protected void readConstrs(LineNumberReader lineNumberReader) throws IOException, ParseFormatException, ContradictionException {
        int n = 0;
        VecInt vecInt = new VecInt();
        while (true) {
            String string;
            if ((string = lineNumberReader.readLine()) == null) {
                if (vecInt.size() <= 0) break;
                this.solver.addClause(vecInt);
                ++n;
                break;
            }
            if (string.startsWith("c ")) continue;
            if (string.startsWith("%") && this.expectedNbOfConstr == n) {
                System.out.println("Ignoring the rest of the file (SATLIB format");
                break;
            }
            boolean bl = this.handleConstr(string, vecInt);
            if (!bl) continue;
            ++n;
        }
        if (this.checkConstrNb && this.expectedNbOfConstr != n) {
            throw new ParseFormatException("wrong nbclauses parameter. Found " + n + ", " + this.expectedNbOfConstr + " expected");
        }
    }

    protected boolean handleConstr(String string, IVecInt iVecInt) throws ContradictionException {
        boolean bl = false;
        Scanner scanner = new Scanner(string);
        while (scanner.hasNext()) {
            int n = scanner.nextInt();
            if (n == 0) {
                if (iVecInt.size() <= 0) continue;
                this.solver.addClause(iVecInt);
                iVecInt.clear();
                bl = true;
                continue;
            }
            iVecInt.push(n);
        }
        return bl;
    }

    public final IProblem parseInstance(java.io.Reader reader) throws ParseFormatException, ContradictionException, IOException {
        return this.parseInstance(new LineNumberReader(reader));
    }

    private IProblem parseInstance(LineNumberReader lineNumberReader) throws ParseFormatException, ContradictionException {
        this.solver.reset();
        try {
            this.skipComments(lineNumberReader);
            this.readProblemLine(lineNumberReader);
            this.readConstrs(lineNumberReader);
            return this.solver;
        }
        catch (IOException iOException) {
            throw new ParseFormatException(iOException);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseFormatException("integer value expected on line " + lineNumberReader.getLineNumber(), numberFormatException);
        }
    }

    public String decode(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(nArray[i]);
            stringBuffer.append(" ");
        }
        stringBuffer.append("0");
        return stringBuffer.toString();
    }

    public void decode(int[] nArray, PrintWriter printWriter) {
        for (int i = 0; i < nArray.length; ++i) {
            printWriter.print(nArray[i]);
            printWriter.print(" ");
        }
        printWriter.print("0");
    }

    protected ISolver getSolver() {
        return this.solver;
    }
}

