/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Map;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.specs.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DimacsOutputSolver
implements ISolver {
    private static final long serialVersionUID = 1L;
    private transient PrintWriter out;
    private int nbvars;
    private int nbclauses;
    private boolean fixedNbClauses = false;
    private boolean firstConstr = true;

    public DimacsOutputSolver() {
        this(new PrintWriter(System.out, true));
    }

    public DimacsOutputSolver(PrintWriter printWriter) {
        this.out = printWriter;
    }

    private void readObject(ObjectInputStream objectInputStream) {
        this.out = new PrintWriter(System.out, true);
    }

    @Override
    public int newVar() {
        return 0;
    }

    @Override
    public int newVar(int n) {
        this.out.print("p cnf " + n);
        this.nbvars = n;
        return 0;
    }

    @Override
    public void setExpectedNumberOfClauses(int n) {
        this.out.println(" " + n);
        this.nbclauses = n;
        this.fixedNbClauses = true;
    }

    @Override
    public IConstr addClause(IVecInt iVecInt) throws ContradictionException {
        if (this.firstConstr) {
            if (!this.fixedNbClauses) {
                this.out.println(" XXXXXX");
            }
            this.firstConstr = false;
        }
        IteratorInt iteratorInt = iVecInt.iterator();
        while (iteratorInt.hasNext()) {
            this.out.print(iteratorInt.next() + " ");
        }
        this.out.println("0");
        return null;
    }

    @Override
    public boolean removeConstr(IConstr iConstr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addAllClauses(IVec<IVecInt> iVec) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstr addAtMost(IVecInt iVecInt, int n) throws ContradictionException {
        if (n > 1) {
            throw new UnsupportedOperationException("Not a clausal problem! degree " + n);
        }
        assert (n == 1);
        if (this.firstConstr) {
            if (!this.fixedNbClauses) {
                this.out.println("XXXXXX");
            }
            this.firstConstr = false;
        }
        for (int i = 0; i <= iVecInt.size(); ++i) {
            for (int j = i + 1; j < iVecInt.size(); ++j) {
                this.out.println("" + -iVecInt.get(i) + " " + -iVecInt.get(j) + " 0");
            }
        }
        return null;
    }

    @Override
    public IConstr addAtLeast(IVecInt iVecInt, int n) throws ContradictionException {
        if (n > 1) {
            throw new UnsupportedOperationException("Not a clausal problem! degree " + n);
        }
        assert (n == 1);
        return this.addClause(iVecInt);
    }

    @Override
    public void setTimeout(int n) {
    }

    @Override
    public void setTimeoutMs(long l) {
    }

    @Override
    public int getTimeout() {
        return 0;
    }

    @Override
    public void reset() {
        this.fixedNbClauses = false;
        this.firstConstr = true;
    }

    @Override
    public void printStat(PrintStream printStream, String string) {
    }

    @Override
    public void printStat(PrintWriter printWriter, String string) {
    }

    @Override
    public Map<String, Number> getStat() {
        return null;
    }

    @Override
    public String toString(String string) {
        return "Dimacs output solver";
    }

    @Override
    public void clearLearntClauses() {
    }

    @Override
    public int[] model() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean model(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSatisfiable() throws TimeoutException {
        throw new TimeoutException("There is no real solver behind!");
    }

    @Override
    public boolean isSatisfiable(IVecInt iVecInt) throws TimeoutException {
        throw new TimeoutException("There is no real solver behind!");
    }

    @Override
    public int[] findModel() throws TimeoutException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] findModel(IVecInt iVecInt) throws TimeoutException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int nConstraints() {
        return this.nbclauses;
    }

    @Override
    public int nVars() {
        return this.nbvars;
    }

    @Override
    public void expireTimeout() {
    }

    @Override
    public boolean isSatisfiable(IVecInt iVecInt, boolean bl) throws TimeoutException {
        throw new TimeoutException("There is no real solver behind!");
    }

    @Override
    public boolean isSatisfiable(boolean bl) throws TimeoutException {
        throw new TimeoutException("There is no real solver behind!");
    }

    @Override
    public void printInfos(PrintWriter printWriter, String string) {
    }

    @Override
    public void setTimeoutOnConflicts(int n) {
    }
}

