/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.apps.sudoku;

import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import org.sat4j.apps.sudoku.A4Paper;
import org.sat4j.apps.sudoku.CellGrid;
import org.sat4j.apps.sudoku.CommandHandler;
import org.sat4j.apps.sudoku.FileCommand;
import org.sat4j.apps.sudoku.MainProgramWindow;
import org.sat4j.apps.sudoku.SuDoku;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileCommandHandler
extends CommandHandler<FileCommand> {
    PageFormat pageFormat = new PageFormat();
    static final /* synthetic */ int[] $SwitchMap$org$sat4j$apps$sudoku$FileCommand;

    public FileCommandHandler(SuDoku suDoku) {
        super(suDoku);
        this.pageFormat.setPaper(new A4Paper());
    }

    void importPuzzle() {
        MainProgramWindow mainProgramWindow = this.sudoku.getMainProgramWindow();
        if (mainProgramWindow.isApplet()) {
            this.sudoku.getGui().setResult("Can't read files from an applet - use Edit menu");
        } else if (!mainProgramWindow.fileAccess()) {
            this.sudoku.getGui().setResult("No access to files");
        } else {
            String string = mainProgramWindow.readFile();
            CellGrid cellGrid = this.sudoku.getGui().getCellGrid();
            cellGrid.clearProtection();
            cellGrid.clearAll();
            this.sudoku.getGui().getCellGrid().importString(string);
            this.sudoku.getGui().setProtection(true);
        }
    }

    void exportPuzzle() {
        MainProgramWindow mainProgramWindow = this.sudoku.getMainProgramWindow();
        if (mainProgramWindow.isApplet()) {
            this.sudoku.getGui().setResult("Can't write to files from an applet - use Edit menu");
        } else if (!mainProgramWindow.fileAccess()) {
            this.sudoku.getGui().setResult("No access to files");
        } else {
            String string = this.sudoku.getGui().getCellGrid().exportString();
            mainProgramWindow.writeFile(string);
        }
    }

    void importModel() {
        MainProgramWindow mainProgramWindow = this.sudoku.getMainProgramWindow();
        if (mainProgramWindow.isApplet()) {
            this.sudoku.getGui().setResult("Can't read files from an applet - use tab \"cnf\"");
        } else if (!mainProgramWindow.fileAccess()) {
            this.sudoku.getGui().setResult("No access to files");
        } else {
            String string = mainProgramWindow.readFile();
            this.sudoku.getGui().setCNFModel(string);
            CellGrid cellGrid = this.sudoku.getGui().getCellGrid();
            cellGrid.clearComputers();
            this.sudoku.interpretModel(cellGrid);
        }
    }

    void exportInstance() {
        MainProgramWindow mainProgramWindow = this.sudoku.getMainProgramWindow();
        if (mainProgramWindow.isApplet()) {
            this.sudoku.getGui().setResult("Can't write to files from an applet - use tab \"cnf\"");
        } else if (!mainProgramWindow.fileAccess()) {
            this.sudoku.getGui().setResult("No access to files");
        } else {
            this.sudoku.fullCNF(this.sudoku.getGui().getCellGrid());
            String string = this.sudoku.getGui().getCNFFile();
            mainProgramWindow.writeFile(string);
        }
    }

    void processPrint() {
        try {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            printerJob.setPrintable(this.sudoku.getGui().getCellGrid(), this.pageFormat);
            if (printerJob.printDialog()) {
                printerJob.print();
            }
        }
        catch (PrinterException printerException) {
            printerException.printStackTrace();
        }
    }

    void processPageSetup() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        this.pageFormat = printerJob.pageDialog(this.pageFormat);
    }

    @Override
    public void execute(Enum<FileCommand> enum_) {
        switch ((FileCommand)enum_) {
            case IMPORT_PUZZLE: {
                this.importPuzzle();
                break;
            }
            case EXPORT_PUZZLE: {
                this.exportPuzzle();
                break;
            }
            case IMPORT_CNF_MODEL: {
                this.importModel();
                break;
            }
            case EXPORT_CNF_INSTANCE: {
                this.exportInstance();
                break;
            }
            case PAGE_SETUP: {
                this.processPageSetup();
                break;
            }
            case PRINT: {
                this.processPrint();
                break;
            }
            case EXIT: {
                if (this.sudoku.getMainProgramWindow().isApplet()) {
                    this.sudoku.getGui().setResult("Can't exit from an applet");
                    break;
                }
                System.exit(0);
            }
        }
    }

    static {
        $SwitchMap$org$sat4j$apps$sudoku$FileCommand = new int[FileCommand.values().length];
        try {
            FileCommandHandler.$SwitchMap$org$sat4j$apps$sudoku$FileCommand[FileCommand.IMPORT_PUZZLE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        try {
            FileCommandHandler.$SwitchMap$org$sat4j$apps$sudoku$FileCommand[FileCommand.EXPORT_PUZZLE.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        try {
            FileCommandHandler.$SwitchMap$org$sat4j$apps$sudoku$FileCommand[FileCommand.IMPORT_CNF_MODEL.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        try {
            FileCommandHandler.$SwitchMap$org$sat4j$apps$sudoku$FileCommand[FileCommand.EXPORT_CNF_INSTANCE.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        try {
            FileCommandHandler.$SwitchMap$org$sat4j$apps$sudoku$FileCommand[FileCommand.PAGE_SETUP.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        try {
            FileCommandHandler.$SwitchMap$org$sat4j$apps$sudoku$FileCommand[FileCommand.PRINT.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        try {
            FileCommandHandler.$SwitchMap$org$sat4j$apps$sudoku$FileCommand[FileCommand.EXIT.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
    }
}

