/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.apps.sudoku;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.BevelBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.sat4j.apps.sudoku.CellStatus;
import org.sat4j.apps.sudoku.GUIInput;
import org.sat4j.apps.sudoku.OneCell;

public class GraphicalOneCell
extends JLabel
implements OneCell,
ActionListener,
MouseWheelListener {
    public static final int CELL_WIDTH = 64;
    public static final int CELL_HEIGHT = 64;
    int max;
    boolean protcted;
    GUIInput guiInput;
    CellStatus status;
    Color[] colors;
    static Color[] nullColors;
    JPopupMenu popup;
    static ImageIcon[] images;
    int value = 0;
    public static final int USER_COLOR_ID = 0;
    public static final int SOLVER_COLOR_ID = 1;
    public static final int HIGHLIGHT_COLOR_ID = 2;
    public static final int DISABLED_COLOR_ID = 3;
    public static final int PROTECTED_COLOR_ID = 4;
    public static final int BACKGROUND_COLOR_ID = 5;
    public static final int UNUSED_COLOR_ID = 6;
    static /* synthetic */ Class class$org$sat4j$apps$sudoku$GraphicalOneCell;
    static final /* synthetic */ int[] $SwitchMap$org$sat4j$apps$sudoku$CellStatus;

    public static void defaultOrder() {
        for (int i = 0; i < 43; ++i) {
            URL uRL = (class$org$sat4j$apps$sudoku$GraphicalOneCell == null ? GraphicalOneCell.class$("org.sat4j.apps.sudoku.GraphicalOneCell") : class$org$sat4j$apps$sudoku$GraphicalOneCell).getResource("images/mahjongg-" + i + ".jpg");
            GraphicalOneCell.images[i] = new ImageIcon(uRL);
        }
    }

    public static void bambooOrder() {
        GraphicalOneCell.defaultOrder();
        GraphicalOneCell.changeOrder(24);
    }

    public static void signsOrder() {
        GraphicalOneCell.defaultOrder();
        GraphicalOneCell.changeOrder(15);
    }

    private static void changeOrder(int n) {
        GraphicalOneCell.defaultOrder();
        for (int i = 0; i < 9; ++i) {
            ImageIcon imageIcon = images[i];
            GraphicalOneCell.images[i] = images[i + n];
            GraphicalOneCell.images[i + n] = imageIcon;
        }
    }

    public GraphicalOneCell(GUIInput gUIInput, Color[] colorArray) {
        super(images[42]);
        this.guiInput = gUIInput;
        this.status = CellStatus.USER_ENTERED;
        this.colors = colorArray;
        this.setFont(this.getFont().deriveFont(1, 18.0f));
        this.setHorizontalAlignment(0);
        this.unHighlight();
        this.addMouseWheelListener(this);
    }

    public GraphicalOneCell() {
        this(null, nullColors);
    }

    public void protect() {
        this.protcted = true;
        this.setStatus(CellStatus.PROTECTED);
    }

    public void protectIfNotClear() {
        if (this.value > 0) {
            this.protect();
        }
    }

    public boolean getProtected() {
        return this.protcted;
    }

    public void clearProtection() {
        this.protcted = false;
        this.setStatus(CellStatus.USER_ENTERED);
    }

    public GraphicalOneCell(int n, GUIInput gUIInput, Color[] colorArray) {
        this(gUIInput, colorArray);
        this.max = n;
        this.protcted = false;
        this.updateContextualMenu();
        PopupListener popupListener = new PopupListener();
        this.addMouseListener(popupListener);
    }

    public void setColors(Color[] colorArray) {
        this.colors = colorArray;
        this.refresh();
    }

    public GraphicalOneCell(int n) {
        this(n, null, nullColors);
    }

    public void setMax(int n) {
        this.max = n;
    }

    public String getaText() {
        if (this.value == 0) {
            return "";
        }
        return "" + this.value;
    }

    public int getIntValue() {
        return this.value;
    }

    public void setIntValue(int n) {
        if (!this.protcted) {
            if (n == 0) {
                this.setIcon(images[42]);
            } else {
                this.setIcon(images[n - 1]);
            }
            this.value = n;
        }
    }

    public void setIntValue(String string) {
        if (!this.protcted) {
            this.value = Integer.parseInt(string);
            this.setIcon(images[Integer.parseInt(string) - 1]);
        }
    }

    public void setIntValue(Icon icon) {
        if (!this.protcted) {
            if (icon == images[42]) {
                this.value = 0;
            } else {
                for (int i = 0; i <= this.max; ++i) {
                    if (images[i] != icon) continue;
                    this.value = i + 1;
                    break;
                }
            }
            this.setIcon(icon);
        }
    }

    public void solverSetIntValue(int n) {
        if (!this.protcted && this.value == 0) {
            this.setIcon(images[n - 1]);
            this.value = n;
            this.setStatus(CellStatus.SOLVER_ENTERED);
        }
    }

    public void clear() {
        this.unHighlight();
        if (!this.protcted) {
            this.setIcon(images[42]);
            this.setStatus(CellStatus.USER_ENTERED);
            this.value = 0;
        }
    }

    public void clearComputers() {
        this.unHighlight();
        if (!this.protcted && this.status == CellStatus.SOLVER_ENTERED) {
            this.setIcon(images[42]);
            this.setStatus(CellStatus.USER_ENTERED);
            this.value = 0;
        }
    }

    public void highlight() {
        this.setBackground(this.colors[2]);
        this.setEnabled(false);
    }

    public void unHighlight() {
        this.setStatus(this.status);
        this.setEnabled(true);
    }

    public void refresh() {
        this.setStatus(this.status);
        this.setEnabled(true);
    }

    public void setStatus(CellStatus cellStatus) {
        this.status = cellStatus;
        switch ($SwitchMap$org$sat4j$apps$sudoku$CellStatus[cellStatus.ordinal()]) {
            case 1: {
                this.setBackground(this.colors[5]);
                this.setForeground(this.colors[4]);
                this.setToolTipText(this.guiInput.suDokuResources.getStringFromKey("TOOLTIP_CELL_PROTECTED"));
                this.setBorder(new BevelBorder(1));
                break;
            }
            case 2: {
                this.setForeground(this.colors[0]);
                this.setBackground(this.colors[5]);
                this.setToolTipText(this.guiInput.suDokuResources.getStringFromKey("TOOLTIP_CELL_NOT_PROTECTED_GRAPH"));
                this.setBorder(new BevelBorder(0));
                break;
            }
            case 3: {
                this.setForeground(this.colors[1]);
                this.setBackground(this.colors[5]);
                this.setToolTipText(this.guiInput.suDokuResources.getStringFromKey("TOOLTIP_CELL_COMPUTER"));
                this.setBorder(new BevelBorder(0));
            }
        }
    }

    public CellStatus getStatus() {
        return this.status;
    }

    public static int getNumberOfColours() {
        return 6;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Icon icon = ((JMenuItem)actionEvent.getSource()).getIcon();
        this.setIntValue(icon);
        this.refresh();
    }

    public void updateContextualMenu() {
        this.popup = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(images[42]);
        jMenuItem.addActionListener(this);
        this.popup.add(jMenuItem);
        for (int i = 1; i <= this.max; ++i) {
            ImageIcon imageIcon = images[i - 1];
            jMenuItem = new JMenuItem(imageIcon);
            jMenuItem.addActionListener(this);
            this.popup.add(jMenuItem);
        }
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n = (this.value + mouseWheelEvent.getUnitsToScroll() / 3) % (this.max + 1);
        if (n < 0) {
            n += this.max + 1;
        }
        this.setIntValue(n);
    }

    static {
        $SwitchMap$org$sat4j$apps$sudoku$CellStatus = new int[CellStatus.values().length];
        try {
            GraphicalOneCell.$SwitchMap$org$sat4j$apps$sudoku$CellStatus[CellStatus.PROTECTED.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        try {
            GraphicalOneCell.$SwitchMap$org$sat4j$apps$sudoku$CellStatus[CellStatus.USER_ENTERED.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        try {
            GraphicalOneCell.$SwitchMap$org$sat4j$apps$sudoku$CellStatus[CellStatus.SOLVER_ENTERED.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        nullColors = new Color[]{Color.BLACK, Color.WHITE, Color.RED, Color.WHITE, Color.RED, Color.WHITE};
        images = new ImageIcon[43];
        GraphicalOneCell.defaultOrder();
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
            GraphicalOneCell.this.refresh();
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (!GraphicalOneCell.this.protcted && mouseEvent.isPopupTrigger()) {
                GraphicalOneCell.this.setBackground(Color.DARK_GRAY);
                GraphicalOneCell.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public class BoundedIntegerDocument
    extends PlainDocument {
        BoundedIntegerDocument() {
        }

        public void remove(int n, int n2) throws BadLocationException {
            if (GraphicalOneCell.this.status != CellStatus.PROTECTED) {
                super.remove(n, n2);
            }
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null || GraphicalOneCell.this.status == CellStatus.PROTECTED) {
                return;
            }
            GraphicalOneCell.this.unHighlight();
            if (n == 0 && string.length() == 0) {
                GraphicalOneCell.this.setStatus(CellStatus.USER_ENTERED);
                super.insertString(n, string, attributeSet);
                return;
            }
            boolean bl = false;
            try {
                int n2 = Integer.parseInt(GraphicalOneCell.this.getaText() + string);
                boolean bl2 = bl = n2 >= 1 && n2 <= GraphicalOneCell.this.max;
                if (bl) {
                    GraphicalOneCell.this.setStatus(CellStatus.USER_ENTERED);
                    super.insertString(n, string, attributeSet);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

