/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools.xplain;

import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.SolverDecorator;
import org.sat4j.tools.xplain.ReplayXplainStrategy;
import org.sat4j.tools.xplain.XplainStrategy;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Xplain<T extends ISolver>
extends SolverDecorator<T> {
    private int nborigvars;
    private int nbnewvar;
    protected IVec<IConstr> constrs = new Vec<IConstr>();
    protected IVecInt assump;
    private static final XplainStrategy xplainStrategy;
    private static final long serialVersionUID = 1L;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$sat4j$tools$xplain$Xplain;

    public Xplain(T t) {
        super(t);
    }

    @Override
    public int newVar(int n) {
        this.nborigvars = super.newVar(n);
        return this.nborigvars;
    }

    @Override
    public IConstr addClause(IVecInt iVecInt) throws ContradictionException {
        int n = this.createNewVar();
        iVecInt.push(n);
        IConstr iConstr = super.addClause(iVecInt);
        this.constrs.push(iConstr);
        if (!$assertionsDisabled && this.constrs.size() != this.nbnewvar) {
            throw new AssertionError((Object)new StringBuffer().append("").append(this.constrs.size()).append("!=").append(this.nbnewvar).toString());
        }
        return iConstr;
    }

    protected int createNewVar() {
        return this.nborigvars + ++this.nbnewvar;
    }

    protected void discardLastestVar() {
        --this.nbnewvar;
    }

    protected int getNumberOfNewVars() {
        return this.nbnewvar;
    }

    @Override
    public IConstr addAtLeast(IVecInt iVecInt, int n) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstr addAtMost(IVecInt iVecInt, int n) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    public IVecInt explain() throws TimeoutException {
        if (!$assertionsDisabled && this.isSatisfiable(this.assump)) {
            throw new AssertionError();
        }
        return xplainStrategy.explain((ISolver)this.decorated(), this.nbnewvar, this.nborigvars, this.constrs, this.assump);
    }

    public IVec<IConstr> getConstraints() {
        return this.constrs;
    }

    public int getMaxOriginalVarId() {
        return this.nborigvars;
    }

    @Override
    public void reset() {
        super.reset();
        this.nbnewvar = 0;
    }

    @Override
    public int[] findModel() throws TimeoutException {
        this.assump = VecInt.EMPTY;
        VecInt vecInt = new VecInt();
        for (int i = 0; i < this.nbnewvar; ++i) {
            vecInt.push(-(i + this.nborigvars + 1));
        }
        return super.findModel(vecInt);
    }

    @Override
    public int[] findModel(IVecInt iVecInt) throws TimeoutException {
        this.assump = iVecInt;
        VecInt vecInt = new VecInt();
        iVecInt.copyTo(vecInt);
        for (int i = 0; i < this.nbnewvar; ++i) {
            vecInt.push(-(i + this.nborigvars + 1));
        }
        return super.findModel(vecInt);
    }

    @Override
    public boolean isSatisfiable() throws TimeoutException {
        this.assump = VecInt.EMPTY;
        VecInt vecInt = new VecInt();
        for (int i = 0; i < this.nbnewvar; ++i) {
            vecInt.push(-(i + this.nborigvars + 1));
        }
        return super.isSatisfiable(vecInt);
    }

    @Override
    public boolean isSatisfiable(boolean bl) throws TimeoutException {
        this.assump = VecInt.EMPTY;
        VecInt vecInt = new VecInt();
        for (int i = 0; i < this.nbnewvar; ++i) {
            vecInt.push(-(i + this.nborigvars + 1));
        }
        return super.isSatisfiable(vecInt, bl);
    }

    @Override
    public boolean isSatisfiable(IVecInt iVecInt) throws TimeoutException {
        this.assump = iVecInt;
        VecInt vecInt = new VecInt();
        iVecInt.copyTo(vecInt);
        for (int i = 0; i < this.nbnewvar; ++i) {
            vecInt.push(-(i + this.nborigvars + 1));
        }
        return super.isSatisfiable(vecInt);
    }

    @Override
    public boolean isSatisfiable(IVecInt iVecInt, boolean bl) throws TimeoutException {
        this.assump = iVecInt;
        VecInt vecInt = new VecInt();
        iVecInt.copyTo(vecInt);
        for (int i = 0; i < this.nbnewvar; ++i) {
            vecInt.push(-(i + this.nborigvars + 1));
        }
        return super.isSatisfiable(vecInt, bl);
    }

    @Override
    public int[] model() {
        int[] nArray = super.model();
        int n = Math.min(this.nborigvars, nArray.length) - 1;
        while (Math.abs(nArray[n]) > this.nborigvars) {
            --n;
        }
        int[] nArray2 = new int[n + 1];
        for (int i = 0; i <= n; ++i) {
            nArray2[i] = nArray[i];
        }
        return nArray2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        $assertionsDisabled = !(class$org$sat4j$tools$xplain$Xplain == null ? (class$org$sat4j$tools$xplain$Xplain = Xplain.class$("org.sat4j.tools.xplain.Xplain")) : class$org$sat4j$tools$xplain$Xplain).desiredAssertionStatus();
        xplainStrategy = new ReplayXplainStrategy();
    }
}

