/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j;

import java.io.PrintWriter;
import org.sat4j.AbstractLauncher;
import org.sat4j.ExitCode;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.TimeoutException;

public abstract class AbstractOptimizationLauncher
extends AbstractLauncher {
    private static final String CURRENT_OPTIMUM_VALUE_PREFIX = "o ";

    protected void displayResult() {
        if (this.solver == null) {
            return;
        }
        PrintWriter out = this.getLogWriter();
        this.solver.printStat(out, "c ");
        ExitCode exitCode = this.getExitCode();
        out.println("s " + (Object)((Object)exitCode));
        if (exitCode == ExitCode.SATISFIABLE || exitCode == ExitCode.OPTIMUM_FOUND) {
            out.print("v ");
            this.getReader().decode(this.solver.model(), new PrintWriter(System.out));
            out.println();
            IOptimizationProblem optproblem = (IOptimizationProblem)((Object)this.solver);
            if (!optproblem.hasNoObjectiveFunction()) {
                this.log("objective function=" + optproblem.calculateObjective());
            }
        }
        this.log("Total wall clock time (ms): " + (double)(System.currentTimeMillis() - this.getBeginTime()) / 1000.0);
    }

    protected void solve(IProblem problem) throws TimeoutException {
        boolean isSatisfiable = false;
        IOptimizationProblem optproblem = (IOptimizationProblem)problem;
        try {
            while (optproblem.admitABetterSolution()) {
                if (!isSatisfiable) {
                    if (optproblem.nonOptimalMeansSatisfiable()) {
                        this.setExitCode(ExitCode.SATISFIABLE);
                        if (optproblem.hasNoObjectiveFunction()) {
                            return;
                        }
                        this.log("SATISFIABLE");
                    }
                    isSatisfiable = true;
                    this.log("OPTIMIZING...");
                }
                this.log("Got one! Elapsed wall clock time (in seconds):" + (double)(System.currentTimeMillis() - this.getBeginTime()) / 1000.0);
                this.getLogWriter().println(CURRENT_OPTIMUM_VALUE_PREFIX + optproblem.calculateObjective());
                optproblem.discard();
            }
            if (isSatisfiable) {
                this.setExitCode(ExitCode.OPTIMUM_FOUND);
            } else {
                this.setExitCode(ExitCode.UNSATISFIABLE);
            }
        }
        catch (ContradictionException ex) {
            assert (isSatisfiable);
            this.setExitCode(ExitCode.OPTIMUM_FOUND);
        }
    }
}

