/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j;

import java.io.PrintWriter;
import org.sat4j.AbstractLauncher;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.reader.CSPExtSupportReader;
import org.sat4j.reader.Reader;
import org.sat4j.reader.XMLCSPReader;
import org.sat4j.specs.ISolver;

public class CSPLauncher
extends AbstractLauncher {
    private static final long serialVersionUID = 1L;

    protected ISolver configureSolver(String[] args) {
        return SolverFactory.newMiniSAT2Heap();
    }

    protected Reader createReader(ISolver solver, String problemname) {
        Reader reader;
        if (problemname.endsWith(".txt")) {
            reader = new CSPExtSupportReader(solver);
        } else {
            assert (problemname.endsWith(".xml"));
            reader = new XMLCSPReader(solver);
        }
        if (System.getProperty("verbose") != null) {
            this.log("verbose mode on");
            reader.setVerbosity(true);
        }
        return reader;
    }

    protected void displayResult() {
        switch (this.getExitCode()) {
            case SATISFIABLE: {
                System.out.println("SAT");
                int[] model = this.solver.model();
                this.getReader().decode(model, new PrintWriter(System.out));
                break;
            }
            case UNSATISFIABLE: {
                System.out.println("UNSAT");
                break;
            }
        }
        System.out.println("c  Total elapsed time (wall clock):" + (double)(System.currentTimeMillis() - this.getBeginTime()) / 1000.0);
    }

    public static void main(String[] args) {
        CSPLauncher lanceur = new CSPLauncher();
        lanceur.run(args);
    }

    protected void usage() {
        System.out.println("java -jar sat4jCSP instance-name-without-suffix");
    }

    protected String getInstanceName(String[] args) {
        assert (args.length == 1);
        return args[0];
    }
}

